/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.util.IEnergyHandlerAsync;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class MachineComponent<T> {
    public final IOType ioType;

    public MachineComponent(IOType ioType) {
        this.ioType = ioType;
    }

    public IOType getIOType() {
        return this.ioType;
    }

    public boolean isAsyncSupported() {
        return true;
    }

    public abstract ComponentType getComponentType();

    public abstract T getContainerProvider();

    public static abstract class EnergyHatch
    extends MachineComponent<IEnergyHandlerAsync> {
        public EnergyHatch(IOType ioType) {
            super(ioType);
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentTypesMM.COMPONENT_ENERGY;
        }
    }

    public static abstract class FluidHatch
    extends MachineComponent<IFluidHandler> {
        public FluidHatch(IOType ioType) {
            super(ioType);
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentTypesMM.COMPONENT_FLUID;
        }
    }

    public static abstract class ItemBus
    extends MachineComponent<IItemHandlerModifiable> {
        public ItemBus(IOType ioType) {
            super(ioType);
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentTypesMM.COMPONENT_ITEM;
        }
    }
}

