/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.RecipeFailureActions;
import java.lang.reflect.Type;
import net.minecraft.util.JsonUtils;

public class DynamicMachinePreDeserializer
implements JsonDeserializer<DynamicMachine> {
    public DynamicMachine deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject root = json.getAsJsonObject();
        String registryName = DynamicMachinePreDeserializer.getRegistryName(root);
        String localized = DynamicMachinePreDeserializer.getLocalizedName(root);
        DynamicMachine machine = new DynamicMachine(registryName);
        machine.setLocalizedName(localized);
        if (root.has("prefix")) {
            machine.setPrefix(DynamicMachinePreDeserializer.getPrefix(root));
        }
        if (root.has("failure-action")) {
            machine.setFailureAction(DynamicMachinePreDeserializer.getFailureActions(root));
        }
        if (root.has("requires-blueprint")) {
            machine.setRequiresBlueprint(DynamicMachinePreDeserializer.getRequireBlueprint(root));
        }
        if (root.has("color")) {
            machine.setDefinedColor(DynamicMachinePreDeserializer.getColor(root));
        }
        if (root.has("has-factory")) {
            machine.setHasFactory(DynamicMachinePreDeserializer.getHasFactory(root));
        }
        if (root.has("factory-only")) {
            machine.setFactoryOnly(DynamicMachinePreDeserializer.getFactoryOnly(root));
        }
        return machine;
    }

    public static String getRegistryName(JsonObject root) throws JsonParseException {
        String registryName = JsonUtils.func_151219_a((JsonObject)root, (String)"registryname", (String)"");
        if (registryName.isEmpty() && (registryName = JsonUtils.func_151219_a((JsonObject)root, (String)"registryName", (String)"")).isEmpty()) {
            throw new JsonParseException("Invalid/Missing 'registryname' !");
        }
        return registryName;
    }

    public static String getPrefix(JsonObject root) throws JsonParseException {
        String localized = JsonUtils.func_151219_a((JsonObject)root, (String)"prefix", (String)"");
        if (localized.isEmpty()) {
            throw new JsonParseException("Invalid/Missing 'prefix' !");
        }
        return localized;
    }

    public static String getLocalizedName(JsonObject root) throws JsonParseException {
        String localized = JsonUtils.func_151219_a((JsonObject)root, (String)"localizedname", (String)"");
        if (localized.isEmpty()) {
            throw new JsonParseException("Invalid/Missing 'localizedname' !");
        }
        return localized;
    }

    public static RecipeFailureActions getFailureActions(JsonObject root) throws JsonParseException {
        JsonElement failureAction = root.get("failure-action");
        if (!failureAction.isJsonPrimitive() || !failureAction.getAsJsonPrimitive().isString()) {
            throw new JsonParseException("'failure-action' has to be 'reset', 'still' or 'decrease'!");
        }
        String action = failureAction.getAsJsonPrimitive().getAsString();
        return RecipeFailureActions.getFailureAction(action);
    }

    public static boolean getRequireBlueprint(JsonObject root) throws JsonParseException {
        JsonElement elementBlueprint = root.get("requires-blueprint");
        if (!elementBlueprint.isJsonPrimitive() || !elementBlueprint.getAsJsonPrimitive().isBoolean()) {
            throw new JsonParseException("'requires-blueprint' has to be either 'true' or 'false'!");
        }
        return elementBlueprint.getAsJsonPrimitive().getAsBoolean();
    }

    public static int getColor(JsonObject root) throws JsonParseException {
        int hexColor;
        JsonElement elementColor = root.get("color");
        if (!elementColor.isJsonPrimitive()) {
            throw new JsonParseException("The Color defined in 'color' should be a hex integer number! Found " + elementColor + " instead!");
        }
        String hexStr = elementColor.getAsJsonPrimitive().getAsString();
        try {
            hexColor = Integer.parseInt(hexStr, 16);
        }
        catch (NumberFormatException parseExc) {
            throw new JsonParseException("The Color defined in 'color' should be a hex integer number! Found " + elementColor + " instead!", (Throwable)parseExc);
        }
        return hexColor;
    }

    public static boolean getHasFactory(JsonObject root) throws JsonParseException {
        JsonElement elementHasFactory = root.get("has-factory");
        if (!elementHasFactory.isJsonPrimitive() || !elementHasFactory.getAsJsonPrimitive().isBoolean()) {
            throw new JsonParseException("'has-factory' has to be either 'true' or 'false'!");
        }
        return elementHasFactory.getAsJsonPrimitive().getAsBoolean();
    }

    public static boolean getFactoryOnly(JsonObject root) throws JsonParseException {
        JsonElement elementFactoryOnly = root.get("factory-only");
        if (!elementFactoryOnly.isJsonPrimitive() || !elementFactoryOnly.getAsJsonPrimitive().isBoolean()) {
            throw new JsonParseException("'factory-only' has to be either 'true' or 'false'!");
        }
        return elementFactoryOnly.getAsJsonPrimitive().getAsBoolean();
    }
}

