/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import hellfirepvp.modularmachinery.common.util.BlockArray;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ComponentRestriction {
    private final int minimumCount;
    private final int maximumCount;
    private final List<BlockArray.BlockInformation> matching;
    private String restrictionDesc;

    public ComponentRestriction(int minimumCount, int maximumCount, List<BlockArray.BlockInformation> matching, String restrictionDesc) {
        this.minimumCount = minimumCount;
        this.maximumCount = maximumCount;
        this.matching = matching;
        this.restrictionDesc = restrictionDesc;
    }

    public String getRestrictionDesc() {
        return this.restrictionDesc;
    }

    public void setRestrictionDesc(String restrictionDesc) {
        this.restrictionDesc = restrictionDesc;
    }

    public boolean matches(World world, BlockPos pos) {
        if (world.func_175667_e(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        int matchCount = 0;
        for (BlockArray.BlockInformation information : this.matching) {
            if (!information.matchesState(world, pos, state) || ++matchCount <= this.maximumCount) continue;
            return false;
        }
        return matchCount >= this.minimumCount;
    }

    public int getMinimumCount() {
        return this.minimumCount;
    }

    public int getMaximumCount() {
        return this.maximumCount;
    }

    public List<BlockArray.BlockInformation> getMatching() {
        return this.matching;
    }
}

