/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.item;

import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.item.ItemBlockMachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockController
extends ItemBlockMachineComponent {
    private final BlockController ctrlBlock;

    public ItemBlockController(BlockController ctrlBlock) {
        super((Block)ctrlBlock);
        this.ctrlBlock = ctrlBlock;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(@Nonnull ItemStack stack) {
        return this.ctrlBlock.func_149732_F();
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
        if (super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileMultiblockMachineController) {
                TileMultiblockMachineController ctrl = (TileMultiblockMachineController)tile;
                NBTTagCompound stackTag = stack.func_77978_p();
                if (stackTag != null && stackTag.func_74764_b("owner")) {
                    String ownerUUIDStr = stackTag.func_74779_i("owner");
                    try {
                        ctrl.setOwner(UUID.fromString(ownerUUIDStr));
                    }
                    catch (Exception e) {
                        ModularMachinery.log.warn("Invalid owner uuid " + ownerUUIDStr, (Throwable)e);
                    }
                } else {
                    ctrl.setOwner(player.func_146103_bH().getId());
                }
            }
            return true;
        }
        return false;
    }
}

