/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.theoneprobe;

import com.mojang.authlib.GameProfile;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.client.util.EnergyDisplayUtil;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.integration.ModIntegrationTOP;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.RecipeThread;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import hellfirepvp.modularmachinery.common.tiles.TileParallelController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import io.netty.util.internal.ThrowableUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class MMInfoProvider
implements IProbeInfoProvider {
    public String getID() {
        return "modularmachinery:dynamic_machine_info_provider";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (!blockState.func_177230_c().hasTileEntity(blockState)) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(data.getPos());
        if (tileEntity == null) {
            return;
        }
        if (tileEntity instanceof TileMultiblockMachineController) {
            TileMultiblockMachineController machineController = (TileMultiblockMachineController)tileEntity;
            try {
                MMInfoProvider.processMultiblockMachineTOP(machineController, probeInfo, player);
            }
            catch (Exception e) {
                ModularMachinery.log.warn(ThrowableUtil.stackTraceToString((Throwable)e));
            }
        } else if (tileEntity instanceof TileParallelController) {
            TileParallelController parallelController = (TileParallelController)tileEntity;
            MMInfoProvider.processParallelControllerTOP(parallelController, probeInfo);
        }
    }

    private static void processParallelControllerTOP(TileParallelController parallelController, IProbeInfo probeInfo) {
        if (!ModIntegrationTOP.showParallelControllerInfo) {
            return;
        }
        TileParallelController.ParallelControllerProvider provider = parallelController.provideComponent();
        probeInfo.text(TextFormatting.AQUA + "{*top.parallelism*}" + TextFormatting.GREEN + provider.getParallelism());
        probeInfo.text(TextFormatting.GOLD + "{*top.max_parallelism*}" + TextFormatting.YELLOW + provider.getMaxParallelism());
    }

    private static void processMultiblockMachineTOP(TileMultiblockMachineController machine, IProbeInfo probeInfo, EntityPlayer player) {
        MinecraftServer server;
        IProbeInfo stateBox = MMInfoProvider.newVertical(probeInfo);
        UUID ownerUUID = machine.getOwner();
        if (ownerUUID != null && (server = machine.func_145831_w().func_73046_m()) != null) {
            if (ownerUUID.equals(player.func_146103_bH().getId())) {
                stateBox.text(TextFormatting.AQUA + "{*top.machine.owner*}" + TextFormatting.GREEN + "{*top.machine.owner.self*}");
            } else {
                GameProfile ownerProfile = server.func_152358_ax().func_152652_a(ownerUUID);
                if (ownerProfile == null) {
                    stateBox.text(TextFormatting.AQUA + "{*top.machine.owner*}" + TextFormatting.YELLOW + "{*top.machine.owner.unknown*}(UUID: " + ownerUUID + ")");
                } else {
                    stateBox.text(TextFormatting.AQUA + "{*top.machine.owner*}" + TextFormatting.RED + ownerProfile.getName());
                }
            }
        }
        if (!machine.isStructureFormed()) {
            stateBox.text(TextFormatting.RED + "{*top.machine.structure.none*}");
            return;
        }
        stateBox.text(TextFormatting.GREEN + "{*top.machine.structure.found*}");
        if (machine instanceof TileMachineController) {
            MMInfoProvider.processMachineControllerTOP((TileMachineController)machine, probeInfo, player);
        }
        if (machine instanceof TileFactoryController) {
            MMInfoProvider.processFactoryControllerTOP((TileFactoryController)machine, probeInfo, player);
        }
        IProbeInfo perfBox = MMInfoProvider.newVertical(probeInfo);
        perfBox.text(String.format("%sCPU Avg Usage: %s\u03bcs%s, Recipe Search: %sms", TextFormatting.AQUA, MMInfoProvider.formatCPUUsage(machine.getTimeRecorder().usedTimeAvg()), TextFormatting.AQUA, MMInfoProvider.formatRecipeSearchUsage(machine.getTimeRecorder().recipeSearchUsedTimeAvg())));
        TileMultiblockMachineController.WorkMode workMode = machine.getWorkMode();
        long groupId = machine.getExecuteGroupId();
        if (workMode == TileMultiblockMachineController.WorkMode.ASYNC && groupId != -1L) {
            perfBox.text(String.format("%sWorkMode: %s (GroupID: %s)", TextFormatting.AQUA, workMode.getDisplayName(), groupId));
        } else {
            perfBox.text(String.format("%sWorkMode: %s", TextFormatting.AQUA, workMode.getDisplayName()));
        }
    }

    private static void processFactoryControllerTOP(TileFactoryController factory, IProbeInfo probeInfo, EntityPlayer player) {
        if (factory.isWorking()) {
            MMInfoProvider.newVertical(probeInfo).text(TextFormatting.GREEN + "{*top.machine.working*}");
        } else {
            if (factory.getMaxThreads() > 0) {
                MMInfoProvider.newVertical(probeInfo).text(TextFormatting.RED + "{*" + factory.getControllerStatus().getUnlocMessage() + "*}");
            }
            if (factory.getCoreRecipeThreads().isEmpty()) {
                return;
            }
        }
        List<FactoryRecipeThread> recipeThreads = factory.getFactoryRecipeThreadList();
        Collection<FactoryRecipeThread> coreRecipeThreads = factory.getCoreRecipeThreads().values();
        AtomicLong energyConsumeTotal = new AtomicLong();
        AtomicLong energyGenerateTotal = new AtomicLong();
        MMInfoProvider.collectRequirementEnergy(coreRecipeThreads, energyConsumeTotal, energyGenerateTotal);
        MMInfoProvider.collectRequirementEnergy(recipeThreads, energyConsumeTotal, energyGenerateTotal);
        if (energyConsumeTotal.get() > 0L || energyGenerateTotal.get() > 0L) {
            IProbeInfo energyBox = MMInfoProvider.newVertical(probeInfo);
            if (energyConsumeTotal.get() > 0L) {
                MMInfoProvider.addEnergyUsageText(energyBox, player, IOType.INPUT, energyConsumeTotal.get());
            }
            if (energyGenerateTotal.get() > 0L) {
                MMInfoProvider.addEnergyUsageText(energyBox, player, IOType.OUTPUT, energyGenerateTotal.get());
            }
        }
        IProbeInfo threadBox = null;
        int maxThreads = factory.getMaxThreads();
        if (maxThreads > 0) {
            threadBox = MMInfoProvider.newVertical(probeInfo);
            threadBox.text(TextFormatting.GREEN + String.valueOf(recipeThreads.size()) + TextFormatting.AQUA + " {*top.factory.thread.running*}" + TextFormatting.RESET + " / " + TextFormatting.YELLOW + maxThreads + TextFormatting.GOLD + " {*top.factory.thread.max*}");
        }
        int trueMaxParallelism = factory.getMaxParallelism();
        if (factory.getAvailableParallelism() != trueMaxParallelism) {
            IProbeInfo parallelismBox = threadBox == null ? MMInfoProvider.newVertical(probeInfo) : threadBox;
            parallelismBox.text(TextFormatting.AQUA + "{*top.parallelism*}" + TextFormatting.GREEN + (trueMaxParallelism - factory.getAvailableParallelism() + 1));
            parallelismBox.text(TextFormatting.GOLD + "{*top.max_parallelism*}" + TextFormatting.YELLOW + trueMaxParallelism);
        }
        AtomicInteger i = new AtomicInteger();
        ArrayList<FactoryRecipeThread> recipeThreadList = new ArrayList<FactoryRecipeThread>();
        recipeThreadList.addAll(coreRecipeThreads);
        recipeThreadList.addAll(recipeThreads);
        IProbeInfo threadsProgressBox = MMInfoProvider.newVertical(probeInfo);
        recipeThreadList.stream().limit(6L).forEach(thread -> {
            String threadName;
            IProbeInfo threadProgressBox = MMInfoProvider.newVertical(threadsProgressBox);
            ActiveMachineRecipe activeRecipe = thread.getActiveRecipe();
            CraftingStatus status = thread.getStatus();
            if (thread.isCoreThread()) {
                threadName = TextFormatting.BLUE + "{*" + thread.getThreadName() + "*}";
                i.getAndIncrement();
            } else {
                threadName = TextFormatting.AQUA + "{*top.factory.thread*}" + i.getAndIncrement();
            }
            int progressBarFilledColor = ModIntegrationTOP.recipeProgressBarFilledColor;
            int progressBarAlternateFilledColor = ModIntegrationTOP.recipeProgressBarAlternateFilledColor;
            int progressBarBorderColor = ModIntegrationTOP.recipeProgressBarBorderColor;
            if (status.isCrafting()) {
                threadProgressBox.text(threadName + ": " + TextFormatting.GREEN + "{*" + status.getUnlocMessage() + "*}");
            } else {
                threadProgressBox.text(threadName + ": " + TextFormatting.RED + "{*" + status.getUnlocMessage() + "*}");
                progressBarFilledColor = ModIntegrationTOP.failureProgressBarFilledColor;
                progressBarAlternateFilledColor = ModIntegrationTOP.failureProgressBarAlternateFilledColor;
                progressBarBorderColor = ModIntegrationTOP.failureProgressBarBorderColor;
            }
            if (activeRecipe == null) {
                return;
            }
            int tick = activeRecipe.getTick();
            int totalTick = activeRecipe.getTotalTick();
            float progress = (float)(tick * 100) / (float)totalTick;
            String progressStr = player.func_70093_af() ? String.format("%.1f s / %.1f s", Float.valueOf((float)tick / 20.0f), Float.valueOf((float)totalTick / 20.0f)) : (ModIntegrationTOP.showRecipeProgressBarDecimalPoints && totalTick >= 1200 ? String.format("%.2f", Float.valueOf(progress)) + "%" : String.format("%.0f", Float.valueOf(progress)) + "%");
            IProbeInfo progressLine = threadProgressBox.horizontal(threadProgressBox.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            progressLine.text(TextFormatting.AQUA + "{*top.recipe.progress*}:  ");
            progressLine.progress((int)progress, 100, threadProgressBox.defaultProgressStyle().prefix(progressStr).filledColor(progressBarFilledColor).alternateFilledColor(progressBarAlternateFilledColor).borderColor(progressBarBorderColor).backgroundColor(ModIntegrationTOP.recipeProgressBarBackgroundColor).numberFormat(NumberFormat.NONE));
        });
    }

    private static void collectRequirementEnergy(Collection<FactoryRecipeThread> recipeThreads, AtomicLong energyConsumeTotal, AtomicLong energyGenerateTotal) {
        for (FactoryRecipeThread thread : recipeThreads) {
            long required;
            if (thread.isIdle()) continue;
            RequirementEnergy req = MMInfoProvider.getRequirementEnergy(thread, IOType.INPUT);
            if (req != null) {
                required = MMInfoProvider.getEnergyRequired(thread, req);
                energyConsumeTotal.addAndGet(required);
            }
            if ((req = MMInfoProvider.getRequirementEnergy(thread, IOType.OUTPUT)) == null) continue;
            required = MMInfoProvider.getEnergyRequired(thread, req);
            energyGenerateTotal.addAndGet(required);
        }
    }

    private static void processMachineControllerTOP(TileMachineController machine, IProbeInfo probeInfo, EntityPlayer player) {
        IProbeInfo statusBox = MMInfoProvider.newVertical(probeInfo);
        if (machine.getActiveRecipe() == null || machine.getFoundMachine() == null) {
            statusBox.text(TextFormatting.RED + "{*" + machine.getControllerStatus().getUnlocMessage() + "*}");
            return;
        }
        int progressBarFilledColor = ModIntegrationTOP.recipeProgressBarFilledColor;
        int progressBarAlternateFilledColor = ModIntegrationTOP.recipeProgressBarAlternateFilledColor;
        int progressBarBorderColor = ModIntegrationTOP.recipeProgressBarBorderColor;
        if (machine.getControllerStatus().isCrafting()) {
            statusBox.text(TextFormatting.GREEN + "{*top.machine.working*}");
        } else {
            statusBox.text(TextFormatting.RED + "{*" + machine.getControllerStatus().getUnlocMessage() + "*}");
            progressBarFilledColor = ModIntegrationTOP.failureProgressBarFilledColor;
            progressBarAlternateFilledColor = ModIntegrationTOP.failureProgressBarAlternateFilledColor;
            progressBarBorderColor = ModIntegrationTOP.failureProgressBarBorderColor;
        }
        RecipeThread thread = machine.getRecipeThreadList()[0];
        RequirementEnergy reqEnergyIn = MMInfoProvider.getRequirementEnergy(thread, IOType.INPUT);
        RequirementEnergy reqEnergyOut = MMInfoProvider.getRequirementEnergy(thread, IOType.OUTPUT);
        if (reqEnergyIn != null || reqEnergyOut != null) {
            IProbeInfo energyBox = MMInfoProvider.newVertical(probeInfo);
            if (reqEnergyIn != null) {
                long energyUsage = MMInfoProvider.getEnergyRequired(thread, reqEnergyIn);
                MMInfoProvider.addEnergyUsageText(energyBox, player, IOType.INPUT, energyUsage);
            }
            if (reqEnergyOut != null) {
                long energyGenerate = MMInfoProvider.getEnergyRequired(thread, reqEnergyOut);
                MMInfoProvider.addEnergyUsageText(energyBox, player, IOType.OUTPUT, energyGenerate);
            }
        }
        ActiveMachineRecipe activeRecipe = machine.getActiveRecipe();
        int tick = activeRecipe.getTick();
        int totalTick = activeRecipe.getTotalTick();
        float progress = (float)(tick * 100) / (float)totalTick;
        if (activeRecipe.getParallelism() > 1) {
            IProbeInfo parallelismBox = MMInfoProvider.newVertical(probeInfo);
            parallelismBox.text(TextFormatting.AQUA + "{*top.parallelism*}" + TextFormatting.GREEN + activeRecipe.getParallelism());
            parallelismBox.text(TextFormatting.GOLD + "{*top.max_parallelism*}" + TextFormatting.YELLOW + activeRecipe.getMaxParallelism());
        }
        String progressStr = player.func_70093_af() ? String.format("%.1f s / %.1f s", Float.valueOf((float)tick / 20.0f), Float.valueOf((float)totalTick / 20.0f)) : (ModIntegrationTOP.showRecipeProgressBarDecimalPoints && totalTick >= 1200 ? String.format("%.2f", Float.valueOf(progress)) + "%" : String.format("%.0f", Float.valueOf(progress)) + "%");
        IProbeInfo progressLine = statusBox.horizontal(statusBox.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
        progressLine.text("{*top.recipe.progress*}:  ");
        progressLine.progress((int)progress, 100, statusBox.defaultProgressStyle().prefix(progressStr).filledColor(progressBarFilledColor).alternateFilledColor(progressBarAlternateFilledColor).borderColor(progressBarBorderColor).backgroundColor(ModIntegrationTOP.recipeProgressBarBackgroundColor).numberFormat(NumberFormat.NONE));
    }

    private static long getEnergyRequired(RecipeThread thread, RequirementEnergy energy) {
        RecipeCraftingContext context = thread.getContext();
        if (context == null) {
            return 0L;
        }
        long reqPerTick = energy.getRequiredEnergyPerTick();
        int parallelism = energy.getParallelism();
        float durationMul = context.getDurationMultiplier();
        return Math.round(RecipeModifier.applyModifiers(context, energy, (double)reqPerTick, false) * (double)durationMul * (double)parallelism);
    }

    private static RequirementEnergy getRequirementEnergy(RecipeThread thread, IOType ioType) {
        RecipeCraftingContext context = thread.getContext();
        if (context == null) {
            return null;
        }
        List<ComponentRequirement<?, ?>> energyRequirements = context.getRequirementBy(RequirementTypesMM.REQUIREMENT_ENERGY, ioType);
        if (energyRequirements.isEmpty()) {
            return null;
        }
        return (RequirementEnergy)energyRequirements.get(0);
    }

    private static void addEnergyUsageText(IProbeInfo probe, EntityPlayer player, IOType ioType, long usagePerTick) {
        if (ioType == IOType.INPUT) {
            probe.text(TextFormatting.AQUA + "{*top.energy.input*}" + TextFormatting.RED + MMInfoProvider.formatEnergyUsage(player, usagePerTick) + " {*" + EnergyDisplayUtil.type.getUnlocalizedFormat() + "*}/t");
        } else if (ioType == IOType.OUTPUT) {
            probe.text(TextFormatting.AQUA + "{*top.energy.output*}" + TextFormatting.RED + MMInfoProvider.formatEnergyUsage(player, usagePerTick) + " {*" + EnergyDisplayUtil.type.getUnlocalizedFormat() + "*}/t");
        }
    }

    private static String formatEnergyUsage(EntityPlayer player, long usagePerTick) {
        return player.func_70093_af() ? MiscUtils.formatNumber(EnergyDisplayUtil.type.formatEnergyForDisplay(usagePerTick)) : MiscUtils.formatDecimal(EnergyDisplayUtil.type.formatEnergyForDisplay(usagePerTick));
    }

    private static String formatCPUUsage(int time) {
        String prefix = time <= 100 ? TextFormatting.GREEN.toString() : (time <= 150 ? TextFormatting.YELLOW.toString() : (time <= 250 ? TextFormatting.GOLD.toString() : TextFormatting.RED.toString()));
        return prefix + "~" + MiscUtils.formatDecimal(time);
    }

    private static String formatRecipeSearchUsage(float time) {
        float convertedMs = time / 1000.0f;
        String prefix = convertedMs <= 1.0f ? TextFormatting.GREEN.toString() : (convertedMs <= 2.5f ? TextFormatting.YELLOW.toString() : (convertedMs <= 5.0f ? TextFormatting.GOLD.toString() : TextFormatting.RED.toString()));
        return prefix + "~" + MiscUtils.formatFloat(convertedMs, 2);
    }

    private static IProbeInfo newVertical(IProbeInfo info) {
        return info.vertical(info.defaultLayoutStyle().spacing(0).borderColor(Integer.valueOf(-2145480449)));
    }
}

