/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.ingredient;

import hellfirepvp.modularmachinery.common.integration.ingredient.IngredientItemStack;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.plugins.vanilla.ingredients.item.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;

public class IngredientItemStackRenderer
extends ItemStackRenderer {
    public static final IngredientItemStackRenderer DEFAULT_INSTANCE = new IngredientItemStackRenderer(Collections.emptyList());
    private final List<IngredientItemStack> preDefined = new ArrayList<IngredientItemStack>();

    public IngredientItemStackRenderer(List<IngredientItemStack> preDefined) {
        this.preDefined.addAll(preDefined);
    }

    public static void renderRequirementOverlyIntoGUI(FontRenderer fr, int xPos, int yPos, int min, int max) {
        String s;
        float scale;
        float smallScale = 0.5f;
        float defaultScale = 1.0f;
        if (min == max) {
            if (min <= 1) {
                return;
            }
            scale = min >= 1000 ? smallScale : defaultScale;
            s = String.format("%s", IngredientItemStackRenderer.isShiftDown() ? Integer.valueOf(min) : MiscUtils.formatNumberToInt(min));
        } else {
            scale = smallScale;
            s = String.format("%s~%s", MiscUtils.formatNumberToInt(min), MiscUtils.formatNumberToInt(max));
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)160.0f);
        boolean unicodeFlag = fr.func_82883_a();
        if (scale == smallScale) {
            fr.func_78264_a(false);
            fr.func_175063_a(s, ((float)(xPos + 16) - (float)fr.func_78256_a(s) * scale) / scale, (float)(yPos + 12) / scale, 0xFFFFFF);
        } else {
            fr.func_175063_a(s, (float)(xPos + 17 - fr.func_78256_a(s)), (float)(yPos + 9), 0xFFFFFF);
        }
        fr.func_78264_a(unicodeFlag);
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        GlStateManager.func_179145_e();
    }

    protected static boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public void render(@Nonnull Minecraft minecraft, int xPos, int yPos, @Nullable ItemStack stack) {
        if (stack == null) {
            return;
        }
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
        FontRenderer font = this.getFontRenderer(minecraft, stack);
        minecraft.func_175599_af().func_184391_a(null, stack, xPos, yPos);
        IngredientItemStack ingredient = this.findStack(stack);
        if (ingredient == null) {
            IngredientItemStackRenderer.renderRequirementOverlyIntoGUI(font, xPos, yPos, stack.func_190916_E(), stack.func_190916_E());
            minecraft.func_175599_af().func_180453_a(font, stack, xPos, yPos, "");
            return;
        }
        int min = ingredient.min();
        int max = ingredient.max();
        IngredientItemStackRenderer.renderRequirementOverlyIntoGUI(font, xPos, yPos, min, max);
        minecraft.func_175599_af().func_180453_a(font, stack, xPos, yPos, "");
        GlStateManager.func_179084_k();
        RenderHelper.func_74518_a();
    }

    @Nullable
    protected IngredientItemStack findStack(ItemStack stack) {
        if (this.preDefined.isEmpty()) {
            return null;
        }
        return this.preDefined.stream().filter(ingredient -> ingredient.stack() == stack).findFirst().orElse(null);
    }
}

