/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker.upgrade;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.client.ControllerGUIRenderEvent;
import github.kasuminova.mmce.common.event.machine.MachineEvent;
import github.kasuminova.mmce.common.event.machine.MachineStructureFormedEvent;
import github.kasuminova.mmce.common.event.machine.MachineStructureUpdateEvent;
import github.kasuminova.mmce.common.event.machine.MachineTickEvent;
import github.kasuminova.mmce.common.event.machine.SmartInterfaceUpdateEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeTickEvent;
import github.kasuminova.mmce.common.upgrade.SimpleMachineUpgrade;
import github.kasuminova.mmce.common.upgrade.UpgradeType;
import github.kasuminova.mmce.common.upgrade.registry.RegistryUpgrade;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.MachineModifier;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.IFunction;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.UpgradeEventHandlerCT;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.MachineUpgradeBuilder")
public class MachineUpgradeBuilder {
    private final SimpleMachineUpgrade machineUpgrade;

    public MachineUpgradeBuilder(SimpleMachineUpgrade machineUpgrade) {
        this.machineUpgrade = machineUpgrade;
    }

    @ZenMethod
    public static MachineUpgradeBuilder newBuilder(String name, String localizedName, float level, int maxStack) {
        if (RegistryUpgrade.getUpgrade(name) != null) {
            CraftTweakerAPI.logError((String)("[ModularMachinery] Already registered SimpleMachineUpgrade " + name + '!'));
            return null;
        }
        return new MachineUpgradeBuilder(new SimpleMachineUpgrade(new UpgradeType(name, localizedName, level, maxStack)));
    }

    @ZenMethod
    public MachineUpgradeBuilder addDescriptions(String ... descriptions) {
        for (String desc : descriptions) {
            this.machineUpgrade.addDescription(desc);
        }
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder setBusGUIDescriptionHandler(IFunction<SimpleMachineUpgrade, String[]> handler) {
        this.machineUpgrade.setBusGUIDescriptionHandler(handler);
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addCompatibleMachines(String ... machineNames) {
        MachineModifier.WAIT_FOR_MODIFY.add(() -> {
            for (String machineName : machineNames) {
                DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineName));
                if (machine == null) {
                    CraftTweakerAPI.logError((String)("Cloud not found machine " + machineName));
                    continue;
                }
                this.machineUpgrade.getType().addCompatibleMachine(machine);
            }
        });
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addIncompatibleMachines(String ... machineNames) {
        MachineModifier.WAIT_FOR_MODIFY.add(() -> {
            for (String machineName : machineNames) {
                DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineName));
                if (machine == null) {
                    CraftTweakerAPI.logError((String)("Cloud not found machine " + machineName));
                    continue;
                }
                this.machineUpgrade.getType().addIncompatibleMachine(machine);
            }
        });
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addModifier(boolean stackAble, String modifierKey, RecipeModifier modifier) {
        this.addEventHandler(MachineTickEvent.class, (event, upgrade) -> {
            if (((MachineTickEvent)event).phase != Phase.START) {
                return;
            }
            TileMultiblockMachineController controller = event.getController();
            if (controller.hasModifier(modifierKey)) {
                return;
            }
            if (upgrade.getStackSize() <= 1 || !stackAble) {
                controller.addModifier(modifierKey, modifier);
                return;
            }
            RecipeModifier multiply = modifier;
            for (int i = 0; i < upgrade.getStackSize(); ++i) {
                multiply = multiply.multiply(modifier.getModifier());
            }
            controller.addModifier(modifierKey, multiply);
        });
        return this;
    }

    @Deprecated
    @ZenMethod
    public MachineUpgradeBuilder addRecipeCheckHandler(UpgradeEventHandlerCT handler) {
        CraftTweakerAPI.logWarning((String)"[ModularMachinery] Deprecated method addRecipeCheckHandler()! Consider using addPostRecipeCheckHandler()");
        this.addEventHandler(RecipeCheckEvent.class, handler);
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addPreRecipeCheckHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeCheckEvent.class, (event, upgrade) -> {
            if (((RecipeCheckEvent)event).phase != Phase.START) {
                return;
            }
            handler.handle(event, upgrade);
        });
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addPostRecipeCheckHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeCheckEvent.class, (event, upgrade) -> {
            if (((RecipeCheckEvent)event).phase != Phase.END) {
                return;
            }
            handler.handle(event, upgrade);
        });
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addRecipeStartHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeStartEvent.class, handler);
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addRecipePreTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeTickEvent.class, (event, upgrade) -> {
            if (((RecipeTickEvent)event).phase == Phase.START) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addRecipePostTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeTickEvent.class, (event, upgrade) -> {
            if (((RecipeTickEvent)event).phase == Phase.END) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    @Deprecated
    public MachineUpgradeBuilder addRecipeTickHandler(UpgradeEventHandlerCT handler) {
        CraftTweakerAPI.logWarning((String)"[ModularMachinery] Deprecated method addTickHandler()! Consider using addPostTickHandler()");
        return this.addRecipePostTickHandler(handler);
    }

    @ZenMethod
    public MachineUpgradeBuilder addRecipeFailureHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeFailureEvent.class, handler);
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addRecipeFinishHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeFinishEvent.class, handler);
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addFactoryRecipeStartHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(FactoryRecipeStartEvent.class, handler);
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addFactoryRecipePreTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(FactoryRecipeTickEvent.class, (event, upgrade) -> {
            if (((FactoryRecipeTickEvent)event).phase == Phase.START) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addFactoryRecipePostTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(FactoryRecipeTickEvent.class, (event, upgrade) -> {
            if (((FactoryRecipeTickEvent)event).phase == Phase.END) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addFactoryRecipeFailureHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(FactoryRecipeFailureEvent.class, handler);
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addFactoryRecipeFinishHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(FactoryRecipeFinishEvent.class, handler);
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addMachinePreTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(MachineTickEvent.class, (event, upgrade) -> {
            if (((MachineTickEvent)event).phase == Phase.START) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addMachinePostTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(MachineTickEvent.class, (event, upgrade) -> {
            if (((MachineTickEvent)event).phase == Phase.END) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addStructureFormedHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(MachineStructureFormedEvent.class, handler);
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addStructureUpdateHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(MachineStructureUpdateEvent.class, handler);
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addControllerGUIRenderHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(ControllerGUIRenderEvent.class, handler);
        return this;
    }

    @ZenMethod
    public MachineUpgradeBuilder addSmartInterfaceUpdateHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(SmartInterfaceUpdateEvent.class, handler);
        return this;
    }

    @ZenMethod
    public void buildAndRegister() {
        RegistryUpgrade.registerUpgrade(this.machineUpgrade.getType().getName(), this.machineUpgrade);
    }

    private <E extends MachineEvent> void addEventHandler(Class<E> eventClass, UpgradeEventHandlerCT handler) {
        this.machineUpgrade.addEventHandler(eventClass, handler);
    }
}

