/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker.upgrade;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.client.ControllerGUIRenderEvent;
import github.kasuminova.mmce.common.event.machine.MachineEvent;
import github.kasuminova.mmce.common.event.machine.MachineStructureFormedEvent;
import github.kasuminova.mmce.common.event.machine.MachineStructureUpdateEvent;
import github.kasuminova.mmce.common.event.machine.MachineTickEvent;
import github.kasuminova.mmce.common.event.machine.SmartInterfaceUpdateEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeTickEvent;
import github.kasuminova.mmce.common.upgrade.SimpleDynamicMachineUpgrade;
import github.kasuminova.mmce.common.upgrade.UpgradeType;
import github.kasuminova.mmce.common.upgrade.registry.RegistryUpgrade;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.MachineModifier;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.IFunction;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.UpgradeEventHandlerCT;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.DynamicMachineUpgradeBuilder")
public class DynamicMachineUpgradeBuilder {
    private final SimpleDynamicMachineUpgrade machineUpgrade;

    public DynamicMachineUpgradeBuilder(SimpleDynamicMachineUpgrade machineUpgrade) {
        this.machineUpgrade = machineUpgrade;
    }

    @ZenMethod
    public static DynamicMachineUpgradeBuilder newBuilder(String name, String localizedName, float level, int maxStack) {
        if (RegistryUpgrade.getUpgrade(name) != null) {
            CraftTweakerAPI.logError((String)("[ModularMachinery] Already registered SimpleMachineUpgrade " + name + '!'));
            return null;
        }
        return new DynamicMachineUpgradeBuilder(new SimpleDynamicMachineUpgrade(new UpgradeType(name, localizedName, level, maxStack)));
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder setDescriptionHandler(IFunction<SimpleDynamicMachineUpgrade, String[]> handler) {
        this.machineUpgrade.setDescriptionHandler(handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder setBusGUIDescriptionHandler(IFunction<SimpleDynamicMachineUpgrade, String[]> handler) {
        this.machineUpgrade.setBusGUIDescriptionHandler(handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addCompatibleMachines(String ... machineNames) {
        MachineModifier.WAIT_FOR_MODIFY.add(() -> {
            for (String machineName : machineNames) {
                DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineName));
                if (machine == null) {
                    CraftTweakerAPI.logError((String)("Cloud not found machine " + machineName));
                    continue;
                }
                this.machineUpgrade.getType().addCompatibleMachine(machine);
            }
        });
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addIncompatibleMachines(String ... machineNames) {
        MachineModifier.WAIT_FOR_MODIFY.add(() -> {
            for (String machineName : machineNames) {
                DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineName));
                if (machine == null) {
                    CraftTweakerAPI.logError((String)("Cloud not found machine " + machineName));
                    continue;
                }
                this.machineUpgrade.getType().addIncompatibleMachine(machine);
            }
        });
        return this;
    }

    @Deprecated
    @ZenMethod
    public DynamicMachineUpgradeBuilder addRecipeCheckHandler(UpgradeEventHandlerCT handler) {
        CraftTweakerAPI.logWarning((String)"[ModularMachinery] Deprecated method addRecipeCheckHandler()! Consider using addPostRecipeCheckHandler()");
        this.addEventHandler(RecipeCheckEvent.class, handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addPreRecipeCheckHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeCheckEvent.class, (event, upgrade) -> {
            if (((RecipeCheckEvent)event).phase != Phase.START) {
                return;
            }
            handler.handle(event, upgrade);
        });
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addPostRecipeCheckHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeCheckEvent.class, (event, upgrade) -> {
            if (((RecipeCheckEvent)event).phase != Phase.END) {
                return;
            }
            handler.handle(event, upgrade);
        });
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addRecipeStartHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeStartEvent.class, handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addRecipePreTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeTickEvent.class, (event, upgrade) -> {
            if (((RecipeTickEvent)event).phase == Phase.START) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addRecipePostTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeTickEvent.class, (event, upgrade) -> {
            if (((RecipeTickEvent)event).phase == Phase.END) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    @Deprecated
    public DynamicMachineUpgradeBuilder addRecipeTickHandler(UpgradeEventHandlerCT handler) {
        CraftTweakerAPI.logWarning((String)"[ModularMachinery] Deprecated method addTickHandler()! Consider using addPostTickHandler()");
        return this.addRecipePostTickHandler(handler);
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addRecipeFailureHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeFailureEvent.class, handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addRecipeFinishHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(RecipeFinishEvent.class, handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addFactoryRecipeStartHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(FactoryRecipeStartEvent.class, handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addFactoryRecipePreTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(FactoryRecipeTickEvent.class, (event, upgrade) -> {
            if (((FactoryRecipeTickEvent)event).phase == Phase.START) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addFactoryRecipePostTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(FactoryRecipeTickEvent.class, (event, upgrade) -> {
            if (((FactoryRecipeTickEvent)event).phase == Phase.END) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addFactoryRecipeFailureHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(FactoryRecipeFailureEvent.class, handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addFactoryRecipeFinishHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(FactoryRecipeFinishEvent.class, handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addMachinePreTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(MachineTickEvent.class, (event, upgrade) -> {
            if (((MachineTickEvent)event).phase == Phase.START) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addMachinePostTickHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(MachineTickEvent.class, (event, upgrade) -> {
            if (((MachineTickEvent)event).phase == Phase.END) {
                handler.handle(event, upgrade);
            }
        });
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addStructureFormedHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(MachineStructureFormedEvent.class, handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addStructureUpdateHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(MachineStructureUpdateEvent.class, handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addControllerGUIRenderHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(ControllerGUIRenderEvent.class, handler);
        return this;
    }

    @ZenMethod
    public DynamicMachineUpgradeBuilder addSmartInterfaceUpdateHandler(UpgradeEventHandlerCT handler) {
        this.addEventHandler(SmartInterfaceUpdateEvent.class, handler);
        return this;
    }

    @ZenMethod
    public void buildAndRegister() {
        RegistryUpgrade.registerUpgrade(this.machineUpgrade.getType().getName(), this.machineUpgrade);
    }

    private <E extends MachineEvent> void addEventHandler(Class<E> eventClass, UpgradeEventHandlerCT handler) {
        this.machineUpgrade.addEventHandler(eventClass, handler);
    }
}

