/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker.event;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.client.ControllerGUIRenderEvent;
import github.kasuminova.mmce.common.event.client.ControllerModelAnimationEvent;
import github.kasuminova.mmce.common.event.client.ControllerModelGetEvent;
import github.kasuminova.mmce.common.event.machine.MachineEvent;
import github.kasuminova.mmce.common.event.machine.MachineStructureFormedEvent;
import github.kasuminova.mmce.common.event.machine.MachineStructureUpdateEvent;
import github.kasuminova.mmce.common.event.machine.MachineTickEvent;
import github.kasuminova.mmce.common.event.machine.SmartInterfaceUpdateEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeTickEvent;
import github.kasuminova.mmce.common.util.concurrent.Action;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.MMEvents")
public class MMEvents {
    public static final List<Action> WAIT_FOR_MODIFY = new LinkedList<Action>();

    @ZenMethod
    public static void onStructureFormed(String machineRegistryName, IEventHandler<MachineStructureFormedEvent> function) {
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineRegistryName));
            if (machine != null) {
                machine.addMachineEventHandler(MachineStructureFormedEvent.class, function);
            } else {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineRegistryName + "`!"));
            }
        });
    }

    @ZenMethod
    public static void onStructureUpdate(String machineRegistryName, IEventHandler<MachineStructureUpdateEvent> function) {
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineRegistryName));
            if (machine != null) {
                machine.addMachineEventHandler(MachineStructureUpdateEvent.class, function);
            } else {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineRegistryName + "`!"));
            }
        });
    }

    @ZenMethod
    public static void onMachinePreTick(String machineRegistryName, IEventHandler<MachineTickEvent> function) {
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineRegistryName));
            if (machine != null) {
                machine.addMachineEventHandler(MachineTickEvent.class, event -> {
                    if (event.phase != Phase.START) {
                        return;
                    }
                    function.handle((Object)event);
                });
            } else {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineRegistryName + "`!"));
            }
        });
    }

    @ZenMethod
    public static void onMachinePostTick(String machineRegistryName, IEventHandler<MachineTickEvent> function) {
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineRegistryName));
            if (machine != null) {
                machine.addMachineEventHandler(MachineTickEvent.class, event -> {
                    if (event.phase != Phase.END) {
                        return;
                    }
                    function.handle((Object)event);
                });
            } else {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineRegistryName + "`!"));
            }
        });
    }

    @ZenMethod
    @Deprecated
    public static void onMachineTick(String machineRegistryName, IEventHandler<MachineTickEvent> function) {
        CraftTweakerAPI.logWarning((String)"[ModularMachinery] Deprecated method onMachineTick()! Consider using onMachinePostTick()");
        MMEvents.onMachinePostTick(machineRegistryName, function);
    }

    @ZenMethod
    public static void onControllerGUIRender(String machineRegistryName, IEventHandler<ControllerGUIRenderEvent> function) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return;
        }
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineRegistryName));
            if (machine != null) {
                machine.addMachineEventHandler(ControllerGUIRenderEvent.class, function);
            } else {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineRegistryName + "`!"));
            }
        });
    }

    @ZenMethod
    @Optional.Method(modid="geckolib3")
    public static void onControllerModelAnimation(String machineRegistryName, IEventHandler<ControllerModelAnimationEvent> function) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return;
        }
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineRegistryName));
            if (machine != null) {
                machine.addMachineEventHandler(ControllerModelAnimationEvent.class, function);
            } else {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineRegistryName + "`!"));
            }
        });
    }

    @ZenMethod
    @Optional.Method(modid="geckolib3")
    public static void onControllerModelGet(String machineRegistryName, IEventHandler<ControllerModelGetEvent> function) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return;
        }
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineRegistryName));
            if (machine != null) {
                machine.addMachineEventHandler(ControllerModelGetEvent.class, function);
            } else {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineRegistryName + "`!"));
            }
        });
    }

    @ZenMethod
    public static void onSmartInterfaceUpdate(String machineRegistryName, IEventHandler<SmartInterfaceUpdateEvent> function) {
        WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", machineRegistryName));
            if (machine != null) {
                machine.addMachineEventHandler(SmartInterfaceUpdateEvent.class, function);
            } else {
                CraftTweakerAPI.logError((String)("Could not find machine `" + machineRegistryName + "`!"));
            }
        });
    }

    @ZenMethod
    public static RecipeCheckEvent castToRecipeCheckEvent(MachineEvent event) {
        return event instanceof RecipeCheckEvent ? (RecipeCheckEvent)event : null;
    }

    @ZenMethod
    public static RecipeStartEvent castToRecipeStartEvent(MachineEvent event) {
        return event instanceof RecipeStartEvent ? (RecipeStartEvent)event : null;
    }

    @ZenMethod
    public static RecipeTickEvent castToRecipeTickEvent(MachineEvent event) {
        return event instanceof RecipeTickEvent ? (RecipeTickEvent)event : null;
    }

    @ZenMethod
    public static RecipeFailureEvent castToRecipeFailureEvent(MachineEvent event) {
        return event instanceof RecipeFailureEvent ? (RecipeFailureEvent)event : null;
    }

    @ZenMethod
    public static RecipeFinishEvent castToRecipeFinishEvent(MachineEvent event) {
        return event instanceof RecipeFinishEvent ? (RecipeFinishEvent)event : null;
    }

    @ZenMethod
    public static MachineStructureFormedEvent castToMachineStructureFormedEvent(MachineEvent event) {
        return event instanceof MachineStructureFormedEvent ? (MachineStructureFormedEvent)event : null;
    }

    @ZenMethod
    public static MachineStructureUpdateEvent castToMachineStructureUpdateEvent(MachineEvent event) {
        return event instanceof MachineStructureUpdateEvent ? (MachineStructureUpdateEvent)event : null;
    }

    @ZenMethod
    public static MachineTickEvent castToMachineTickEvent(MachineEvent event) {
        return event instanceof MachineTickEvent ? (MachineTickEvent)event : null;
    }

    @ZenMethod
    public static SmartInterfaceUpdateEvent castToSmartInterfaceUpdateEvent(MachineEvent event) {
        return event instanceof SmartInterfaceUpdateEvent ? (SmartInterfaceUpdateEvent)event : null;
    }

    @ZenMethod
    public static FactoryRecipeStartEvent castToFactoryRecipeStartEvent(MachineEvent event) {
        return event instanceof FactoryRecipeStartEvent ? (FactoryRecipeStartEvent)event : null;
    }

    @ZenMethod
    public static FactoryRecipeTickEvent castToFactoryRecipeTickEvent(MachineEvent event) {
        return event instanceof FactoryRecipeTickEvent ? (FactoryRecipeTickEvent)event : null;
    }

    @ZenMethod
    public static FactoryRecipeFailureEvent castToFactoryRecipeFailureEvent(MachineEvent event) {
        return event instanceof FactoryRecipeFailureEvent ? (FactoryRecipeFailureEvent)event : null;
    }

    @ZenMethod
    public static FactoryRecipeFinishEvent castToFactoryRecipeFinishEvent(MachineEvent event) {
        return event instanceof FactoryRecipeFinishEvent ? (FactoryRecipeFinishEvent)event : null;
    }

    public static void registryAll() {
        for (Action waitForRegister : WAIT_FOR_MODIFY) {
            waitForRegister.doAction();
        }
        WAIT_FOR_MODIFY.clear();
    }
}

