/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker;

import com.google.gson.JsonParseException;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.util.IAxisAlignedBB;
import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.client.ControllerGUIRenderEvent;
import github.kasuminova.mmce.common.event.client.ControllerModelAnimationEvent;
import github.kasuminova.mmce.common.event.client.ControllerModelGetEvent;
import github.kasuminova.mmce.common.event.machine.MachineStructureFormedEvent;
import github.kasuminova.mmce.common.event.machine.MachineStructureUpdateEvent;
import github.kasuminova.mmce.common.event.machine.MachineTickEvent;
import github.kasuminova.mmce.common.event.machine.SmartInterfaceUpdateEvent;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.BlockArrayBuilder;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.AdvancedBlockCheckerCT;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.RecipeFailureActions;
import hellfirepvp.modularmachinery.common.machine.TaggedPositionBlockArray;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.modifier.MultiBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.modifier.SingleBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.IBlockStateDescriptor;
import hellfirepvp.modularmachinery.common.util.SmartInterfaceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.MachineBuilder")
public class MachineBuilder {
    public static final List<DynamicMachine> WAIT_FOR_LOAD = new ArrayList<DynamicMachine>();
    public static final Map<ResourceLocation, MachineBuilder> PRE_LOAD_MACHINES = new HashMap<ResourceLocation, MachineBuilder>();
    private final DynamicMachine machine;
    private final TaggedPositionBlockArray pattern;
    private BlockPos lastPos = null;
    private BlockArray.BlockInformation lastInformation = null;

    private MachineBuilder(String registryName, String localizedName) {
        this.machine = new DynamicMachine(registryName);
        this.pattern = this.machine.getPattern();
        this.machine.setLocalizedName(localizedName);
    }

    private MachineBuilder(String registryName, String localizedName, boolean hasFactory, boolean factoryOnly) {
        this.machine = new DynamicMachine(registryName);
        this.pattern = this.machine.getPattern();
        this.machine.setLocalizedName(localizedName);
        this.machine.setHasFactory(hasFactory);
        this.machine.setFactoryOnly(factoryOnly);
    }

    private MachineBuilder(String registryName, String localizedName, boolean requiresBlueprint, RecipeFailureActions failureAction, int color) {
        this.machine = new DynamicMachine(registryName);
        this.pattern = this.machine.getPattern();
        this.machine.setLocalizedName(localizedName);
        this.machine.setFailureAction(failureAction);
        this.machine.setDefinedColor(color);
        this.machine.setRequiresBlueprint(requiresBlueprint);
    }

    private MachineBuilder(String registryName, String localizedName, boolean requiresBlueprint, RecipeFailureActions failureAction, int color, boolean hasFactory, boolean factoryOnly) {
        this.machine = new DynamicMachine(registryName);
        this.pattern = this.machine.getPattern();
        this.machine.setLocalizedName(localizedName);
        this.machine.setFailureAction(failureAction);
        this.machine.setDefinedColor(color);
        this.machine.setRequiresBlueprint(requiresBlueprint);
        this.machine.setHasFactory(hasFactory);
        this.machine.setFactoryOnly(factoryOnly);
    }

    @ZenMethod
    public static void registerMachine(String registryName, String localizedName, boolean hasFactory, boolean factoryOnly) {
        if (PRE_LOAD_MACHINES.containsKey(new ResourceLocation("modularmachinery", registryName))) {
            return;
        }
        MachineBuilder builder = new MachineBuilder(registryName, localizedName, hasFactory, factoryOnly);
        PRE_LOAD_MACHINES.put(builder.machine.getRegistryName(), builder);
    }

    @ZenMethod
    public static void registerMachine(String registryName, String localizedName) {
        if (PRE_LOAD_MACHINES.containsKey(new ResourceLocation("modularmachinery", registryName))) {
            return;
        }
        MachineBuilder builder = new MachineBuilder(registryName, localizedName);
        PRE_LOAD_MACHINES.put(builder.machine.getRegistryName(), builder);
    }

    @ZenMethod
    public static void registerMachine(String registryName, String localizedName, boolean requiresBlueprint, RecipeFailureActions failureAction, int color, boolean hasFactory, boolean factoryOnly) {
        if (PRE_LOAD_MACHINES.containsKey(new ResourceLocation("modularmachinery", registryName))) {
            return;
        }
        MachineBuilder builder = new MachineBuilder(registryName, localizedName, requiresBlueprint, failureAction, color, hasFactory, factoryOnly);
        PRE_LOAD_MACHINES.put(builder.machine.getRegistryName(), builder);
    }

    @ZenMethod
    public static void registerMachine(String registryName, String localizedName, boolean requiresBlueprint, RecipeFailureActions failureAction, int color) {
        if (PRE_LOAD_MACHINES.containsKey(new ResourceLocation("modularmachinery", registryName))) {
            return;
        }
        MachineBuilder builder = new MachineBuilder(registryName, localizedName, requiresBlueprint, failureAction, color);
        PRE_LOAD_MACHINES.put(builder.machine.getRegistryName(), builder);
    }

    @ZenMethod
    public static MachineBuilder getBuilder(String registryName) {
        return PRE_LOAD_MACHINES.get(new ResourceLocation("modularmachinery", registryName));
    }

    @ZenMethod
    public TaggedPositionBlockArray getBlockArray() {
        return this.pattern;
    }

    @ZenMethod
    public BlockArrayBuilder getBlockArrayBuilder() {
        return BlockArrayBuilder.newBuilder(this.pattern);
    }

    @ZenMethod
    public MachineBuilder setParallelizable(boolean isParallelizable) {
        this.machine.setParallelizable(isParallelizable);
        return this;
    }

    @ZenMethod
    public MachineBuilder setMaxParallelism(int maxParallelism) {
        this.machine.setMaxParallelism(maxParallelism);
        return this;
    }

    @ZenMethod
    public MachineBuilder setInternalParallelism(int parallelism) {
        this.machine.setInternalParallelism(parallelism);
        return this;
    }

    @ZenMethod
    public MachineBuilder addSingleBlockModifier(int x, int y, int z, IBlockState ctBlockState, String description, RecipeModifier ... modifiers) {
        ArrayList<IBlockStateDescriptor> stateDescriptorList = new ArrayList<IBlockStateDescriptor>();
        stateDescriptorList.add(IBlockStateDescriptor.of(CraftTweakerMC.getBlockState((IBlockState)ctBlockState)));
        this.addSingleBlockModifier(new BlockPos(x, y, z), new BlockArray.BlockInformation(stateDescriptorList), description, modifiers);
        return this;
    }

    @ZenMethod
    public MachineBuilder addSingleBlockModifier(int x, int y, int z, IItemStack ctItemStack, String description, RecipeModifier ... modifiers) {
        ItemStack item = CraftTweakerMC.getItemStack((IItemStack)ctItemStack);
        Block block = Block.func_149634_a((Item)item.func_77973_b());
        if (block != Blocks.field_150350_a) {
            ArrayList<IBlockStateDescriptor> stateDescriptorList = new ArrayList<IBlockStateDescriptor>();
            stateDescriptorList.add(IBlockStateDescriptor.of(block));
            this.addSingleBlockModifier(new BlockPos(x, y, z), new BlockArray.BlockInformation(stateDescriptorList), description, modifiers);
        } else {
            CraftTweakerAPI.logError((String)("[ModularMachinery] " + item.func_82833_r() + " cannot convert to Block!"));
        }
        return this;
    }

    @ZenMethod
    public MachineBuilder addSingleBlockModifier(int x, int y, int z, String blockName, String description, RecipeModifier ... modifiers) {
        ArrayList<IBlockStateDescriptor> stateDescriptorList = new ArrayList<IBlockStateDescriptor>();
        try {
            stateDescriptorList.add(BlockArray.BlockInformation.getDescriptor(blockName));
            this.addSingleBlockModifier(new BlockPos(x, y, z), new BlockArray.BlockInformation(stateDescriptorList), description, modifiers);
        }
        catch (JsonParseException e) {
            CraftTweakerAPI.logError((String)("[ModularMachinery] " + blockName + " is invalid block!"), (Throwable)e);
        }
        return this;
    }

    @ZenMethod
    public MachineBuilder addMultiBlockModifier(MultiBlockModifierReplacement multiBlockModifier) {
        if (multiBlockModifier != null) {
            this.machine.getMultiBlockModifiers().add(multiBlockModifier);
        }
        return this;
    }

    @ZenMethod
    public MachineBuilder addSmartInterfaceType(SmartInterfaceType type) {
        if (!this.machine.hasSmartInterfaceType(type.getType())) {
            this.machine.addSmartInterfaceType(type);
        } else {
            CraftTweakerAPI.logWarning((String)("[ModularMachinery] DynamicMachine `" + this.machine.getRegistryName() + "` is already has SmartInterfaceType `" + type.getType() + "`!"));
        }
        return this;
    }

    @ZenMethod
    public MachineBuilder addStructureFormedHandler(IEventHandler<MachineStructureFormedEvent> function) {
        this.machine.addMachineEventHandler(MachineStructureFormedEvent.class, function);
        return this;
    }

    @ZenMethod
    public MachineBuilder addStructureUpdateHandler(IEventHandler<MachineStructureUpdateEvent> function) {
        this.machine.addMachineEventHandler(MachineStructureUpdateEvent.class, function);
        return this;
    }

    @ZenMethod
    public MachineBuilder addTickHandler(IEventHandler<MachineTickEvent> function) {
        this.machine.addMachineEventHandler(MachineTickEvent.class, function);
        return this;
    }

    @ZenMethod
    public MachineBuilder addGUIRenderHandler(IEventHandler<ControllerGUIRenderEvent> function) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return this;
        }
        this.machine.addMachineEventHandler(ControllerGUIRenderEvent.class, function);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="geckolib3")
    public MachineBuilder addControllerModelAnimationHandler(IEventHandler<ControllerModelAnimationEvent> function) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return this;
        }
        this.machine.addMachineEventHandler(ControllerModelAnimationEvent.class, function);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="geckolib3")
    public MachineBuilder addControllerModelGetHandler(IEventHandler<ControllerModelGetEvent> function) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return this;
        }
        this.machine.addMachineEventHandler(ControllerModelGetEvent.class, function);
        return this;
    }

    @ZenMethod
    public MachineBuilder addSmartInterfaceUpdateHandler(IEventHandler<SmartInterfaceUpdateEvent> function) {
        this.machine.addMachineEventHandler(SmartInterfaceUpdateEvent.class, function);
        return this;
    }

    @ZenMethod
    public MachineBuilder setNBT(IData data) {
        if (this.lastInformation != null) {
            NBTTagCompound tag = CraftTweakerMC.getNBTCompound((IData)data);
            this.lastInformation.setMatchingTag(tag);
            if (this.lastInformation.getPreviewTag() == null) {
                this.lastInformation.setPreviewTag(tag);
            }
        }
        return this;
    }

    @ZenMethod
    public MachineBuilder setPreviewNBT(IData data) {
        if (this.lastInformation != null) {
            this.lastInformation.setPreviewTag(CraftTweakerMC.getNBTCompound((IData)data));
        }
        return this;
    }

    @ZenMethod
    public MachineBuilder setBlockChecker(AdvancedBlockCheckerCT checker) {
        if (this.lastInformation != null) {
            this.lastInformation.setNBTChecker((world, pos, blockState, nbt) -> checker.isMatch(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((net.minecraft.block.state.IBlockState)blockState), CraftTweakerMC.getIData((NBTBase)nbt)));
        }
        return this;
    }

    @ZenMethod
    public MachineBuilder setRequiresBlueprint(boolean requiresBlueprint) {
        this.machine.setRequiresBlueprint(requiresBlueprint);
        return this;
    }

    @ZenMethod
    public MachineBuilder setFailureAction(RecipeFailureActions failureAction) {
        this.machine.setFailureAction(failureAction);
        return this;
    }

    @ZenMethod
    public MachineBuilder setColor(int color) {
        this.machine.setDefinedColor(color);
        return this;
    }

    @ZenMethod
    public MachineBuilder setHasFactory(boolean hasFactory) {
        this.machine.setHasFactory(hasFactory);
        return this;
    }

    @ZenMethod
    public MachineBuilder setFactoryOnly(boolean factoryOnly) {
        this.machine.setFactoryOnly(factoryOnly);
        return this;
    }

    @ZenMethod
    public MachineBuilder setMaxThreads(int maxThreads) {
        this.machine.setMaxThreads(maxThreads);
        return this;
    }

    @ZenMethod
    public MachineBuilder addCoreThread(FactoryRecipeThread thread) {
        this.machine.addCoreThread(thread);
        return this;
    }

    @ZenMethod
    public MachineBuilder setControllerBoundingBox(IAxisAlignedBB aabb) {
        this.machine.setControllerBoundingBox(CraftTweakerMC.getAxisAlignedBB((IAxisAlignedBB)aabb));
        return this;
    }

    @ZenMethod
    public void build() {
        WAIT_FOR_LOAD.add(this.machine);
    }

    private void addSingleBlockModifier(BlockPos pos, BlockArray.BlockInformation information, String description, RecipeModifier ... modifiers) {
        Map<BlockPos, List<SingleBlockModifierReplacement>> modifierReplacements = this.machine.getModifiers();
        modifierReplacements.putIfAbsent(pos, new ArrayList());
        modifierReplacements.get(pos).add(new SingleBlockModifierReplacement(information, Arrays.asList(modifiers), description).setPos(pos));
        this.lastInformation = information;
        this.lastPos = pos;
    }

    public DynamicMachine getMachine() {
        return this.machine;
    }
}

