/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.block.BlockFactoryController;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluid;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluidGas;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluidRenderer;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridStackHelper;
import hellfirepvp.modularmachinery.common.integration.preview.CategoryStructurePreview;
import hellfirepvp.modularmachinery.common.integration.preview.StructurePreviewWrapper;
import hellfirepvp.modularmachinery.common.integration.recipe.CategoryDynamicRecipe;
import hellfirepvp.modularmachinery.common.integration.recipe.DynamicRecipeWrapper;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutHelper;
import hellfirepvp.modularmachinery.common.item.ItemBlueprint;
import hellfirepvp.modularmachinery.common.lib.BlocksMM;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.Internal;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.Config;
import mezz.jei.input.InputHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;

@JEIPlugin
public class ModIntegrationJEI
implements IModPlugin {
    public static final String CATEGORY_PREVIEW = "modularmachinery.preview";
    public static final List<StructurePreviewWrapper> PREVIEW_WRAPPERS = Lists.newArrayList();
    private static final Map<DynamicMachine, CategoryDynamicRecipe> RECIPE_CATEGORIES = new HashMap<DynamicMachine, CategoryDynamicRecipe>();
    private static final Map<DynamicMachine, Map<ResourceLocation, DynamicRecipeWrapper>> MACHINE_RECIPE_WRAPPERS = new HashMap<DynamicMachine, Map<ResourceLocation, DynamicRecipeWrapper>>();
    public static Field inputHandler = null;
    public static Field bookmarkList = null;
    public static IStackHelper stackHelper;
    public static IJeiHelpers jeiHelpers;
    public static IIngredientRegistry ingredientRegistry;
    public static IRecipeRegistry recipeRegistry;
    public static IJeiRuntime jeiRuntime;

    public static String getCategoryStringFor(DynamicMachine machine) {
        return "modularmachinery.recipes." + machine.getRegistryName().func_110623_a();
    }

    public static CategoryDynamicRecipe getCategory(DynamicMachine machine) {
        return RECIPE_CATEGORIES.get(machine);
    }

    public static void reloadRecipeWrappers() {
        RECIPE_CATEGORIES.values().forEach(CategoryDynamicRecipe::reloadCategory);
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            Iterable<MachineRecipe> recipes = RecipeRegistry.getRecipesFor(machine);
            Map wrappers = MACHINE_RECIPE_WRAPPERS.computeIfAbsent(machine, v -> new LinkedHashMap());
            for (MachineRecipe recipe : recipes) {
                DynamicRecipeWrapper wrapper = (DynamicRecipeWrapper)wrappers.get(recipe.getRegistryName());
                if (wrapper == null) continue;
                wrapper.reloadWrapper(recipe);
            }
        }
    }

    public static void reloadPreviewWrappers() {
    }

    public static void addItemStackToBookmarkList(ItemStack stack) {
        if (inputHandler == null || bookmarkList == null || stack.func_190926_b()) {
            return;
        }
        try {
            InputHandler handler = (InputHandler)inputHandler.get(null);
            BookmarkList bookmark = (BookmarkList)bookmarkList.get(handler);
            if (!Config.isBookmarkOverlayEnabled()) {
                Config.toggleBookmarkEnabled();
            }
            bookmark.add((Object)stack);
        }
        catch (IllegalAccessException e) {
            ModularMachinery.log.warn((Object)e);
        }
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter((Item)ItemsMM.blueprint, s -> {
            DynamicMachine machine = ItemBlueprint.getAssociatedMachine(s);
            if (machine == null) {
                return "";
            }
            return machine.getRegistryName().toString();
        });
    }

    @Deprecated
    public void registerIngredients(IModIngredientRegistration registry) {
        try {
            registry.register(() -> HybridFluid.class, (Collection)Lists.newArrayList(), new HybridStackHelper(), new HybridFluidRenderer());
            if (Mods.MEKANISM.isPresent()) {
                this.registerHybridGas(registry);
            }
        }
        catch (Exception exc) {
            ModularMachinery.log.warn("Error setting up HybridFluid JEI registration! Check the log after this for more details! Report this error!");
            exc.printStackTrace();
            throw exc;
        }
    }

    @Optional.Method(modid="mekanism")
    private void registerHybridGas(IModIngredientRegistration registry) {
        registry.register(() -> HybridFluidGas.class, (Collection)Lists.newArrayList(), new HybridStackHelper(), new HybridFluidRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        RecipeLayoutHelper.init();
        registry.addRecipeCategories(new IRecipeCategory[]{new CategoryStructurePreview()});
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            CategoryDynamicRecipe recipe = new CategoryDynamicRecipe(machine);
            RECIPE_CATEGORIES.put(machine, recipe);
            registry.addRecipeCategories(new IRecipeCategory[]{recipe});
        }
    }

    public void register(IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        ingredientRegistry = registry.getIngredientRegistry();
        RecipeLayoutHelper.init();
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksMM.blockController), new String[]{CATEGORY_PREVIEW});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksMM.blockFactoryController), new String[]{CATEGORY_PREVIEW});
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            ItemStack stack = new ItemStack((Item)ItemsMM.blueprint);
            ItemBlueprint.setAssociatedMachine(stack, machine);
            String machineCategory = ModIntegrationJEI.getCategoryStringFor(machine);
            registry.addRecipeCatalyst((Object)stack, new String[]{machineCategory});
        }
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            PREVIEW_WRAPPERS.add(new StructurePreviewWrapper(machine));
        }
        registry.addRecipes(PREVIEW_WRAPPERS, CATEGORY_PREVIEW);
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            Iterable<MachineRecipe> recipes = RecipeRegistry.getRecipesFor(machine);
            Map wrappers = MACHINE_RECIPE_WRAPPERS.computeIfAbsent(machine, v -> new LinkedHashMap());
            for (MachineRecipe recipe : recipes) {
                wrappers.put(recipe.getRegistryName(), new DynamicRecipeWrapper(recipe));
            }
            registry.addRecipes(wrappers.values(), ModIntegrationJEI.getCategoryStringFor(machine));
        }
        BlockController.MACHINE_CONTROLLERS.values().forEach(controller -> registry.addRecipeCatalyst((Object)new ItemStack((Block)controller), new String[]{ModIntegrationJEI.getCategoryStringFor(controller.getParentMachine())}));
        BlockController.MOC_MACHINE_CONTROLLERS.values().forEach(controller -> registry.addRecipeCatalyst((Object)new ItemStack((Block)controller), new String[]{ModIntegrationJEI.getCategoryStringFor(controller.getParentMachine())}));
        BlockFactoryController.FACTORY_CONTROLLERS.values().forEach(controller -> registry.addRecipeCatalyst((Object)new ItemStack((Block)controller), new String[]{ModIntegrationJEI.getCategoryStringFor(controller.getParentMachine())}));
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipeRegistry = jeiRuntime.getRecipeRegistry();
        ModIntegrationJEI.jeiRuntime = jeiRuntime;
    }

    static {
        try {
            Field inputHandler = Internal.class.getDeclaredField("inputHandler");
            inputHandler.setAccessible(true);
            ModIntegrationJEI.inputHandler = inputHandler;
            Field bookmarkList = InputHandler.class.getDeclaredField("bookmarkList");
            bookmarkList.setAccessible(true);
            ModIntegrationJEI.bookmarkList = bookmarkList;
        }
        catch (NoSuchFieldException e) {
            ModularMachinery.log.warn((Object)e);
        }
    }
}

