/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.data;

import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.client.util.EnergyDisplayUtil;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.prop.EnergyHatchData;
import hellfirepvp.modularmachinery.common.block.prop.FluidHatchSize;
import hellfirepvp.modularmachinery.common.block.prop.ParallelControllerData;
import hellfirepvp.modularmachinery.common.block.prop.UpgradeBusData;
import hellfirepvp.modularmachinery.common.integration.ModIntegrationTOP;
import hellfirepvp.modularmachinery.common.machine.RecipeFailureActions;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import ink.ikx.mmce.core.AssemblyConfig;
import java.io.File;
import kport.modularmagic.common.tile.TileManaProvider;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static boolean mocCompatibleMode = false;
    public static boolean onlyOneMachineController = false;
    public static boolean disableMocDeprecatedTip = false;
    public static boolean machineParallelizeEnabledByDefault = true;
    public static boolean recipeParallelizeEnabledByDefault = true;
    public static boolean enableFluxNetworksIntegration = true;
    public static boolean enableFactoryControllerByDefault = false;
    public static boolean controllerOutputComparatorSignal = true;
    public static boolean asyncControllerModelRender = true;
    public static boolean enableDurationMultiplier = true;
    public static int machineColor;
    public static int maxMachineParallelism;
    public static int defaultFactoryMaxThread;
    private static File lastReadFile;
    private static Configuration lastReadConfig;

    public static void loadFrom(File file) {
        lastReadFile = file;
        lastReadConfig = new Configuration(file);
        Config.load();
        if (lastReadConfig.hasChanged()) {
            lastReadConfig.save();
        }
    }

    private static void load() {
        FluidHatchSize.loadFromConfig(lastReadConfig);
        EnergyHatchData.loadFromConfig(lastReadConfig);
        ParallelControllerData.loadFromConfig(lastReadConfig);
        UpgradeBusData.loadFromConfig(lastReadConfig);
        EnergyDisplayUtil.loadFromConfig(lastReadConfig);
        RecipeFailureActions.loadFromConfig(lastReadConfig);
        TileMultiblockMachineController.loadFromConfig(lastReadConfig);
        AssemblyConfig.loadFormConfig(lastReadConfig);
        if (Mods.TOP.isPresent()) {
            ModIntegrationTOP.loadFromConfig(lastReadConfig);
        }
        if (Mods.BOTANIA.isPresent()) {
            TileManaProvider.loadFromConfig(lastReadConfig);
        }
        String strColor = lastReadConfig.getString("general-casing-color", "general", "FFFFFF", "Defines the _default_ color for machine casings as items or blocks. (Hex color without alpha) Has to be defined both server and clientside!");
        int col = 16749086;
        try {
            col = Integer.parseInt(strColor, 16);
        }
        catch (Exception exc) {
            ModularMachinery.log.error("Machine-Casing color defined in the config is not a hex color: " + strColor);
            ModularMachinery.log.error("Using default color instead...");
        }
        machineColor = col;
        onlyOneMachineController = lastReadConfig.getBoolean("only-one-machine-controller", "general", false, "When enabled, Modules no longer register a separate controller for each machine, and the modular-controller-compatible-mode option is turned off.");
        enableDurationMultiplier = lastReadConfig.getBoolean("enable-duration-multiplier", "general", false, "If enabled, and the RecipeModifier modifies the recipe duration, certain requirements (e.g., energy) will change over time.");
        asyncControllerModelRender = lastReadConfig.getBoolean("async-controller-model-render", "client", false, "(Experimental) Customizing the model with a multi-threaded rendering controller helps improve rendering performance, but puts more strain on the CPU and memory, and performs poorly on low-configuration devices.");
        mocCompatibleMode = lastReadConfig.getBoolean("modular-controller-compatible-mode", "general", false, "When enabled, the mod registers a controller block under the name modularcontroller to prevent incompatibility with older saves.");
        disableMocDeprecatedTip = lastReadConfig.getBoolean("disable-moc-deprecated-tip", "general", false, "Disable the ModularController is deprecated tooltip.");
        enableFluxNetworksIntegration = lastReadConfig.getBoolean("enable-fluxnetworks-integration", "general", true, "When enabled, allows you to use the flux network to transfer larger amounts of energy than 2147483647.");
        machineParallelizeEnabledByDefault = lastReadConfig.getBoolean("machine-parallelize-enabled-bydefault", "parallel-controller", true, "Whether the machine parallel recipe processing is enabled by default.");
        recipeParallelizeEnabledByDefault = lastReadConfig.getBoolean("recipe-parallelize-enabled-bydefault", "parallel-controller", true, "Whether parallel recipe processing is enabled by default.");
        maxMachineParallelism = lastReadConfig.getInt("max-machine-parallelism", "parallel-controller", 2048, 1, Integer.MAX_VALUE, "The default max number of parallelism for a machine.");
        enableFactoryControllerByDefault = lastReadConfig.getBoolean("enable-factory-controller-bydefault", "factory-system", false, "If enabled, the mod will register the factory system controller for all machines by default.");
        defaultFactoryMaxThread = lastReadConfig.getInt("default-factory-max-thread", "factory-system", 10, 1, 100, "Sets the maximum number of threads in the factory system by default.");
    }

    static {
        maxMachineParallelism = 2048;
        defaultFactoryMaxThread = 20;
    }
}

