/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.tooltip;

import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementInterfaceNumInput;
import hellfirepvp.modularmachinery.common.crafting.tooltip.RequirementTip;
import hellfirepvp.modularmachinery.common.util.SmartInterfaceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.MissingFormatArgumentException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;

public class TooltipInterfaceNumberInput
extends RequirementTip {
    @Override
    @Nonnull
    public Collection<ComponentRequirement<?, ?>> filterRequirements(MachineRecipe recipe, Collection<ComponentRequirement<?, ?>> requirements) {
        return requirements.stream().filter(RequirementInterfaceNumInput.class::isInstance).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<String> buildTooltip(MachineRecipe recipe, Collection<ComponentRequirement<?, ?>> filteredComponents) {
        if (filteredComponents.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        for (ComponentRequirement<?, ?> filteredComponent : filteredComponents) {
            RequirementInterfaceNumInput requirement = (RequirementInterfaceNumInput)filteredComponent;
            float minValue = requirement.getMinValue();
            float maxValue = requirement.getMaxValue();
            SmartInterfaceType type = requirement.getType();
            String jeiTooltip = type.getJeiTooltip();
            if (!jeiTooltip.isEmpty()) {
                try {
                    if (type.getJeiTooltipArgsCount() == 1) {
                        tooltip.add(String.format(jeiTooltip, Float.valueOf(minValue)));
                        continue;
                    }
                    if (type.getJeiTooltipArgsCount() == 2) {
                        tooltip.add(String.format(jeiTooltip, Float.valueOf(minValue), Float.valueOf(maxValue)));
                        continue;
                    }
                    ModularMachinery.log.warn("Invalid JEITooltipArgsCount, Using default format...");
                    ModularMachinery.log.warn("Type: {}, TooltipMessage: {}", (Object)type.getType(), (Object)jeiTooltip);
                }
                catch (MissingFormatArgumentException ex) {
                    ModularMachinery.log.warn("Caught MissingFormatArgumentException! Using default format...");
                    ModularMachinery.log.warn("Type: {}, TooltipMessage: {}", (Object)type.getType(), (Object)jeiTooltip);
                }
            }
            if (minValue == maxValue) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.smartinterface.value", (Object[])new Object[]{Float.valueOf(minValue)}));
                continue;
            }
            tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.smartinterface.minvalue", (Object[])new Object[]{Float.valueOf(minValue)}));
            tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.smartinterface.maxvalue", (Object[])new Object[]{Float.valueOf(maxValue)}));
        }
        return tooltip;
    }
}

