/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.tooltip;

import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.crafting.tooltip.RequirementTip;
import hellfirepvp.modularmachinery.common.machine.IOType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;

public class TooltipFuelInput
extends RequirementTip {
    @Override
    @Nonnull
    public Collection<ComponentRequirement<?, ?>> filterRequirements(MachineRecipe recipe, Collection<ComponentRequirement<?, ?>> requirements) {
        return requirements.stream().filter(RequirementItem.class::isInstance).filter(c -> c.getActionType() == IOType.INPUT).filter(c -> ((RequirementItem)c).requirementType == RequirementItem.ItemRequirementType.FUEL).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<String> buildTooltip(MachineRecipe recipe, Collection<ComponentRequirement<?, ?>> filteredComponents) {
        int totalFuelIn = 0;
        for (ComponentRequirement<?, ?> fuel : filteredComponents) {
            totalFuelIn += ((RequirementItem)fuel).fuelBurntime;
        }
        ArrayList<String> tooltip = new ArrayList<String>(2);
        if (totalFuelIn > 0) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.fuel.in", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"tooltip.machinery.fuel.in.total", (Object[])new Object[]{totalFuelIn}));
        }
        return tooltip;
    }
}

