/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementGas;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.machine.IOType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import net.minecraftforge.fml.common.Optional;

public class RequirementTypeGas
extends RequirementType<Object, RequirementGas> {
    @Override
    @Nullable
    public String requiresModid() {
        return "mekanism";
    }

    public RequirementGas createRequirement(IOType type, JsonObject requirement) {
        return this.provideMekGasComponent(type, requirement);
    }

    @Nonnull
    @Optional.Method(modid="mekanism")
    private RequirementGas provideMekGasComponent(IOType machineIoType, JsonObject requirement) {
        if (!(requirement.has("gas") && requirement.get("gas").isJsonPrimitive() && requirement.get("gas").getAsJsonPrimitive().isString())) {
            throw new JsonParseException("The ComponentType 'gas' expects an 'gas'-entry that defines the type of gas!");
        }
        if (!(requirement.has("amount") && requirement.get("amount").isJsonPrimitive() && requirement.get("amount").getAsJsonPrimitive().isNumber())) {
            throw new JsonParseException("The ComponentType 'gas' expects an 'amount'-entry that defines the type of gas!");
        }
        String gasName = requirement.getAsJsonPrimitive("gas").getAsString();
        int mbAmount = requirement.getAsJsonPrimitive("amount").getAsInt();
        Gas gas = GasRegistry.getGas((String)gasName);
        if (gas == null) {
            throw new JsonParseException("The gas specified in the 'gas'-entry (" + gasName + ") doesn't exist!");
        }
        mbAmount = Math.max(0, mbAmount);
        GasStack gasStack = new GasStack(gas, mbAmount);
        RequirementGas req = new RequirementGas(machineIoType, gasStack);
        if (requirement.has("chance")) {
            if (!requirement.get("chance").isJsonPrimitive() || !requirement.getAsJsonPrimitive("chance").isNumber()) {
                throw new JsonParseException("'chance', if defined, needs to be a chance-number between 0 and 1!");
            }
            float chance = requirement.getAsJsonPrimitive("chance").getAsFloat();
            if (chance >= 0.0f && chance <= 1.0f) {
                req.setChance(chance);
            }
        }
        return req;
    }
}

