/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import github.kasuminova.mmce.common.concurrent.Sync;
import github.kasuminova.mmce.common.helper.AdvancedItemChecker;
import github.kasuminova.mmce.common.helper.AdvancedItemModifier;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.jei.JEIComponentItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementTypeItem;
import hellfirepvp.modularmachinery.common.integration.ingredient.IngredientItemStack;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import hellfirepvp.modularmachinery.common.util.FuelItemHelper;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class RequirementItem
extends ComponentRequirement.MultiCompParallelizable<ItemStack, RequirementTypeItem>
implements ComponentRequirement.ChancedRequirement,
ComponentRequirement.Parallelizable,
Asyncable {
    public static final Random RD = new Random();
    public final ItemRequirementType requirementType;
    public final ItemStack required;
    public final String oreDictName;
    public final int oreDictItemAmount;
    public final int fuelBurntime;
    public final List<ItemStack> previewItemStacks = new ArrayList<ItemStack>();
    public final List<AdvancedItemModifier> itemModifierList = new ArrayList<AdvancedItemModifier>();
    public List<IngredientItemStack> cachedJEIIORequirementList = null;
    public NBTTagCompound tag = null;
    public NBTTagCompound previewDisplayTag = null;
    public AdvancedItemChecker itemChecker = null;
    public float chance = 1.0f;
    public int minAmount = 1;
    public int maxAmount = 1;

    public RequirementItem(IOType ioType, ItemStack item) {
        super(RequirementTypesMM.REQUIREMENT_ITEM, ioType);
        this.requirementType = ItemRequirementType.ITEMSTACKS;
        this.required = item.func_77946_l();
        this.oreDictName = null;
        this.oreDictItemAmount = 0;
        this.fuelBurntime = 0;
        this.minAmount = item.func_190916_E();
        this.maxAmount = item.func_190916_E();
    }

    public RequirementItem(IOType ioType, String oreDictName, int oreDictAmount) {
        super(RequirementTypesMM.REQUIREMENT_ITEM, ioType);
        this.requirementType = ItemRequirementType.OREDICT;
        this.oreDictName = oreDictName;
        this.oreDictItemAmount = oreDictAmount;
        this.required = ItemStack.field_190927_a;
        this.fuelBurntime = 0;
        this.minAmount = oreDictAmount;
        this.maxAmount = oreDictAmount;
    }

    @Deprecated
    public RequirementItem(IOType actionType, int fuelBurntime) {
        super(RequirementTypesMM.REQUIREMENT_ITEM, actionType);
        this.requirementType = ItemRequirementType.FUEL;
        this.fuelBurntime = fuelBurntime;
        this.oreDictName = null;
        this.oreDictItemAmount = 0;
        this.required = ItemStack.field_190927_a;
    }

    public void setItemChecker(AdvancedItemChecker itemChecker) {
        this.itemChecker = itemChecker;
    }

    public void addItemModifier(AdvancedItemModifier itemModifier) {
        this.itemModifierList.add(itemModifier);
    }

    @Override
    public int getSortingWeight() {
        return 50000;
    }

    public RequirementItem deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    public RequirementItem deepCopyModified(List<RecipeModifier> modifiers) {
        RequirementItem requirementItem;
        float modValue = RecipeModifier.applyModifiers(modifiers, this, 1.0f, false);
        switch (this.requirementType) {
            case OREDICT: {
                requirementItem = new RequirementItem(this.actionType, this.oreDictName, Math.round((float)this.oreDictItemAmount * modValue));
                break;
            }
            case FUEL: {
                requirementItem = new RequirementItem(this.actionType, Math.round((float)this.fuelBurntime * modValue));
                break;
            }
            default: {
                ItemStack inReq = this.required.func_77946_l();
                inReq.func_190920_e(Math.round((float)inReq.func_190916_E() * modValue));
                requirementItem = new RequirementItem(this.actionType, inReq);
                break;
            }
        }
        RequirementItem item = requirementItem;
        item.minAmount = Math.round((float)this.minAmount * modValue);
        item.maxAmount = Math.round((float)this.maxAmount * modValue);
        item.chance = this.chance;
        if (this.itemChecker != null) {
            item.itemChecker = this.itemChecker;
        } else if (this.tag != null) {
            item.tag = this.tag.func_74737_b();
        }
        if (!this.itemModifierList.isEmpty()) {
            item.itemModifierList.addAll(this.itemModifierList);
        }
        if (this.previewDisplayTag != null) {
            item.previewDisplayTag = this.previewDisplayTag.func_74737_b();
        }
        return item;
    }

    @Override
    public ComponentRequirement.JEIComponent<ItemStack> provideJEIComponent() {
        return new JEIComponentItem(this);
    }

    @Override
    public void initializeJEIRequirements() {
        this.cachedJEIIORequirementList = this.asJEIIORequirementList();
    }

    public List<IngredientItemStack> asJEIIORequirementList() {
        switch (this.requirementType) {
            case ITEMSTACKS: {
                ItemStack stack = ItemUtils.copyStackWithSize(this.required, this.required.func_190916_E());
                if (this.previewDisplayTag != null) {
                    stack.func_77982_d(this.previewDisplayTag);
                } else if (this.tag != null) {
                    this.previewDisplayTag = this.tag.func_74737_b();
                    stack.func_77982_d(this.previewDisplayTag.func_74737_b());
                }
                if (this.minAmount != this.maxAmount) {
                    stack.func_190920_e(this.maxAmount);
                }
                return Collections.singletonList(this.asIngredientItemStack(stack));
            }
            case OREDICT: {
                NonNullList stacks = OreDictionary.getOres((String)this.oreDictName);
                NonNullList out = NonNullList.func_191196_a();
                for (ItemStack oreDictIn : stacks) {
                    if (oreDictIn.func_77952_i() == Short.MAX_VALUE && !oreDictIn.func_77984_f() && oreDictIn.func_77973_b().func_77640_w() != null) {
                        oreDictIn.func_77973_b().func_150895_a(oreDictIn.func_77973_b().func_77640_w(), out);
                        continue;
                    }
                    out.add((Object)oreDictIn);
                }
                NonNullList stacksOut = NonNullList.func_191196_a();
                for (ItemStack itemStack : out) {
                    ItemStack copy = itemStack.func_77946_l();
                    if (this.minAmount != this.maxAmount) {
                        copy.func_190920_e(this.maxAmount);
                    } else {
                        copy.func_190920_e(this.oreDictItemAmount);
                    }
                    stacksOut.add((Object)this.asIngredientItemStack(copy));
                }
                return stacksOut;
            }
            case FUEL: {
                return Lists.transform(FuelItemHelper.getFuelItems(), (Function)JEIComponentItem.IngredientItemStackTransformer.INSTANCE);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        ResourceLocation compKey = ((RequirementTypeItem)((Object)this.getRequirementType())).getRegistryName();
        return String.format("component.missing.%s.%s.%s", compKey.func_110624_b(), compKey.func_110623_a(), ioType.name().toLowerCase());
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.component();
        ComponentType cmpType = cmp.getComponentType();
        return (cmpType.equals((Object)ComponentTypesMM.COMPONENT_ITEM) || cmpType.equals((Object)ComponentTypesMM.COMPONENT_ITEM_FLUID_GAS)) && cmp.ioType == this.actionType;
    }

    @Override
    public void startCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.INPUT && chance.canWork(RecipeModifier.applyModifiers(context, this, this.chance, true))) {
            this.doItemIO(components, context, this.itemModifierList, chance);
        }
    }

    @Override
    public void finishCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.OUTPUT && chance.canWork(RecipeModifier.applyModifiers(context, this, this.chance, true))) {
            this.doItemIO(components, context, this.itemModifierList, chance);
        }
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        return this.doItemIO(components, context, Collections.emptyList(), ResultChance.GUARANTEED);
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        if (this.ignoreOutputCheck && this.actionType == IOType.OUTPUT) {
            return maxParallelism;
        }
        if (this.parallelizeUnaffected) {
            if (this.doItemIOInternal(components, context, 1, Collections.emptyList(), ResultChance.GUARANTEED) >= 1) {
                return maxParallelism;
            }
            return 0;
        }
        return this.doItemIOInternal(components, context, maxParallelism, Collections.emptyList(), ResultChance.GUARANTEED);
    }

    private CraftCheck doItemIO(List<ProcessingComponent<?>> components, RecipeCraftingContext context, List<AdvancedItemModifier> itemModifiers, ResultChance chance) {
        int mul = this.doItemIOInternal(components, context, this.parallelism, itemModifiers, chance);
        if (mul < this.parallelism) {
            CraftCheck craftCheck;
            switch (this.actionType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INPUT: {
                    craftCheck = CraftCheck.failure("craftcheck.failure.item.input");
                    break;
                }
                case OUTPUT: {
                    craftCheck = CraftCheck.failure("craftcheck.failure.item.output.space");
                }
            }
            return craftCheck;
        }
        return CraftCheck.success();
    }

    private int doItemIOInternal(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxMultiplier, List<AdvancedItemModifier> itemModifiers, ResultChance chance) {
        int n;
        ArrayList<IItemHandlerModifiable> handlers = new ArrayList<IItemHandlerModifiable>();
        for (ProcessingComponent<?> component : components) {
            IItemHandlerModifiable providedComponent = (IItemHandlerModifiable)component.getProvidedComponent();
            handlers.add(providedComponent);
        }
        switch (this.actionType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INPUT: {
                n = this.consumeAllItems(handlers, context, maxMultiplier, itemModifiers, chance);
                break;
            }
            case OUTPUT: {
                if (this.ignoreOutputCheck) {
                    this.insertAllItems(handlers, context, maxMultiplier, itemModifiers, chance);
                    n = maxMultiplier;
                    break;
                }
                n = this.insertAllItems(handlers, context, maxMultiplier, itemModifiers, chance);
            }
        }
        return n;
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        return ItemUtils.copyItemHandlerComponents(components);
    }

    public int consumeAllItems(List<IItemHandlerModifiable> handlers, RecipeCraftingContext context, int maxMultiplier, List<AdvancedItemModifier> itemModifiers, ResultChance chance) {
        AtomicInteger consumed = new AtomicInteger();
        int toConsume = this.applyModifierAmount(context, chance != ResultChance.GUARANTEED || this.minAmount != this.maxAmount);
        int maxConsume = toConsume * maxMultiplier;
        if (toConsume <= 0) {
            return maxMultiplier;
        }
        ItemStack stack = ItemStack.field_190927_a;
        switch (this.requirementType) {
            case ITEMSTACKS: {
                stack = this.required.func_77946_l();
                if (this.tag != null) {
                    stack.func_77982_d(this.tag);
                }
                if (itemModifiers.isEmpty()) break;
                stack.func_190920_e(toConsume);
                for (AdvancedItemModifier modifier : itemModifiers) {
                    stack = modifier.apply(context.getMachineController(), stack);
                }
                toConsume = stack.func_190916_E();
                maxConsume = toConsume * maxMultiplier;
                break;
            }
            case OREDICT: {
                if (itemModifiers.isEmpty()) break;
                stack = ItemUtils.getOredictItem(context, this.oreDictName, this.tag);
                if (stack.func_190926_b()) {
                    return maxMultiplier;
                }
                stack.func_190920_e(toConsume);
                if (this.tag != null) {
                    stack.func_77982_d(this.tag);
                }
                for (AdvancedItemModifier modifier : itemModifiers) {
                    stack = modifier.apply(context.getMachineController(), stack);
                }
                toConsume = stack.func_190916_E();
                maxConsume = toConsume * maxMultiplier;
            }
        }
        if (toConsume <= 0) {
            return maxMultiplier;
        }
        ItemStack finalStack = stack;
        int finalMaxConsume = maxConsume;
        block4 : switch (this.requirementType) {
            case ITEMSTACKS: {
                for (IItemHandlerModifiable handler : handlers) {
                    stack.func_190920_e(maxConsume - consumed.get());
                    Sync.executeSyncIfPresent(handler, () -> {
                        if (this.itemChecker != null) {
                            consumed.addAndGet(ItemUtils.consumeAll(handler, finalStack, this.itemChecker, context.getMachineController()));
                        } else {
                            consumed.addAndGet(ItemUtils.consumeAll(handler, finalStack, this.tag));
                        }
                    });
                    if (consumed.get() < maxConsume) continue;
                    break block4;
                }
                break;
            }
            case OREDICT: {
                for (IItemHandlerModifiable handler : handlers) {
                    Sync.executeSyncIfPresent(handler, () -> {
                        if (this.itemChecker != null) {
                            consumed.addAndGet(ItemUtils.consumeAll(handler, this.oreDictName, finalMaxConsume - consumed.get(), this.itemChecker, context.getMachineController()));
                        } else {
                            consumed.addAndGet(ItemUtils.consumeAll(handler, this.oreDictName, finalMaxConsume - consumed.get(), this.tag));
                        }
                    });
                    if (consumed.get() < maxConsume) continue;
                    break block4;
                }
                break;
            }
        }
        return consumed.get() / toConsume;
    }

    public int insertAllItems(List<IItemHandlerModifiable> handlers, RecipeCraftingContext context, int maxMultiplier, List<AdvancedItemModifier> itemModifiers, ResultChance chance) {
        ItemStack stack;
        if (this.fuelBurntime > 0 && this.oreDictName == null && this.required.func_190926_b()) {
            throw new IllegalStateException("Invalid item output!");
        }
        AtomicInteger inserted = new AtomicInteger();
        int toInsert = this.applyModifierAmount(context, chance != ResultChance.GUARANTEED || this.minAmount != this.maxAmount);
        if (toInsert <= 0) {
            return maxMultiplier;
        }
        switch (this.requirementType) {
            case ITEMSTACKS: {
                stack = ItemUtils.copyStackWithSize(this.required, 1);
                break;
            }
            case OREDICT: {
                stack = ItemUtils.getOredictItem(context, this.oreDictName, this.tag);
                break;
            }
            default: {
                return 0;
            }
        }
        if (this.tag != null) {
            stack.func_77982_d(this.tag);
        }
        if (!itemModifiers.isEmpty()) {
            for (AdvancedItemModifier modifier : itemModifiers) {
                stack = modifier.apply(context.getMachineController(), stack);
            }
            if ((toInsert *= stack.func_190916_E()) <= 0) {
                return maxMultiplier;
            }
            stack.func_190920_e(1);
        }
        int maxInsert = toInsert * maxMultiplier;
        for (IItemHandlerModifiable handler : handlers) {
            ItemStack finalStack = stack;
            Sync.executeSyncIfPresent(handler, () -> inserted.addAndGet(ItemUtils.insertAll(finalStack, handler, maxInsert - inserted.get())));
            if (inserted.get() < maxInsert) continue;
            break;
        }
        return inserted.get() / toInsert;
    }

    public IngredientItemStack asIngredientItemStack(ItemStack stack) {
        return new IngredientItemStack(stack, this.minAmount, this.maxAmount, this.chance);
    }

    protected int applyModifierAmount(RecipeCraftingContext context, boolean randomAmount) {
        if (randomAmount) {
            int amount = this.minAmount + RD.nextInt(this.maxAmount - this.minAmount + 1);
            return Math.round(RecipeModifier.applyModifiers(context, this, (float)amount, false));
        }
        return Math.round(RecipeModifier.applyModifiers(context, this, (float)this.maxAmount, false));
    }

    public static enum ItemRequirementType {
        ITEMSTACKS,
        OREDICT,
        FUEL,
        ITEMSTACK_ARRAY;

    }
}

