/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement;

import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementTypeInterfaceNumInput;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.TileSmartInterface;
import hellfirepvp.modularmachinery.common.util.SmartInterfaceData;
import hellfirepvp.modularmachinery.common.util.SmartInterfaceType;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class RequirementInterfaceNumInput
extends ComponentRequirement<Float, RequirementTypeInterfaceNumInput> {
    protected final SmartInterfaceType type;
    protected final float minValue;
    protected final float maxValue;

    public RequirementInterfaceNumInput(ResourceLocation machineName, String type, float minValue, float maxValue) throws NullPointerException {
        super(RequirementTypesMM.REQUIREMENT_INTERFACE_NUMBER_INPUT, IOType.INPUT);
        this.type = MachineRegistry.getRegistry().getMachine(machineName).getSmartInterfaceType(type);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public RequirementInterfaceNumInput(SmartInterfaceType type, float minValue, float maxValue) {
        super(RequirementTypesMM.REQUIREMENT_INTERFACE_NUMBER_INPUT, IOType.INPUT);
        this.type = type;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public RequirementInterfaceNumInput(SmartInterfaceType type, float value) {
        super(RequirementTypesMM.REQUIREMENT_INTERFACE_NUMBER_INPUT, IOType.INPUT);
        this.type = type;
        this.minValue = value;
        this.maxValue = value;
    }

    public SmartInterfaceType getType() {
        return this.type;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.component();
        if (cmp.getComponentType().equals((Object)ComponentTypesMM.COMPONENT_SMART_INTERFACE) && cmp instanceof TileSmartInterface.SmartInterfaceProvider) {
            TileSmartInterface.SmartInterfaceProvider provider = (TileSmartInterface.SmartInterfaceProvider)cmp;
            return provider.getMachineData(this.type.getType()) != null;
        }
        return false;
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, List<ComponentOutputRestrictor> restrictions) {
        TileSmartInterface.SmartInterfaceProvider provider = (TileSmartInterface.SmartInterfaceProvider)component.getProvidedComponent();
        SmartInterfaceData data = provider.getMachineData(this.type.getType());
        if (data == null) {
            return CraftCheck.failure("component.missing.modularmachinery.interface.number");
        }
        float value = data.getValue();
        if (value >= this.minValue && value <= this.maxValue) {
            return CraftCheck.success();
        }
        String customMsg = this.type.getNotEqualMessage();
        return CraftCheck.failure(customMsg.isEmpty() ? "craftcheck.failure.interface.number.notequal" : customMsg);
    }

    public RequirementInterfaceNumInput deepCopy() {
        return new RequirementInterfaceNumInput(this.type, this.minValue, this.maxValue);
    }

    public RequirementInterfaceNumInput deepCopyModified(List<RecipeModifier> modifiers) {
        return this.deepCopy();
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        return "component.missing.modularmachinery.interface.number";
    }

    @Override
    public ComponentRequirement.JEIComponent<Float> provideJEIComponent() {
        return null;
    }
}

