/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement;

import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.jei.JEIComponentCatalyst;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class RequirementCatalyst
extends RequirementIngredientArray {
    protected final List<RecipeModifier> modifierList = new ArrayList<RecipeModifier>();
    protected final List<String> toolTipList = new ArrayList<String>();
    protected boolean isRequired = false;

    public RequirementCatalyst(ItemStack item) {
        super(Collections.singletonList(new ChancedIngredientStack(item)));
        this.setParallelizeUnaffected(true);
    }

    public RequirementCatalyst(String oreDictName, int amount) {
        super(Collections.singletonList(new ChancedIngredientStack(oreDictName, amount)));
        this.setParallelizeUnaffected(true);
    }

    public RequirementCatalyst(List<ChancedIngredientStack> ingredients) {
        super(ingredients);
        this.setParallelizeUnaffected(true);
    }

    public void addModifier(RecipeModifier modifier) {
        this.modifierList.add(modifier);
    }

    public void addTooltip(String tooltip) {
        this.toolTipList.add(tooltip);
    }

    public List<String> getToolTipList() {
        return this.toolTipList;
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        if (super.canStartCrafting(components, context).isSuccess() && !this.isRequired) {
            this.addModifierToContext(context);
            this.isRequired = true;
            return CraftCheck.success();
        }
        this.isRequired = false;
        return CraftCheck.skipComponent();
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        int result = super.getMaxParallelism(components, context, maxParallelism);
        if (result >= 1 && !this.isRequired) {
            this.addModifierToContext(context);
            this.isRequired = true;
        } else {
            this.isRequired = false;
        }
        return maxParallelism;
    }

    protected void addModifierToContext(RecipeCraftingContext context) {
        if (this.parallelism > 1) {
            for (RecipeModifier mod : this.modifierList) {
                context.addPermanentModifier(mod.multiply(this.parallelism));
            }
        } else {
            for (RecipeModifier modifier : this.modifierList) {
                context.addPermanentModifier(modifier);
            }
        }
    }

    @Override
    public void startCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.isRequired) {
            super.startCrafting(components, context, chance);
            this.isRequired = false;
        }
    }

    @Override
    public RequirementCatalyst deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    @Override
    public RequirementCatalyst deepCopyModified(List<RecipeModifier> modifiers) {
        ArrayList<ChancedIngredientStack> copiedIngredients = new ArrayList<ChancedIngredientStack>();
        this.ingredients.forEach(item -> {
            ChancedIngredientStack copied = item.copy();
            switch (copied.ingredientType) {
                case ITEMSTACK: {
                    ItemStack itemStack = copied.itemStack;
                    int amt = Math.round(RecipeModifier.applyModifiers((Collection<RecipeModifier>)modifiers, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, (float)itemStack.func_190916_E(), false));
                    itemStack.func_190920_e(amt);
                    break;
                }
                case ORE_DICT: {
                    copied.count = Math.round(RecipeModifier.applyModifiers((Collection<RecipeModifier>)modifiers, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, (float)item.count, false));
                }
            }
            copied.chance = RecipeModifier.applyModifiers((Collection<RecipeModifier>)modifiers, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, item.chance, true);
            copiedIngredients.add(copied);
        });
        RequirementCatalyst catalyst = new RequirementCatalyst(copiedIngredients);
        catalyst.modifierList.addAll(this.modifierList);
        catalyst.toolTipList.addAll(this.toolTipList);
        catalyst.chance = RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, this.actionType, this.chance, true);
        return catalyst;
    }

    @Override
    public ComponentRequirement.JEIComponent<ItemStack> provideJEIComponent() {
        return new JEIComponentCatalyst(this);
    }
}

