/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.helper;

import github.kasuminova.mmce.common.concurrent.Sync;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.recipe.ResultChanceCreateEvent;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.command.ControllerCommandSender;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RequirementComponents;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementDuration;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.modifier.SingleBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecipeCraftingContext {
    private static final Random RAND = new Random();
    private final int reloadCounter;
    private final Map<RequirementType<?, ?>, List<RecipeModifier>> modifiers = new ConcurrentHashMap();
    private final Map<RequirementType<?, ?>, RecipeModifier.ModifierApplier> modifierAppliers = new ConcurrentHashMap();
    private final Map<RequirementType<?, ?>, RecipeModifier.ModifierApplier> chanceModifierAppliers = new ConcurrentHashMap();
    private final List<RecipeModifier> permanentModifierList = new ArrayList<RecipeModifier>();
    private final List<ComponentOutputRestrictor> currentRestrictions = new ArrayList<ComponentOutputRestrictor>();
    private final List<ComponentRequirement<?, ?>> requirements = new ArrayList();
    private final List<RequirementComponents> requirementComponents = new ArrayList<RequirementComponents>();
    private ActiveMachineRecipe activeRecipe;
    private TileMultiblockMachineController controller = null;
    private ControllerCommandSender commandSender = null;
    private Collection<ProcessingComponent<?>> typeComponents = new ArrayList();
    private int currentIOTickIndex = 0;

    public RecipeCraftingContext(int reloadCounter, ActiveMachineRecipe activeRecipe, TileMultiblockMachineController controller) {
        this.reloadCounter = reloadCounter;
        this.activeRecipe = activeRecipe;
        for (ComponentRequirement<?, ?> requirement : this.getParentRecipe().getCraftingRequirements()) {
            this.requirements.add(this.requirements.size(), requirement.deepCopy().postDeepCopy(requirement));
        }
        this.init(activeRecipe, controller);
    }

    public RecipeCraftingContext reset() {
        this.modifiers.clear();
        this.modifierAppliers.clear();
        this.chanceModifierAppliers.clear();
        this.permanentModifierList.clear();
        this.currentRestrictions.clear();
        this.currentIOTickIndex = 0;
        return this;
    }

    public RecipeCraftingContext resetAll() {
        this.setParallelism(1);
        this.activeRecipe = null;
        this.controller = null;
        this.commandSender = null;
        this.typeComponents = null;
        this.requirementComponents.clear();
        return this.reset();
    }

    public void destroy() {
        this.resetAll();
        this.requirements.clear();
    }

    public RecipeCraftingContext init(ActiveMachineRecipe activeRecipe, TileMultiblockMachineController ctrl) {
        this.controller = ctrl;
        this.activeRecipe = activeRecipe;
        this.commandSender = new ControllerCommandSender(this.controller);
        this.reset();
        this.updateComponents(ctrl.getFoundComponents().values());
        return this;
    }

    public int getReloadCounter() {
        return this.reloadCounter;
    }

    public TileMultiblockMachineController getMachineController() {
        return this.controller;
    }

    public MachineRecipe getParentRecipe() {
        return this.activeRecipe.getRecipe();
    }

    public ActiveMachineRecipe getActiveRecipe() {
        return this.activeRecipe;
    }

    @Nonnull
    public List<RecipeModifier> getModifiers(RequirementType<?, ?> target) {
        return this.modifiers.computeIfAbsent(target, t -> new CopyOnWriteArrayList());
    }

    @Nonnull
    public RecipeModifier.ModifierApplier getModifierApplier(RequirementType<?, ?> target, boolean isChance) {
        return isChance ? this.chanceModifierAppliers.getOrDefault(target, RecipeModifier.ModifierApplier.DEFAULT_APPLIER) : this.modifierAppliers.getOrDefault(target, RecipeModifier.ModifierApplier.DEFAULT_APPLIER);
    }

    public float getDurationMultiplier() {
        if (!Config.enableDurationMultiplier) {
            return 1.0f;
        }
        float dur = this.getParentRecipe().getRecipeTotalTickTime();
        float result = RecipeModifier.applyModifiers(this, RequirementTypesMM.REQUIREMENT_DURATION, null, dur, false);
        return dur / result;
    }

    public void addRestriction(ComponentOutputRestrictor restrictor) {
        this.currentRestrictions.add(restrictor);
    }

    public List<ProcessingComponent<?>> getComponentsFor(ComponentRequirement<?, ?> requirement, @Nullable ComponentSelectorTag tag) {
        ArrayList validComponents = new ArrayList();
        for (ProcessingComponent<?> typeComponent : this.typeComponents) {
            if (!requirement.isValidComponent(typeComponent, this)) continue;
            if (tag != null) {
                if (!tag.equals(typeComponent.getTag())) continue;
                validComponents.add(typeComponent);
                continue;
            }
            validComponents.add(typeComponent);
        }
        return validComponents;
    }

    public CraftingCheckResult ioTick(int currentTick) {
        ResultChance chance = new ResultChance(RAND.nextLong());
        CraftingCheckResult checkResult = new CraftingCheckResult();
        float durMultiplier = this.getDurationMultiplier();
        for (int i = this.currentIOTickIndex; i < this.requirementComponents.size(); ++i) {
            CraftCheck result;
            RequirementComponents reqComponent = this.requirementComponents.get(i);
            ComponentRequirement<?, ?> requirement = reqComponent.requirement();
            if (!(requirement instanceof ComponentRequirement.PerTick)) {
                if (requirement.getTriggerTime() < 1) continue;
                this.checkAndTriggerRequirement(checkResult, currentTick, chance, reqComponent);
                if (!checkResult.isFailure()) continue;
                this.currentIOTickIndex = i;
                return checkResult;
            }
            ComponentRequirement.PerTick perTickReq = (ComponentRequirement.PerTick)requirement;
            if (perTickReq instanceof ComponentRequirement.PerTickMultiComponent) {
                ComponentRequirement.PerTickMultiComponent reqMultiComp = (ComponentRequirement.PerTickMultiComponent)perTickReq;
                CraftCheck craftCheck = reqMultiComp.doIOTick(reqComponent.components(), this, durMultiplier);
                if (craftCheck.isSuccess()) continue;
                this.currentIOTickIndex = i;
                checkResult.addError(craftCheck.getUnlocalizedMessage());
                return checkResult;
            }
            perTickReq.resetIOTick(this);
            perTickReq.startIOTick(this, durMultiplier);
            for (ProcessingComponent processingComponent : reqComponent.components()) {
                AtomicReference<CraftCheck> result3 = new AtomicReference<CraftCheck>();
                if (perTickReq instanceof Asyncable) {
                    result3.set(perTickReq.doIOTick(processingComponent, this));
                } else {
                    Sync.doSyncAction(() -> result3.set(perTickReq.doIOTick(component, this)));
                }
                if (!((CraftCheck)result3.get()).isSuccess()) continue;
                break;
            }
            if ((result = perTickReq.resetIOTick(this)).isSuccess()) continue;
            this.currentIOTickIndex = i;
            checkResult.addError(result.getUnlocalizedMessage());
            return checkResult;
        }
        this.currentIOTickIndex = 0;
        this.getParentRecipe().getCommandContainer().runTickCommands(this.commandSender, currentTick);
        return CraftingCheckResult.SUCCESS;
    }

    public List<ComponentRequirement<?, ?>> getRequirementBy(RequirementType<?, ?> type) {
        return this.requirements.stream().filter(req -> req.getRequirementType().equals(type)).collect(Collectors.toList());
    }

    public List<ComponentRequirement<?, ?>> getRequirementBy(RequirementType<?, ?> type, IOType ioType) {
        return this.requirements.stream().filter(req -> req.getRequirementType().equals(type) && req.getActionType() == ioType).collect(Collectors.toList());
    }

    private void checkAndTriggerRequirement(CraftingCheckResult res, int currentTick, ResultChance chance, RequirementComponents reqComponent) {
        ComponentRequirement<?, ?> req = reqComponent.requirement();
        int triggerTime = req.getTriggerTime() * Math.round(RecipeModifier.applyModifiers(this, RequirementTypesMM.REQUIREMENT_DURATION, null, 1.0f, false));
        if (triggerTime <= 0 || triggerTime != currentTick || req.isTriggered() && !req.isTriggerRepeatable()) {
            return;
        }
        if (this.canStartCrafting(res, reqComponent, new ReqCompMap(), new TaggedReqCompMap())) {
            this.startCrafting(chance, reqComponent);
            req.setTriggered(true);
        }
    }

    public void startCrafting() {
        this.startCrafting(RAND.nextLong());
    }

    public void startCrafting(long seed) {
        ResultChance chance = new ResultChance(seed);
        for (RequirementComponents reqComponents : this.requirementComponents) {
            if (reqComponents.requirement().getTriggerTime() > 0) continue;
            this.startCrafting(chance, reqComponents);
        }
        this.getParentRecipe().getCommandContainer().runStartCommands(this.commandSender);
    }

    private void startCrafting(ResultChance chance, RequirementComponents reqComponents) {
        ComponentRequirement<?, ?> requirement = reqComponents.requirement();
        if (requirement instanceof ComponentRequirement.MultiComponent) {
            ComponentRequirement.MultiComponent req = (ComponentRequirement.MultiComponent)((Object)requirement);
            req.startCrafting(reqComponents.components(), this, chance);
            return;
        }
        requirement.startRequirementCheck(chance, this);
        for (ProcessingComponent<?> component : reqComponents.components()) {
            AtomicBoolean success = new AtomicBoolean(false);
            if (requirement instanceof Asyncable) {
                success.set(requirement.startCrafting(component, this, chance));
            } else {
                Sync.doSyncAction(() -> success.set(requirement.startCrafting(component, this, chance)));
            }
            if (!success.get()) continue;
            requirement.endRequirementCheck();
            return;
        }
        requirement.endRequirementCheck();
    }

    public void finishCrafting() {
        this.finishCrafting(RAND.nextLong());
    }

    public void finishCrafting(long seed) {
        ResultChanceCreateEvent event = new ResultChanceCreateEvent(this.controller, this, new ResultChance(seed), Phase.END);
        event.postEvent();
        ResultChance chance = event.getResultChance();
        for (RequirementComponents reqComponents : this.requirementComponents) {
            ComponentRequirement<?, ?> requirement = reqComponents.requirement();
            List<ProcessingComponent<?>> components = reqComponents.components();
            if (requirement instanceof ComponentRequirement.MultiComponent) {
                ComponentRequirement.MultiComponent reqMulti = (ComponentRequirement.MultiComponent)((Object)requirement);
                reqMulti.finishCrafting(components, this, chance);
                continue;
            }
            requirement.startRequirementCheck(chance, this);
            for (ProcessingComponent<?> component : components) {
                AtomicReference<CraftCheck> check = new AtomicReference<CraftCheck>();
                if (requirement instanceof Asyncable) {
                    check.set(requirement.finishCrafting(component, this, chance));
                } else {
                    Sync.doSyncAction(() -> check.set(requirement.finishCrafting(component, this, chance)));
                }
                if (!((CraftCheck)check.get()).isSuccess()) continue;
                break;
            }
            requirement.endRequirementCheck();
        }
        this.getParentRecipe().getCommandContainer().runFinishCommands(this.commandSender);
    }

    public List<RequirementComponents> getAllParallelizableComponents() {
        ArrayList<RequirementComponents> list = new ArrayList<RequirementComponents>();
        for (RequirementComponents reqComponent : this.requirementComponents) {
            ComponentRequirement.Parallelizable parallelizable;
            ComponentRequirement<?, ?> componentRequirement = reqComponent.requirement();
            if (!(componentRequirement instanceof ComponentRequirement.Parallelizable) || (parallelizable = (ComponentRequirement.Parallelizable)((Object)componentRequirement)).isParallelizeUnaffected()) continue;
            list.add(reqComponent);
        }
        return list;
    }

    public int getMaxParallelism(List<RequirementComponents> parallelizable) {
        int maxParallelism = this.activeRecipe.getMaxParallelism();
        ReqCompMap typeCopiedComp = new ReqCompMap();
        TaggedReqCompMap taggedTypeCopiedComp = new TaggedReqCompMap();
        int reqMaxParallelism = maxParallelism;
        for (RequirementComponents reqComponent : parallelizable) {
            List<ProcessingComponent<?>> compList;
            List<ProcessingComponent<?>> copiedCompList;
            ComponentRequirement<?, ?> req = reqComponent.requirement();
            ComponentRequirement.Parallelizable requirement = (ComponentRequirement.Parallelizable)((Object)req);
            if ((reqMaxParallelism = Math.min(reqMaxParallelism, requirement.getMaxParallelism(copiedCompList = RecipeCraftingContext.getCopiedRequirementComponents(typeCopiedComp, taggedTypeCopiedComp, req, compList = reqComponent.components()), this, reqMaxParallelism))) > 0) continue;
            return 0;
        }
        return reqMaxParallelism;
    }

    public void setParallelism(int parallelism) {
        for (RequirementComponents obj : this.requirementComponents) {
            if (!(obj.requirement() instanceof ComponentRequirement.Parallelizable)) continue;
            ((ComponentRequirement.Parallelizable)((Object)obj.requirement())).setParallelism(parallelism);
        }
        this.activeRecipe.setParallelism(parallelism);
    }

    public CraftingCheckResult canStartCrafting() {
        this.permanentModifierList.clear();
        if (this.getParentRecipe().isParallelized() && this.activeRecipe.getMaxParallelism() > 1) {
            List<RequirementComponents> parallelizable = this.getAllParallelizableComponents();
            int maxParallelism = this.getMaxParallelism(parallelizable);
            this.setParallelism(Math.max(1, maxParallelism));
            if (maxParallelism > 0 && parallelizable.size() >= this.requirementComponents.size()) {
                return CraftingCheckResult.SUCCESS;
            }
        }
        return this.canStartCrafting(req -> true);
    }

    public CraftingCheckResult canRestartCrafting() {
        this.permanentModifierList.clear();
        int currentParallelism = this.activeRecipe.getParallelism();
        int maxParallelism = this.activeRecipe.getMaxParallelism();
        if (currentParallelism > maxParallelism) {
            this.setParallelism(maxParallelism);
            CraftingCheckResult result = this.canStartCrafting(req -> true);
            if (!result.isSuccess()) {
                this.setParallelism(1);
            } else {
                return CraftingCheckResult.SUCCESS;
            }
        }
        return this.canStartCrafting();
    }

    public CraftingCheckResult canFinishCrafting() {
        return this.canStartCrafting(req -> req.requirement().actionType == IOType.OUTPUT);
    }

    public CraftingCheckResult canStartCrafting(Predicate<RequirementComponents> filter) {
        this.currentRestrictions.clear();
        ArrayList<RequirementComponents> requirements = new ArrayList<RequirementComponents>();
        for (RequirementComponents requirementComponent : this.requirementComponents) {
            if (!filter.test(requirementComponent)) continue;
            requirements.add(requirementComponent);
        }
        CraftingCheckResult result = new CraftingCheckResult();
        float successfulRequirements = 0.0f;
        ReqCompMap typeCopiedComp = new ReqCompMap();
        TaggedReqCompMap taggedTypeCopiedComp = new TaggedReqCompMap();
        for (RequirementComponents reqEntry : requirements) {
            if (!this.canStartCrafting(result, reqEntry, typeCopiedComp, taggedTypeCopiedComp)) continue;
            successfulRequirements += 1.0f;
        }
        result.setValidity(successfulRequirements / (float)requirements.size());
        this.currentRestrictions.clear();
        return result;
    }

    private boolean canStartCrafting(CraftingCheckResult result, RequirementComponents reqComponent, ReqCompMap reqCompMap, TaggedReqCompMap taggedReqCompMap) {
        ComponentRequirement<?, ?> req = reqComponent.requirement();
        req.startRequirementCheck(ResultChance.GUARANTEED, this);
        List<ProcessingComponent<?>> compList = reqComponent.components();
        if (!compList.isEmpty()) {
            if (req instanceof ComponentRequirement.MultiComponent) {
                ComponentRequirement.MultiComponent reqMulti = (ComponentRequirement.MultiComponent)((Object)req);
                List<ProcessingComponent<?>> copiedCompList = RecipeCraftingContext.getCopiedRequirementComponents(reqCompMap, taggedReqCompMap, req, compList);
                CraftCheck check = reqMulti.canStartCrafting(copiedCompList, this);
                if (check.isSuccess()) {
                    return true;
                }
                result.addError(check.getUnlocalizedMessage());
                return false;
            }
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (ProcessingComponent<?> component : compList) {
                CraftCheck check = req.canStartCrafting(component, this, this.currentRestrictions);
                if (check.isSuccess()) {
                    req.endRequirementCheck();
                    return true;
                }
                if (check.isInvalid() || check.getUnlocalizedMessage().isEmpty()) continue;
                errorMessages.add(check.getUnlocalizedMessage());
            }
            errorMessages.forEach(result::addError);
        } else {
            result.addError(req.getMissingComponentErrorMessage(req.actionType));
        }
        req.endRequirementCheck();
        return false;
    }

    private static List<ProcessingComponent<?>> getCopiedRequirementComponents(ReqCompMap reqCompMap, TaggedReqCompMap taggedReqCompMap, ComponentRequirement<?, ?> req, List<ProcessingComponent<?>> compList) {
        List copiedCompList = req.tag != null ? ((Map)taggedReqCompMap.computeIfAbsent(req.actionType, reqTypeMap -> new Object2ObjectArrayMap()).computeIfAbsent(req.requirementType, tagMap -> new Object2ObjectOpenHashMap())).computeIfAbsent(req.tag, comp -> ((ComponentRequirement.MultiComponent)((Object)req)).copyComponents(compList)) : (List)reqCompMap.computeIfAbsent(req.actionType, reqTypeMap -> new Object2ObjectArrayMap()).computeIfAbsent(req.requirementType, comp -> ((ComponentRequirement.MultiComponent)((Object)req)).copyComponents(compList));
        return copiedCompList;
    }

    public void updateComponents(Collection<ProcessingComponent<?>> components) {
        this.typeComponents = components;
        this.updateRequirementComponents();
    }

    public void updateRequirementComponents() {
        this.requirementComponents.clear();
        this.requirements.forEach(req -> this.requirementComponents.add(new RequirementComponents((ComponentRequirement<?, ?>)req, this.getComponentsFor((ComponentRequirement<?, ?>)req, req.tag))));
    }

    public void addModifier(SingleBlockModifierReplacement replacement) {
        this.addModifier(replacement.getModifiers());
    }

    public void addModifier(RecipeModifier modifier) {
        if (modifier != null) {
            RequirementDuration target = modifier.getTarget();
            if (target == null) {
                target = RequirementTypesMM.REQUIREMENT_DURATION;
            }
            this.modifiers.computeIfAbsent(target, t -> new CopyOnWriteArrayList()).add(modifier);
            this.updateModifierApplier(target);
        }
    }

    public void addModifier(Collection<RecipeModifier> modifiers) {
        HashSet<RequirementDuration> changed = new HashSet<RequirementDuration>();
        for (RecipeModifier modifier : modifiers) {
            RequirementDuration target = modifier.getTarget();
            if (target == null) {
                target = RequirementTypesMM.REQUIREMENT_DURATION;
            }
            this.modifiers.computeIfAbsent(target, t -> new CopyOnWriteArrayList()).add(modifier);
            changed.add(target);
        }
        changed.forEach(this::updateModifierApplier);
    }

    public void addModifier(List<RecipeModifier> modifiers) {
        if (modifiers.isEmpty()) {
            return;
        }
        if (modifiers.size() == 1) {
            this.addModifier(modifiers.get(0));
            return;
        }
        this.addModifier((Collection<RecipeModifier>)modifiers);
    }

    public void addPermanentModifier(RecipeModifier modifier) {
        if (modifier != null) {
            this.permanentModifierList.add(modifier);
            this.addModifier(modifier);
        }
    }

    public void updateModifierApplier(RequirementType<?, ?> reqType) {
        this.addModifierApplier(reqType, this.modifiers.computeIfAbsent(reqType, v -> new CopyOnWriteArrayList()));
    }

    public void addModifierApplier(RequirementType<?, ?> reqType, List<RecipeModifier> recipeModifiers) {
        RecipeModifier.ModifierApplier applier = new RecipeModifier.ModifierApplier();
        RecipeModifier.ModifierApplier chancedApplier = new RecipeModifier.ModifierApplier();
        recipeModifiers.forEach(mod -> RecipeModifier.applyValueToApplier(mod.affectsChance() ? chancedApplier : applier, mod));
        if (!applier.isDefault()) {
            this.modifierAppliers.put(reqType, applier);
        }
        if (!chancedApplier.isDefault()) {
            this.chanceModifierAppliers.put(reqType, chancedApplier);
        }
    }

    public void overrideModifier(Collection<RecipeModifier> modifiers) {
        this.modifiers.clear();
        this.modifierAppliers.clear();
        this.chanceModifierAppliers.clear();
        this.addModifier(modifiers);
        this.addModifier(this.permanentModifierList);
    }

    public static class CraftingCheckResult {
        private static final CraftingCheckResult SUCCESS = new CraftingCheckResult(){

            @Override
            public void addError(String ignored) {
                throw new IllegalStateException("Cannot add error on SUCCESS result!");
            }

            @Override
            public void overrideError(String ignored) {
                throw new IllegalStateException("Cannot add error on SUCCESS result!");
            }

            @Override
            public List<String> getUnlocalizedErrorMessages() {
                return Collections.emptyList();
            }

            @Override
            public String getFirstErrorMessage(String defaultMessage) {
                return defaultMessage;
            }
        };
        private final Map<String, Integer> unlocErrorMessagesMap = new HashMap<String, Integer>();
        public float validity = 0.0f;

        public void addError(String unlocError) {
            if (!unlocError.isEmpty()) {
                int count = this.unlocErrorMessagesMap.getOrDefault(unlocError, 0);
                this.unlocErrorMessagesMap.put(unlocError, ++count);
            }
        }

        public void overrideError(String unlocError) {
            this.unlocErrorMessagesMap.clear();
            this.addError(unlocError);
        }

        public float getValidity() {
            return this.validity;
        }

        private void setValidity(float validity) {
            this.validity = validity;
        }

        public List<String> getUnlocalizedErrorMessages() {
            ArrayList<Map.Entry<String, Integer>> toSort = new ArrayList<Map.Entry<String, Integer>>(this.unlocErrorMessagesMap.entrySet());
            toSort.sort(Map.Entry.comparingByValue());
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry entry : toSort) {
                String key = (String)entry.getKey();
                list.add(key);
            }
            return list;
        }

        public String getFirstErrorMessage(String defaultMessage) {
            List<String> unlocalizedErrorMessages = this.getUnlocalizedErrorMessages();
            return unlocalizedErrorMessages.isEmpty() ? defaultMessage : unlocalizedErrorMessages.get(0);
        }

        public boolean isFailure() {
            return !this.unlocErrorMessagesMap.isEmpty();
        }

        public boolean isSuccess() {
            return this.unlocErrorMessagesMap.isEmpty();
        }
    }

    public static class ReqCompMap
    extends EnumMap<IOType, Object2ObjectArrayMap<RequirementType<?, ?>, List<ProcessingComponent<?>>>> {
        public ReqCompMap() {
            super(IOType.class);
        }

        @Override
        public final ReqCompMap clone() throws AssertionError {
            throw new AssertionError();
        }
    }

    public static class TaggedReqCompMap
    extends EnumMap<IOType, Object2ObjectArrayMap<RequirementType<?, ?>, Map<ComponentSelectorTag, List<ProcessingComponent<?>>>>> {
        public TaggedReqCompMap() {
            super(IOType.class);
        }

        @Override
        public final TaggedReqCompMap clone() throws AssertionError {
            throw new AssertionError();
        }
    }
}

