/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.helper;

import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;

public class CraftingStatus {
    public static final CraftingStatus SUCCESS = new CraftingStatus(TileMultiblockMachineController.Type.CRAFTING, "");
    public static final CraftingStatus MISSING_STRUCTURE = new CraftingStatus(TileMultiblockMachineController.Type.MISSING_STRUCTURE, "");
    public static final CraftingStatus CHUNK_UNLOADED = new CraftingStatus(TileMultiblockMachineController.Type.CHUNK_UNLOADED, "");
    public static final CraftingStatus IDLE = new CraftingStatus(TileMultiblockMachineController.Type.IDLE, "");
    private final TileMultiblockMachineController.Type status;
    private String unlocalizedMessage;

    public CraftingStatus(TileMultiblockMachineController.Type status, String unlocalizedMessage) {
        this.status = status;
        this.unlocalizedMessage = unlocalizedMessage;
    }

    public static CraftingStatus working() {
        return SUCCESS;
    }

    public static CraftingStatus working(String unlocMessage) {
        return new CraftingStatus(TileMultiblockMachineController.Type.CRAFTING, unlocMessage);
    }

    public static CraftingStatus failure(String unlocMessage) {
        return new CraftingStatus(TileMultiblockMachineController.Type.NO_RECIPE, unlocMessage);
    }

    public static CraftingStatus deserialize(NBTTagCompound tag) {
        TileMultiblockMachineController.Type type = TileMultiblockMachineController.Type.values()[tag.func_74771_c("type")];
        String unlocMessage = tag.func_74779_i("message");
        return new CraftingStatus(type, unlocMessage);
    }

    public TileMultiblockMachineController.Type getStatus() {
        return this.status;
    }

    public String getUnlocMessage() {
        return !this.unlocalizedMessage.isEmpty() ? this.unlocalizedMessage : this.status.getUnlocalizedDescription();
    }

    public void overrideStatusMessage(String unlocalizedMessage) {
        this.unlocalizedMessage = unlocalizedMessage;
    }

    public boolean isCrafting() {
        return this.status == TileMultiblockMachineController.Type.CRAFTING;
    }

    public NBTTagCompound serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("type", (byte)this.status.ordinal());
        tag.func_74778_a("message", this.unlocalizedMessage);
        return tag;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CraftingStatus)) {
            return false;
        }
        CraftingStatus another = (CraftingStatus)obj;
        if (this.status != another.status) {
            return false;
        }
        return this.unlocalizedMessage.equals(another.unlocalizedMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.unlocalizedMessage});
    }
}

