/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.helper;

import net.minecraft.nbt.NBTTagCompound;

public class CraftCheck {
    private static final CraftCheck SUCCESS = new CraftCheck(ResultType.SUCCESS, "");
    private static final CraftCheck PARTIAL_SUCCESS = new CraftCheck(ResultType.PARTIAL_SUCCESS, "");
    private static final CraftCheck INVALID_SKIP = new CraftCheck(ResultType.INVALID_SKIP, "");
    private final ResultType type;
    private final String unlocalizedMessage;

    protected CraftCheck(ResultType type, String unlocalizedMessage) {
        this.type = type;
        this.unlocalizedMessage = unlocalizedMessage;
    }

    public static CraftCheck success() {
        return SUCCESS;
    }

    public static CraftCheck partialSuccess() {
        return PARTIAL_SUCCESS;
    }

    public static CraftCheck skipComponent() {
        return INVALID_SKIP;
    }

    public static CraftCheck failure(String unlocMessage) {
        return new CraftCheck(ResultType.FAILURE_MISSING_INPUT, unlocMessage);
    }

    public static CraftCheck deserialize(NBTTagCompound tag) {
        ResultType type = ResultType.values()[tag.func_74762_e("type")];
        String unlocMessage = tag.func_74779_i("message");
        return new CraftCheck(type, unlocMessage);
    }

    public ResultType getType() {
        return this.type;
    }

    public String getUnlocalizedMessage() {
        return this.unlocalizedMessage;
    }

    public boolean isSuccess() {
        return this.type == ResultType.SUCCESS;
    }

    public boolean isInvalid() {
        return this.type == ResultType.INVALID_SKIP;
    }

    public NBTTagCompound serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", this.type.ordinal());
        tag.func_74778_a("message", this.unlocalizedMessage);
        return tag;
    }

    public static enum ResultType {
        SUCCESS,
        PARTIAL_SUCCESS,
        FAILURE_MISSING_INPUT,
        INVALID_SKIP;

    }
}

