/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.adapter.tconstruct;

import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementFluid;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

public class AdapterSmelteryMeltingRecipe
extends RecipeAdapter {
    public AdapterSmelteryMeltingRecipe() {
        super(new ResourceLocation("tconstruct", "smeltery_melting"));
    }

    @Override
    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements, Map<Class<?>, List<IEventHandler<RecipeEvent>>> eventHandlers, List<String> recipeTooltips) {
        List meltingRecipes = TinkerRegistry.getAllMeltingRecipies();
        ArrayList<MachineRecipe> machineRecipeList = new ArrayList<MachineRecipe>(meltingRecipes.size());
        for (MeltingRecipe meltingRecipe : meltingRecipes) {
            MachineRecipe recipe = this.createRecipeShell(new ResourceLocation("tconstruct", "smeltery_melting_" + this.incId), owningMachineName, Math.max(Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_DURATION, IOType.INPUT, (float)meltingRecipe.temperature / 10.0f, false)), 1), this.incId, false);
            recipe.addRecipeEventHandler(RecipeCheckEvent.class, event -> {
                if (event.phase == Phase.START) {
                    event.getActiveRecipe().getDataCompound().func_74776_a("temperatureRequired", (float)meltingRecipe.temperature);
                }
            });
            List inputs = meltingRecipe.input.getInputs();
            ArrayList<ChancedIngredientStack> ingredientStackList = new ArrayList<ChancedIngredientStack>(inputs.size());
            for (ItemStack stack : inputs) {
                int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.INPUT, (float)stack.func_190916_E(), false));
                if (inAmount <= 0) continue;
                ItemStack input = ItemUtils.copyStackWithSize(stack, inAmount);
                ingredientStackList.add(new ChancedIngredientStack(input));
            }
            recipe.addRequirement(new RequirementIngredientArray(ingredientStackList));
            FluidStack output = meltingRecipe.getResult().copy();
            int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_FLUID, IOType.INPUT, (float)output.amount, false));
            if (inAmount > 0) {
                output.amount = inAmount;
                recipe.addRequirement(new RequirementFluid(IOType.OUTPUT, output));
            }
            machineRecipeList.add(recipe);
            ++this.incId;
        }
        return machineRecipeList;
    }
}

