/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.adapter.tc6;

import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import kport.modularmagic.common.crafting.requirement.RequirementAspect;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.crafting.InfusionRecipe;

public class AdapterTC6InfusionMatrix
extends RecipeAdapter {
    public static final int BASE_WORK_TIME = 300;

    public AdapterTC6InfusionMatrix() {
        super(new ResourceLocation("thaumcraft", "infusion_matrix"));
    }

    @Override
    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements, Map<Class<?>, List<IEventHandler<RecipeEvent>>> eventHandlers, List<String> recipeTooltips) {
        ArrayList<MachineRecipe> machineRecipeList = new ArrayList<MachineRecipe>();
        ThaumcraftApi.getCraftingRecipes().forEach((recipeName, tcRecipe) -> {
            if (!(tcRecipe instanceof InfusionRecipe)) {
                return;
            }
            InfusionRecipe recipe = (InfusionRecipe)tcRecipe;
            if (recipe.getRecipeInput() == null) {
                return;
            }
            if (recipe.recipeOutput == null) {
                return;
            }
            int inAmount = Math.round(RecipeModifier.applyModifiers((Collection<RecipeModifier>)modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.INPUT, 1.0f, false));
            if (inAmount <= 0) {
                return;
            }
            MachineRecipe machineRecipe = this.createRecipeShell(new ResourceLocation("thaumcraft", "auto_infusion" + this.incId), owningMachineName, recipe.instability == 0 ? 300 : recipe.instability * 1000, this.incId, false);
            ItemStack[] inputMain = recipe.getRecipeInput().func_193365_a();
            List<ChancedIngredientStack> inputMainList = Arrays.stream(inputMain).map(itemStack -> new ChancedIngredientStack(ItemUtils.copyStackWithSize(itemStack, inAmount))).collect(Collectors.toList());
            if (!inputMainList.isEmpty()) {
                machineRecipe.addRequirement(new RequirementIngredientArray(inputMainList));
            }
            recipe.getComponents().stream().map(ingredient -> Arrays.stream(ingredient.func_193365_a()).map(ChancedIngredientStack::new).collect(Collectors.toList())).filter(stackList -> !stackList.isEmpty()).map(RequirementIngredientArray::new).forEach(machineRecipe::addRequirement);
            recipe.getAspects().aspects.forEach((aspect, amount) -> machineRecipe.addRequirement(new RequirementAspect(IOType.INPUT, (int)amount, (Aspect)aspect)));
            Object output = recipe.recipeOutput;
            if (output != null) {
                if (output instanceof ItemStack) {
                    int outAmount = Math.round(RecipeModifier.applyModifiers((Collection<RecipeModifier>)modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.OUTPUT, (float)((ItemStack)output).func_190916_E(), false));
                    if (outAmount > 0) {
                        machineRecipe.addRequirement(new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize((ItemStack)output, outAmount)));
                    }
                } else {
                    Object[] objects = (Object[])output;
                    for (ItemStack stack : recipe.getRecipeInput().func_193365_a()) {
                        if (stack == null) continue;
                        ItemStack copied = stack.func_77946_l();
                        copied.func_77983_a((String)objects[0], (NBTBase)objects[1]);
                        machineRecipe.addRequirement(new RequirementItem(IOType.OUTPUT, copied));
                    }
                }
            }
            machineRecipeList.add(machineRecipe);
            ++this.incId;
        });
        return machineRecipeList;
    }
}

