/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.adapter.ic2;

import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import ic2.api.recipe.IRecipeInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class AdapterIC2Machine
extends RecipeAdapter {
    public AdapterIC2Machine(@Nonnull ResourceLocation registryName) {
        super(registryName);
    }

    protected void convertIC2RecipeToMMRecipe(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, Iterable<? extends ic2.api.recipe.MachineRecipe<IRecipeInput, Collection<ItemStack>>> machineRecipes, List<MachineRecipe> recipes, String recipeRegistryNamePrefix, int workTime) {
        for (ic2.api.recipe.MachineRecipe<IRecipeInput, Collection<ItemStack>> machineRecipe : machineRecipes) {
            MachineRecipe recipe = this.createRecipeShell(new ResourceLocation("ic2", recipeRegistryNamePrefix + this.incId), owningMachineName, Math.max(1, Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_DURATION, null, (float)workTime, false))), this.incId, false);
            int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.INPUT, (float)((IRecipeInput)machineRecipe.getInput()).getAmount(), false));
            if (inAmount > 0) {
                List inputs = ((IRecipeInput)machineRecipe.getInput()).getInputs();
                if (inputs.size() > 1) {
                    ArrayList<ChancedIngredientStack> ingredients = new ArrayList<ChancedIngredientStack>();
                    Iterator iterator = inputs.iterator();
                    while (iterator.hasNext()) {
                        ItemStack input = (ItemStack)iterator.next();
                        ingredients.add(new ChancedIngredientStack(ItemUtils.copyStackWithSize(input, inAmount)));
                    }
                    recipe.addRequirement(new RequirementIngredientArray(ingredients));
                } else {
                    ItemStack input = (ItemStack)inputs.get(0);
                    recipe.addRequirement(new RequirementItem(IOType.INPUT, ItemUtils.copyStackWithSize(input, inAmount)));
                }
            }
            for (ItemStack output : (Collection)machineRecipe.getOutput()) {
                int outAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.OUTPUT, (float)output.func_190916_E(), false));
                if (outAmount <= 0) continue;
                recipe.addRequirement(new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize(output, outAmount)));
            }
            int inEnergy = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ENERGY, IOType.INPUT, 8.0f, false));
            if (inEnergy > 0) {
                recipe.addRequirement(new RequirementEnergy(IOType.INPUT, inEnergy));
            }
            recipes.add(recipe);
            ++this.incId;
        }
    }
}

