/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.PreparedRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapterAccessor;
import hellfirepvp.modularmachinery.common.crafting.command.RecipeRunnableCommand;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipeAdapterBuilder;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.util.JsonUtils;

public class RecipeLoader {
    public static final Collection<RecipeAdapterAccessor> RECIPE_ADAPTER_ACCESSORS = new ConcurrentLinkedQueue<RecipeAdapterAccessor>();
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(MachineRecipe.MachineRecipeContainer.class, (Object)new MachineRecipe.Deserializer()).registerTypeHierarchyAdapter(ComponentRequirement.class, (Object)new MachineRecipe.ComponentDeserializer()).registerTypeHierarchyAdapter(RecipeAdapterAccessor.class, (Object)new RecipeAdapterAccessor.Deserializer()).registerTypeHierarchyAdapter(RecipeModifier.class, (Object)new RecipeModifier.Deserializer()).registerTypeHierarchyAdapter(RecipeRunnableCommand.class, (Object)new RecipeRunnableCommand.Deserializer()).create();
    public static final ThreadLocal<String> CURRENTLY_READING_PATH = new ThreadLocal();
    private static Map<String, Exception> failedAttempts = new ConcurrentHashMap<String, Exception>();

    public static Map<FileType, List<File>> discoverDirectory(File directory) {
        EnumMap<FileType, List<File>> candidates = new EnumMap<FileType, List<File>>(FileType.class);
        for (FileType type : FileType.values()) {
            candidates.put(type, Lists.newLinkedList());
        }
        LinkedList directories = Lists.newLinkedList();
        directories.add(directory);
        while (!directories.isEmpty()) {
            File dir = (File)directories.remove(0);
            File[] files = dir.listFiles();
            if (files == null) continue;
            for (File f : files) {
                if (f.isDirectory()) {
                    directories.addLast(f);
                    continue;
                }
                if (FileType.ADAPTER.accepts(f.getName())) {
                    ((List)candidates.get((Object)FileType.ADAPTER)).add(f);
                    continue;
                }
                if (!FileType.RECIPE.accepts(f.getName())) continue;
                ((List)candidates.get((Object)FileType.RECIPE)).add(f);
            }
        }
        return candidates;
    }

    public static Collection<MachineRecipe> loadRecipes(List<File> recipeCandidates, List<PreparedRecipe> preparedRecipes) {
        RECIPE_ADAPTER_ACCESSORS.clear();
        ConcurrentLinkedQueue<MachineRecipe> loadedRecipes = new ConcurrentLinkedQueue<MachineRecipe>();
        recipeCandidates.parallelStream().forEach(f -> {
            CURRENTLY_READING_PATH.set(f.getPath());
            try (InputStreamReader isr = new InputStreamReader(Files.newInputStream(f.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                MachineRecipe.MachineRecipeContainer container = (MachineRecipe.MachineRecipeContainer)JsonUtils.func_193839_a((Gson)GSON, (Reader)isr, MachineRecipe.MachineRecipeContainer.class);
                ConcurrentLinkedQueue concurrentLinkedQueue = loadedRecipes;
                synchronized (concurrentLinkedQueue) {
                    loadedRecipes.addAll(container.getRecipes());
                }
            }
            catch (Exception exc) {
                failedAttempts.put(f.getPath(), exc);
            }
            finally {
                CURRENTLY_READING_PATH.remove();
            }
        });
        for (PreparedRecipe recipe : preparedRecipes) {
            recipe.loadNeedAfterInitActions();
            loadedRecipes.add(RecipeLoader.convertPreparedRecipe(recipe));
        }
        return loadedRecipes;
    }

    public static List<MachineRecipe> loadAdapterRecipes(List<File> adapterCandidates, List<RecipeAdapterBuilder> adapterBuilders) {
        LinkedList<MachineRecipe> loadedRecipes = new LinkedList<MachineRecipe>();
        for (File f : adapterCandidates) {
            try (InputStreamReader isr = new InputStreamReader(Files.newInputStream(f.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                RecipeAdapterAccessor accessor = (RecipeAdapterAccessor)JsonUtils.func_193839_a((Gson)GSON, (Reader)isr, RecipeAdapterAccessor.class);
                List<MachineRecipe> recipes = accessor.loadRecipesForAdapter();
                if (recipes.isEmpty()) {
                    ModularMachinery.log.warn("Adapter with name " + accessor.getAdapterKey().toString() + " didn't provide have any recipes!");
                } else {
                    loadedRecipes.addAll(recipes);
                }
                RECIPE_ADAPTER_ACCESSORS.add(accessor);
            }
            catch (Exception exc) {
                failedAttempts.put(f.getPath(), exc);
            }
        }
        for (RecipeAdapterBuilder builder : adapterBuilders) {
            RecipeAdapterAccessor accessor = new RecipeAdapterAccessor(builder);
            List<MachineRecipe> recipes = accessor.loadRecipesForAdapter();
            if (recipes.isEmpty()) {
                ModularMachinery.log.warn("Adapter with name " + accessor.getAdapterKey().toString() + " didn't provide have any recipes!");
            } else {
                for (MachineRecipe recipe : recipes) {
                    recipe.mergeAdapter(builder);
                }
                loadedRecipes.addAll(recipes);
            }
            RECIPE_ADAPTER_ACCESSORS.add(accessor);
        }
        return loadedRecipes;
    }

    private static MachineRecipe convertPreparedRecipe(PreparedRecipe recipe) {
        MachineRecipe mr = new MachineRecipe(recipe);
        recipe.getComponents().forEach(mr::addRequirement);
        return mr;
    }

    public static Map<String, Exception> captureFailedAttempts() {
        Map<String, Exception> failed = failedAttempts;
        failedAttempts = new HashMap<String, Exception>();
        return failed;
    }

    public static enum FileType {
        ADAPTER,
        RECIPE;


        public boolean accepts(String fileName) {
            boolean bl;
            switch (this) {
                case ADAPTER: {
                    bl = fileName.endsWith(".adapter.json");
                    break;
                }
                default: {
                    bl = fileName.endsWith(".json");
                }
            }
            return bl;
        }
    }
}

