/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.minecraft.CraftTweakerMC;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.RecipeFailureActions;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="mods.modularmachinery.ActiveMachineRecipe")
public class ActiveMachineRecipe {
    private final MachineRecipe recipe;
    private NBTTagCompound data = new NBTTagCompound();
    private int tick = 0;
    private int totalTick;
    private int maxParallelism;
    private int parallelism = 1;

    public ActiveMachineRecipe(MachineRecipe recipe, int maxParallelism) {
        this.recipe = recipe;
        this.totalTick = recipe.getRecipeTotalTickTime();
        this.maxParallelism = maxParallelism;
    }

    public ActiveMachineRecipe(NBTTagCompound serialized) {
        this.recipe = RecipeRegistry.getRecipe(new ResourceLocation(serialized.func_74779_i("recipeName")));
        this.tick = serialized.func_74762_e("tick");
        this.totalTick = serialized.func_74762_e("totalTick");
        if (serialized.func_150297_b("data", 10)) {
            this.data = serialized.func_74775_l("data");
        }
        if (serialized.func_74764_b("maxParallelism")) {
            this.maxParallelism = serialized.func_74762_e("maxParallelism");
        }
        if (serialized.func_74764_b("parallelism")) {
            this.parallelism = serialized.func_74762_e("parallelism");
        }
    }

    public void reset() {
        this.tick = 0;
        this.parallelism = 1;
        this.maxParallelism = 1;
        this.data = new NBTTagCompound();
    }

    public MachineRecipe getRecipe() {
        return this.recipe;
    }

    @Nonnull
    public CraftingStatus tick(TileMultiblockMachineController ctrl, RecipeCraftingContext context) {
        this.totalTick = Math.round(RecipeModifier.applyModifiers(context, RequirementTypesMM.REQUIREMENT_DURATION, null, (float)this.recipe.getRecipeTotalTickTime(), false));
        if (this.isCompleted()) {
            return CraftingStatus.working();
        }
        RecipeCraftingContext.CraftingCheckResult check = context.ioTick(this.tick);
        if (check.isFailure()) {
            DynamicMachine machine = ctrl.getFoundMachine();
            if (machine != null) {
                RecipeFailureActions action = machine.getFailureAction();
                this.doFailureAction(action);
            } else {
                this.doFailureAction(RecipeFailureActions.getDefaultAction());
            }
            return CraftingStatus.failure(check.getFirstErrorMessage(""));
        }
        ++this.tick;
        return CraftingStatus.working();
    }

    public void doFailureAction(RecipeFailureActions action) {
        switch (action) {
            case RESET: {
                this.tick = 0;
                break;
            }
            case DECREASE: {
                if (this.tick <= 0) break;
                --this.tick;
            }
        }
    }

    public boolean isCompleted() {
        return this.tick >= this.totalTick;
    }

    public RecipeCraftingContext.CraftingCheckResult canStartCrafting(RecipeCraftingContext context) {
        this.calculateExtraParallelism(context);
        return context.canStartCrafting();
    }

    public RecipeCraftingContext.CraftingCheckResult canRestartCrafting(RecipeCraftingContext context) {
        this.calculateExtraParallelism(context);
        return context.canRestartCrafting();
    }

    public void calculateExtraParallelism(RecipeCraftingContext context) {
        float totalTick = RecipeModifier.applyModifiers(context, RequirementTypesMM.REQUIREMENT_DURATION, null, (float)this.recipe.getRecipeTotalTickTime(), false);
        if (totalTick < 0.0f) {
            this.totalTick = 1;
        } else if (totalTick < 1.0f) {
            int extraParallelism = (int)(1.0f / totalTick);
            this.maxParallelism *= extraParallelism;
            this.totalTick = 1;
        } else {
            this.totalTick = Math.round(totalTick);
        }
    }

    public void start(RecipeCraftingContext context) {
        context.startCrafting();
        this.totalTick = Math.round(RecipeModifier.applyModifiers(context, RequirementTypesMM.REQUIREMENT_DURATION, null, (float)this.recipe.getRecipeTotalTickTime(), false));
    }

    public NBTTagCompound serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("tick", this.tick);
        tag.func_74768_a("totalTick", this.totalTick);
        tag.func_74778_a("recipeName", this.recipe.getRegistryName().toString());
        tag.func_74768_a("maxParallelism", this.maxParallelism);
        tag.func_74768_a("parallelism", this.parallelism);
        if (!this.data.func_82582_d()) {
            tag.func_74782_a("data", (NBTBase)this.data);
        }
        return tag;
    }

    @ZenGetter(value="maxParallelism")
    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    @ZenSetter(value="maxParallelism")
    public void setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
    }

    @ZenGetter(value="parallelism")
    public int getParallelism() {
        return this.parallelism;
    }

    @ZenSetter(value="parallelism")
    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    @ZenGetter(value="tick")
    public int getTick() {
        return this.tick;
    }

    @ZenSetter(value="tick")
    public void setTick(int tick) {
        if (tick >= 0) {
            this.tick = tick;
        }
    }

    @ZenGetter(value="totalTick")
    public int getTotalTick() {
        return this.totalTick;
    }

    @ZenSetter(value="totalTick")
    public void setTotalTick(int totalTick) {
        this.totalTick = totalTick;
    }

    @ZenGetter(value="registryName")
    public String getRegistryName() {
        return this.recipe.getRegistryName().func_110623_a();
    }

    @ZenGetter(value="data")
    public IData getData() {
        return CraftTweakerMC.getIDataModifyable((NBTBase)this.data);
    }

    @ZenSetter(value="data")
    public void setData(IData data) {
        this.data = CraftTweakerMC.getNBTCompound((IData)data);
    }

    public NBTTagCompound getDataCompound() {
        return this.data;
    }
}

