/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.block;

import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.block.BlockMachineComponent;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.item.ItemBlockController;
import hellfirepvp.modularmachinery.common.item.ItemDynamicColor;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockController
extends BlockMachineComponent
implements ItemDynamicColor {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177706_a((String)"facing", EnumFacing.class, (Enum[])EnumFacing.field_176754_o);
    public static final PropertyBool FORMED = PropertyBool.func_177716_a((String)"formed");
    public static final Map<DynamicMachine, BlockController> MACHINE_CONTROLLERS = new HashMap<DynamicMachine, BlockController>();
    public static final Map<DynamicMachine, BlockController> MOC_MACHINE_CONTROLLERS = new HashMap<DynamicMachine, BlockController>();
    protected DynamicMachine parentMachine = null;

    public BlockController() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(CommonProxy.creativeTabModularMachinery);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)FORMED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockController(DynamicMachine parentMachine) {
        this();
        this.parentMachine = parentMachine;
        this.setRegistryName(new ResourceLocation("modularmachinery", parentMachine.getRegistryName().func_110623_a() + "_controller"));
    }

    public BlockController(String namespace, DynamicMachine parentMachine) {
        this();
        this.parentMachine = parentMachine;
        this.setRegistryName(new ResourceLocation(namespace, parentMachine.getRegistryName().func_110623_a() + "_controller"));
    }

    public static BlockController getControllerWithMachine(DynamicMachine machine) {
        return MACHINE_CONTROLLERS.get(machine);
    }

    public static BlockController getMocControllerWithMachine(DynamicMachine machine) {
        return MOC_MACHINE_CONTROLLERS.get(machine);
    }

    public DynamicMachine getParentMachine() {
        return this.parentMachine;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (this.getRegistryName().func_110624_b().equals("modularcontroller") && !Config.disableMocDeprecatedTip) {
            tooltip.add(I18n.func_135052_a((String)"tile.modularmachinery.machinecontroller.deprecated.tip.0", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"tile.modularmachinery.machinecontroller.deprecated.tip.1", (Object[])new Object[0]));
        }
    }

    public void func_180653_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        Random rand = worldIn.field_73012_v;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileMultiblockMachineController) {
            TileMultiblockMachineController ctrl = (TileMultiblockMachineController)te;
            IOInventory inv = ctrl.getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                BlockController.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
                inv.setStackInSlot(i, ItemStack.field_190927_a);
            }
            UUID ownerUUID = ctrl.getOwner();
            Item dropped = this.func_180660_a(state, rand, this.func_180651_a(state));
            if (dropped instanceof ItemBlockController) {
                ItemStack stackCtrl = new ItemStack(dropped, 1);
                if (ownerUUID != null) {
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("owner", ownerUUID.toString());
                    stackCtrl.func_77982_d(tag);
                }
                BlockController.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stackCtrl);
            } else {
                ModularMachinery.log.warn("Cannot get controller drops at World: " + worldIn + ", Pos: " + MiscUtils.posToString((Vec3i)pos));
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_189540_a(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileMultiblockMachineController) {
            TileMultiblockMachineController ctrl = (TileMultiblockMachineController)tileEntity;
            ctrl.onNeighborChange();
        }
    }

    public boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        return true;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean func_180639_a(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileMachineController) {
            playerIn.openGui((Object)"modularmachinery", CommonProxy.GuiType.CONTROLLER.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176736_b();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        IBlockState iBlockState;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileMultiblockMachineController) {
            TileMultiblockMachineController ctrl = (TileMultiblockMachineController)tileEntity;
            iBlockState = state.func_177226_a((IProperty)FORMED, (Comparable)Boolean.valueOf(ctrl.isStructureFormed()));
        } else {
            iBlockState = state;
        }
        return iBlockState;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, FORMED});
    }

    public boolean func_149740_M(@Nonnull IBlockState state) {
        return true;
    }

    public int func_180641_l(@Nonnull IBlockState blockState, World worldIn, @Nonnull BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileMultiblockMachineController) {
            TileMultiblockMachineController ctrl = (TileMultiblockMachineController)te;
            return ctrl.isWorking() ? 15 : (ctrl.getFoundMachine() != null ? 1 : 0);
        }
        return 0;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a(FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b(FACING)));
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileMachineController(state);
    }

    @Override
    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileMachineController(this.func_176203_a(meta));
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public String func_149732_F() {
        if (this.parentMachine != null) {
            return I18n.func_135052_a((String)"tile.modularmachinery.machinecontroller.name", (Object[])new Object[]{this.parentMachine.getLocalizedName()});
        }
        return I18n.func_135052_a((String)"tile.modularmachinery.blockcontroller.name", (Object[])new Object[0]);
    }

    public boolean func_149730_j(IBlockState state) {
        return this.parentMachine == null || this.parentMachine.getControllerBoundingBox().equals((Object)field_185505_j);
    }

    public boolean func_149686_d(IBlockState state) {
        return this.func_149730_j(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return this.func_149730_j(state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.parentMachine != null ? this.parentMachine.getControllerBoundingBox() : field_185505_j;
    }

    @Override
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        if (this.parentMachine == null) {
            return Config.machineColor;
        }
        return this.parentMachine.getMachineColor();
    }

    @Override
    public int getColorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        if (this.parentMachine == null) {
            return Config.machineColor;
        }
        return this.parentMachine.getMachineColor();
    }
}

