/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client.util;

import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;

public class EnergyDisplayUtil {
    public static boolean displayFETooltip = true;
    public static boolean displayIC2EUTooltip = true;
    public static boolean displayGTEUTooltip = true;
    public static EnergyType type = EnergyType.FE;

    public static void loadFromConfig(Configuration cfg) {
        displayFETooltip = cfg.getBoolean("FE_RF_Tooltip", "display.energy", displayFETooltip, "Set to true, if the standard 'energy' FE (or RF) should be displayed in the tooltip of the energy hatch along with its transmission rates.");
        displayIC2EUTooltip = cfg.getBoolean("IC2_EU_Tooltip", "display.energy", displayIC2EUTooltip, "Set to true, if IC2's energy EU should be displayed in the tooltip of the energy hatch. Will only have effect if IC2 is installed.");
        displayGTEUTooltip = cfg.getBoolean("GT_EU_Tooltip", "display.energy", displayGTEUTooltip, "Set to true, if GT's energy EU should be displayed in the tooltip of the energy hatch. Will only have effect if GregTech (community edition) is installed.");
        type = EnergyType.getType(cfg.getString("Display_Energy_Type", "display.energy", type.name(), "Available options: 'FE', 'RF', 'IC2_EU', 'GT_EU' - Default: FE - Set this to one of those 4 types to have GUI, recipe preview and energy be displayed in that type of energy in ALL ModularMachinery things."));
    }

    public static enum EnergyType {
        FE(1.0),
        RF(1.0),
        IC2_EU(0.25),
        GT_EU(0.25);

        private final double multiplier;
        private final String unlocalizedFormat;

        private EnergyType(double multiplier) {
            this.multiplier = multiplier;
            this.unlocalizedFormat = "tooltip.energy.type." + this.name().toLowerCase();
        }

        public static EnergyType getType(String configValue) {
            EnergyType type = FE;
            try {
                type = EnergyType.valueOf(configValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return type;
        }

        public long formatEnergyForDisplay(long energy) {
            return MathHelper.func_76124_d((double)((double)energy * this.multiplier));
        }

        public String getUnlocalizedFormat() {
            return this.unlocalizedFormat;
        }
    }
}

