/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client.gui.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiScrollbar {
    public static final ResourceLocation TEXTURES_TABS = new ResourceLocation("minecraft", "textures/gui/container/creative_inventory/tabs.png");
    private int displayX = 0;
    private int displayY = 0;
    private int width = 12;
    private int height = 16;
    private int pageSize = 1;
    private int maxScroll = 0;
    private int minScroll = 0;
    private int currentScroll = 0;

    public void draw(GuiScreen g, Minecraft mc) {
        mc.func_110434_K().func_110577_a(TEXTURES_TABS);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getRange() == 0) {
            g.func_73729_b(this.displayX, this.displayY, 232 + this.width, 0, this.width, 15);
        } else {
            int offset = (this.currentScroll - this.minScroll) * (this.height - 15) / this.getRange();
            g.func_73729_b(this.displayX, offset + this.displayY, 232, 0, this.width, 15);
        }
    }

    private int getRange() {
        return this.maxScroll - this.minScroll;
    }

    public int getLeft() {
        return this.displayX;
    }

    public GuiScrollbar setLeft(int v) {
        this.displayX = v;
        return this;
    }

    public int getTop() {
        return this.displayY;
    }

    public GuiScrollbar setTop(int v) {
        this.displayY = v;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public GuiScrollbar setWidth(int v) {
        this.width = v;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public GuiScrollbar setHeight(int v) {
        this.height = v;
        return this;
    }

    public void setRange(int min, int max, int pageSize) {
        this.minScroll = min;
        this.maxScroll = max;
        this.pageSize = pageSize;
        if (this.minScroll > this.maxScroll) {
            this.maxScroll = this.minScroll;
        }
        this.applyRange();
    }

    private void applyRange() {
        this.currentScroll = Math.max(Math.min(this.currentScroll, this.maxScroll), this.minScroll);
    }

    public int getCurrentScroll() {
        return this.currentScroll;
    }

    public void click(int x, int y) {
        if (this.getRange() == 0) {
            return;
        }
        if (this.isMouseOver(x, y)) {
            this.currentScroll = y - this.displayY;
            this.currentScroll = this.minScroll + this.currentScroll * 2 * this.getRange() / this.height;
            this.currentScroll = this.currentScroll + 1 >> 1;
            this.applyRange();
        }
    }

    public boolean isMouseOver(int x, int y) {
        if (x > this.displayX && x <= this.displayX + this.width) {
            return y > this.displayY && y <= this.displayY + this.height;
        }
        return false;
    }

    public void wheel(int delta) {
        delta = Math.max(Math.min(-delta, 1), -1);
        this.currentScroll += delta * this.pageSize;
        this.applyRange();
    }
}

