/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client.gui;

import github.kasuminova.mmce.common.upgrade.MachineUpgrade;
import github.kasuminova.mmce.common.upgrade.UpgradeType;
import hellfirepvp.modularmachinery.client.gui.GuiContainerBase;
import hellfirepvp.modularmachinery.client.gui.widget.GuiScrollbar;
import hellfirepvp.modularmachinery.common.container.ContainerUpgradeBus;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.tiles.TileUpgradeBus;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.input.Mouse;

public class GuiContainerUpgradeBus
extends GuiContainerBase<ContainerUpgradeBus> {
    public static final ResourceLocation TEXTURES_UPGRADE_BUS = new ResourceLocation("modularmachinery", "textures/gui/guiupgradebus.png");
    private static final int SCROLLBAR_TOP = 17;
    private static final int SCROLLBAR_LEFT = 156;
    private static final int SCROLLBAR_HEIGHT = 106;
    private static final int TEXT_DRAW_OFFSET_X = 92;
    private static final int TEXT_DRAW_OFFSET_Y = 23;
    public static final double FONT_SCALE = 0.72;
    public static final int SLOT_START_X = 8;
    public static final int SLOT_START_Y = 17;
    public static final int MAX_DESC_LINES = 15;
    private final GuiScrollbar scrollbar = new GuiScrollbar();
    private final TileUpgradeBus upgradeBus;

    public GuiContainerUpgradeBus(TileUpgradeBus upgradeBus, EntityPlayer player) {
        super(new ContainerUpgradeBus(upgradeBus, player));
        this.upgradeBus = upgradeBus;
        this.field_147000_g = 213;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        TileUpgradeBus.UpgradeBusProvider component = this.upgradeBus.provideComponent();
        FontRenderer fr = this.field_146289_q;
        fr.func_175063_a(I18n.func_135052_a((String)"gui.upgradebus.title", (Object[])new Object[0]), 7.0f, 5.0f, 0xFFFFFF);
        GlStateManager.func_179139_a((double)0.72, (double)0.72, (double)0.72);
        ArrayList<String> description = new ArrayList<String>();
        Map<BlockPos, DynamicMachine> boundedMachine = component.getBoundedMachine();
        Map<UpgradeType, List<MachineUpgrade>> upgrades = component.getUpgrades(null);
        GuiContainerUpgradeBus.collectBoundedMachineDescriptions(description, boundedMachine, upgrades);
        GuiContainerUpgradeBus.collectUpgradeDescriptions(component, description, upgrades);
        List wrappedDesc = description.stream().flatMap(s -> fr.func_78271_c(s, 123).stream()).collect(Collectors.toList());
        this.updateScrollbar(x, y, Math.max(0, wrappedDesc.size() - 15));
        int offsetY = 23;
        for (int i = this.scrollbar.getCurrentScroll(); i < Math.min(wrappedDesc.size(), 15 + this.scrollbar.getCurrentScroll()); ++i) {
            fr.func_175063_a((String)wrappedDesc.get(i), 92.0f, (float)offsetY, 0xFFFFFF);
            offsetY += 10;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static void collectBoundedMachineDescriptions(List<String> desc, Map<BlockPos, DynamicMachine> boundedMachine, Map<UpgradeType, List<MachineUpgrade>> founded) {
        if (boundedMachine.isEmpty()) {
            desc.add(I18n.func_135052_a((String)"gui.upgradebus.bounded.empty", (Object[])new Object[0]));
            return;
        }
        desc.add(I18n.func_135052_a((String)"gui.upgradebus.bounded", (Object[])new Object[]{boundedMachine.size()}));
        boundedMachine.forEach((pos, machine) -> {
            desc.add(String.format("%s (%s)", machine.getLocalizedName(), MiscUtils.posToString((Vec3i)pos)));
            founded.forEach((type, upgrades) -> {
                for (MachineUpgrade upgrade : upgrades) {
                    if (type.isCompatible((DynamicMachine)machine)) {
                        return;
                    }
                    desc.add("   " + I18n.func_135052_a((String)"gui.upgradebus.incompatible", (Object[])new Object[]{upgrade.getType().getLocalizedName()}));
                }
            });
        });
        desc.add("");
    }

    private static void collectUpgradeDescriptions(TileUpgradeBus.UpgradeBusProvider component, List<String> desc, Map<UpgradeType, List<MachineUpgrade>> founded) {
        founded.values().forEach(upgrades -> upgrades.forEach(upgrade -> {
            upgrade.readNBT(component.getUpgradeCustomData((MachineUpgrade)upgrade));
            int stackSize = upgrade.getStackSize();
            desc.add(stackSize + "x " + upgrade.getType().getLocalizedName());
            List<String> busDesc = upgrade.getBusGUIDescriptions();
            if (busDesc.isEmpty()) {
                return;
            }
            desc.addAll(busDesc);
            desc.add("");
        }));
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            this.scrollbar.wheel(i);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.scrollbar.click(mouseX, mouseY);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.scrollbar.click(mouseX, mouseY);
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public void updateScrollbar(int displayX, int displayY, int range) {
        this.scrollbar.setLeft(156 + displayX).setTop(17 + displayY).setHeight(106).setRange(0, range, 1);
    }

    @Override
    protected void setWidthHeight() {
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES_UPGRADE_BUS);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int x = 8;
        int y = 17;
        for (int index = 0; index < this.upgradeBus.getInventory().getSlots(); ++index) {
            this.func_73729_b(i + x - 1, j + y - 1, 7, 130, 18, 18);
            x += 18;
            if ((index + 1) % 3 != 0) continue;
            x = 8;
            y += 18;
        }
        this.scrollbar.draw((GuiScreen)this, this.field_146297_k);
    }
}

