/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client;

import github.kasuminova.mmce.client.gui.GuiMEFluidInputBus;
import github.kasuminova.mmce.client.gui.GuiMEFluidOutputBus;
import github.kasuminova.mmce.client.gui.GuiMEGasInputBus;
import github.kasuminova.mmce.client.gui.GuiMEGasOutputBus;
import github.kasuminova.mmce.client.gui.GuiMEItemInputBus;
import github.kasuminova.mmce.client.gui.GuiMEItemOutputBus;
import github.kasuminova.mmce.client.gui.GuiMEPatternProvider;
import github.kasuminova.mmce.client.renderer.MachineControllerRenderer;
import github.kasuminova.mmce.client.resource.GeoModelExternalLoader;
import github.kasuminova.mmce.common.handler.ClientHandler;
import github.kasuminova.mmce.common.tile.MEFluidInputBus;
import github.kasuminova.mmce.common.tile.MEFluidOutputBus;
import github.kasuminova.mmce.common.tile.MEGasInputBus;
import github.kasuminova.mmce.common.tile.MEGasOutputBus;
import github.kasuminova.mmce.common.tile.MEItemInputBus;
import github.kasuminova.mmce.common.tile.MEItemOutputBus;
import github.kasuminova.mmce.common.tile.MEPatternProvider;
import hellfirepvp.modularmachinery.client.ClientScheduler;
import hellfirepvp.modularmachinery.client.gui.GuiContainerEnergyHatch;
import hellfirepvp.modularmachinery.client.gui.GuiContainerFluidHatch;
import hellfirepvp.modularmachinery.client.gui.GuiContainerItemBus;
import hellfirepvp.modularmachinery.client.gui.GuiContainerParallelController;
import hellfirepvp.modularmachinery.client.gui.GuiContainerSmartInterface;
import hellfirepvp.modularmachinery.client.gui.GuiContainerUpgradeBus;
import hellfirepvp.modularmachinery.client.gui.GuiFactoryController;
import hellfirepvp.modularmachinery.client.gui.GuiMachineController;
import hellfirepvp.modularmachinery.client.gui.GuiScreenBlueprint;
import hellfirepvp.modularmachinery.client.util.BlockArrayPreviewRenderHelper;
import hellfirepvp.modularmachinery.client.util.DebugOverlayHelper;
import hellfirepvp.modularmachinery.client.util.SelectionBoxRenderHelper;
import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.block.BlockDynamicColor;
import hellfirepvp.modularmachinery.common.block.BlockFactoryController;
import hellfirepvp.modularmachinery.common.block.BlockVariants;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.command.CommandCTReloadClient;
import hellfirepvp.modularmachinery.common.item.ItemBlueprint;
import hellfirepvp.modularmachinery.common.item.ItemDynamicColor;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.registry.RegistryBlocks;
import hellfirepvp.modularmachinery.common.registry.RegistryItems;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import hellfirepvp.modularmachinery.common.tiles.TileParallelController;
import hellfirepvp.modularmachinery.common.tiles.TileSmartInterface;
import hellfirepvp.modularmachinery.common.tiles.TileUpgradeBus;
import hellfirepvp.modularmachinery.common.tiles.base.TileEnergyHatch;
import hellfirepvp.modularmachinery.common.tiles.base.TileFluidTank;
import hellfirepvp.modularmachinery.common.tiles.base.TileItemBus;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import kport.modularmagic.client.gui.GuiContainerLifeEssence;
import kport.modularmagic.client.renderer.TileAspectProviderRenderer;
import kport.modularmagic.client.renderer.TileLifeEssentiaHatchRenderer;
import kport.modularmagic.common.item.ModularMagicItems;
import kport.modularmagic.common.tile.TileAspectProvider;
import kport.modularmagic.common.tile.TileLifeEssenceProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="modularmachinery")
public class ClientProxy
extends CommonProxy {
    public static final ClientScheduler clientScheduler = new ClientScheduler();
    public static final BlockArrayPreviewRenderHelper renderHelper = new BlockArrayPreviewRenderHelper();
    private final List<Block> blockModelsToRegister = new LinkedList<Block>();
    private final List<Item> itemModelsToRegister = new LinkedList<Item>();
    private final List<Item> itemModelsCustomNameToRegister = new LinkedList<Item>();

    private static void registerPendingIBlockColorBlocks() {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        for (BlockDynamicColor dynamicColor : RegistryBlocks.pendingIBlockColorBlocks) {
            colors.func_186722_a(dynamicColor::getColorMultiplier, new Block[]{(Block)dynamicColor});
        }
        BlockController.MACHINE_CONTROLLERS.values().forEach(block -> colors.func_186722_a(block::getColorMultiplier, new Block[]{block}));
        BlockController.MOC_MACHINE_CONTROLLERS.values().forEach(block -> colors.func_186722_a(block::getColorMultiplier, new Block[]{block}));
        BlockFactoryController.FACTORY_CONTROLLERS.values().forEach(block -> colors.func_186722_a(block::getColorMultiplier, new Block[]{block}));
    }

    private static void registerPendingIItemColorItems() {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        for (ItemDynamicColor dynamicColor : RegistryItems.pendingDynamicColorItems) {
            colors.func_186730_a(dynamicColor::getColorFromItemstack, new Item[]{(Item)dynamicColor});
        }
        BlockController.MACHINE_CONTROLLERS.values().forEach(block -> colors.func_186731_a(block::getColorFromItemstack, new Block[]{block}));
        BlockController.MOC_MACHINE_CONTROLLERS.values().forEach(block -> colors.func_186731_a(block::getColorFromItemstack, new Block[]{block}));
        BlockFactoryController.FACTORY_CONTROLLERS.values().forEach(block -> colors.func_186731_a(block::getColorFromItemstack, new Block[]{block}));
    }

    private static void registryItemModel(Item item, String name) {
        NonNullList list = NonNullList.func_191196_a();
        item.func_150895_a(item.func_77640_w(), list);
        if (!list.isEmpty()) {
            for (ItemStack i : list) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i.func_77952_i(), (ModelResourceLocation)new ModelResourceLocation("modularmachinery:" + name, "inventory"));
            }
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("modularmachinery:" + name, "inventory"));
        }
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)clientScheduler);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DebugOverlayHelper());
        MinecraftForge.EVENT_BUS.register((Object)new SelectionBoxRenderHelper());
        MinecraftForge.EVENT_BUS.register((Object)new ClientHandler());
        if (Mods.TC6.isPresent()) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileAspectProvider.Input.class, (TileEntitySpecialRenderer)new TileAspectProviderRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileAspectProvider.Output.class, (TileEntitySpecialRenderer)new TileAspectProviderRenderer());
        }
        if (Mods.BM2.isPresent()) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileLifeEssenceProvider.Input.class, (TileEntitySpecialRenderer)new TileLifeEssentiaHatchRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileLifeEssenceProvider.Output.class, (TileEntitySpecialRenderer)new TileLifeEssentiaHatchRenderer());
        }
        if (Mods.GECKOLIB.isPresent()) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileMachineController.class, (TileEntitySpecialRenderer)MachineControllerRenderer.INSTANCE);
            ClientRegistry.bindTileEntitySpecialRenderer(TileFactoryController.class, (TileEntitySpecialRenderer)MachineControllerRenderer.INSTANCE);
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)GeoModelExternalLoader.INSTANCE);
        }
        super.preInit();
    }

    @SubscribeEvent
    public void onModelRegister(ModelRegistryEvent event) {
        this.registerModels();
    }

    private void registerModels() {
        String name;
        for (Block block : this.blockModelsToRegister) {
            Item i = Item.func_150898_a((Block)block);
            if (block instanceof BlockVariants) {
                for (IBlockState state : ((BlockVariants)block).getValidStates()) {
                    String unlocName = block.getClass().getSimpleName().toLowerCase();
                    String name2 = unlocName + "_" + ((BlockVariants)block).getBlockStateName(state);
                    ModelBakery.registerItemVariants((Item)i, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("modularmachinery", name2)});
                    ModelLoader.setCustomModelResourceLocation((Item)i, (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation("modularmachinery:" + name2, "inventory"));
                }
                continue;
            }
            ModelBakery.registerItemVariants((Item)i, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("modularmachinery", block.getClass().getSimpleName().toLowerCase())});
            ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)new ModelResourceLocation("modularmachinery:" + block.getClass().getSimpleName().toLowerCase(), "inventory"));
        }
        for (Item item : this.itemModelsToRegister) {
            name = item.getClass().getSimpleName().toLowerCase();
            if (item instanceof ItemBlock) {
                name = ((ItemBlock)item).func_179223_d().getClass().getSimpleName().toLowerCase();
            }
            ClientProxy.registryItemModel(item, name);
        }
        for (Item item : this.itemModelsCustomNameToRegister) {
            name = item.getRegistryName().func_110623_a();
            ClientProxy.registryItemModel(item, name);
        }
    }

    @Override
    public void init() {
        super.init();
        ClientProxy.registerPendingIBlockColorBlocks();
        ClientProxy.registerPendingIItemColorItems();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        for (ItemDynamicColor item : ModularMagicItems.COLOR_ITEMS) {
            itemColors.func_186730_a(item::getColorFromItemstack, new Item[]{(Item)item});
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        if (Mods.ZEN_UTILS.isPresent()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCTReloadClient());
        }
        if (Mods.GECKOLIB.isPresent()) {
            GeoModelExternalLoader.INSTANCE.onReload();
        }
    }

    @Override
    public void registerBlockModel(Block block) {
        this.blockModelsToRegister.add(block);
    }

    @Override
    public void registerItemModel(Item item) {
        this.itemModelsToRegister.add(item);
    }

    @Override
    public void registerItemModelWithCustomName(Item item) {
        this.itemModelsCustomNameToRegister.add(item);
    }

    @Override
    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        CommonProxy.GuiType type = CommonProxy.GuiType.values()[MathHelper.func_76125_a((int)ID, (int)0, (int)(CommonProxy.GuiType.values().length - 1))];
        Class<? extends TileEntity> required = type.requiredTileEntity;
        TileEntity present = null;
        if (required != null) {
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (te != null && required.isAssignableFrom(te.getClass())) {
                present = te;
            } else {
                return null;
            }
        }
        switch (type) {
            case CONTROLLER: {
                return new GuiMachineController((TileMachineController)present, player);
            }
            case FACTORY: {
                return new GuiFactoryController((TileFactoryController)present, player);
            }
            case BUS_INVENTORY: {
                return new GuiContainerItemBus((TileItemBus)present, player);
            }
            case TANK_INVENTORY: {
                return new GuiContainerFluidHatch((TileFluidTank)present, player);
            }
            case ENERGY_INVENTORY: {
                return new GuiContainerEnergyHatch((TileEnergyHatch)present, player);
            }
            case SMART_INTERFACE: {
                return new GuiContainerSmartInterface((TileSmartInterface)present, player);
            }
            case PARALLEL_CONTROLLER: {
                return new GuiContainerParallelController((TileParallelController)present, player);
            }
            case UPGRADE_BUS: {
                return new GuiContainerUpgradeBus((TileUpgradeBus)present, player);
            }
            case BLUEPRINT_PREVIEW: {
                ItemStack stack = x == 0 ? Minecraft.func_71410_x().field_71439_g.func_184614_ca() : Minecraft.func_71410_x().field_71439_g.func_184592_cb();
                DynamicMachine machine = ItemBlueprint.getAssociatedMachine(stack);
                if (machine == null) break;
                return new GuiScreenBlueprint(machine);
            }
            case ME_ITEM_OUTPUT_BUS: {
                if (!Mods.AE2.isPresent()) {
                    return null;
                }
                return new GuiMEItemOutputBus((MEItemOutputBus)present, player);
            }
            case ME_ITEM_INPUT_BUS: {
                if (!Mods.AE2.isPresent()) {
                    return null;
                }
                return new GuiMEItemInputBus((MEItemInputBus)present, player);
            }
            case ME_FLUID_OUTPUT_BUS: {
                if (!Mods.AE2.isPresent()) {
                    return null;
                }
                return new GuiMEFluidOutputBus((MEFluidOutputBus)present, player);
            }
            case ME_FLUID_INPUT_BUS: {
                if (!Mods.AE2.isPresent()) {
                    return null;
                }
                return new GuiMEFluidInputBus((MEFluidInputBus)present, player);
            }
            case ME_GAS_OUTPUT_BUS: {
                if (!Mods.AE2.isPresent() || !Mods.MEKENG.isPresent()) {
                    return null;
                }
                return new GuiMEGasOutputBus((MEGasOutputBus)present, player);
            }
            case ME_GAS_INPUT_BUS: {
                if (!Mods.AE2.isPresent() || !Mods.MEKENG.isPresent()) {
                    return null;
                }
                return new GuiMEGasInputBus((MEGasInputBus)present, player);
            }
            case ME_PATTERN_PROVIDER: {
                if (!Mods.AE2.isPresent()) {
                    return null;
                }
                return new GuiMEPatternProvider((MEPatternProvider)present, player);
            }
            case GUI_ESSENCE_PROVIDER: {
                if (!Mods.BM2.isPresent()) {
                    return null;
                }
                return new GuiContainerLifeEssence((TileLifeEssenceProvider)present, player);
            }
        }
        return null;
    }
}

