/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.world;

import github.kasuminova.mmce.client.world.BlockModelHider;
import github.kasuminova.mmce.common.world.MachineComponentManager;
import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class MMWorldEventListener
implements IWorldEventListener {
    public static final MMWorldEventListener INSTANCE = new MMWorldEventListener();
    private final Map<World, Long2ObjectMap<StructureBoundingBox>> worldChangedChunks = new HashMap<World, Long2ObjectMap<StructureBoundingBox>>();

    private MMWorldEventListener() {
    }

    @SubscribeEvent
    public void onWorldLoaded(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        world.func_72954_a((IWorldEventListener)this);
        MachineComponentManager.INSTANCE.addWorld(world);
    }

    @SubscribeEvent
    public void onWorldUnloaded(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            BlockModelHider.onWorldUnload(world);
            return;
        }
        this.worldChangedChunks.remove(world);
        MachineComponentManager.INSTANCE.removeWorld(world);
    }

    @SubscribeEvent
    public void onServerTickStart(TickEvent.ServerTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        this.worldChangedChunks.values().forEach(Function::clear);
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        ChunkPos pos = event.getChunk().func_76632_l();
        int xStart = pos.func_180334_c();
        int xEnd = pos.func_180332_e();
        int zStart = pos.func_180333_d();
        int zEnd = pos.func_180330_f();
        StructureBoundingBox structureArea = new StructureBoundingBox(xStart, zStart, xEnd, zEnd);
        Long2ObjectMap<StructureBoundingBox> changedChunks = this.worldChangedChunks.get(world);
        if (changedChunks == null) {
            return;
        }
        changedChunks.put(ChunkPos.func_77272_a((int)pos.field_77276_a, (int)pos.field_77275_b), (Object)structureArea);
    }

    public boolean isAreaChanged(@Nonnull World worldIn, @Nonnull BlockPos min, @Nonnull BlockPos max) {
        int minChunkX = min.func_177958_n() >> 4;
        int maxChunkX = max.func_177958_n() >> 4;
        int minChunkZ = min.func_177952_p() >> 4;
        int maxChunkZ = max.func_177952_p() >> 4;
        StructureBoundingBox structureArea = new StructureBoundingBox((Vec3i)min, (Vec3i)max);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                StructureBoundingBox changedArea;
                Long2ObjectMap<StructureBoundingBox> changedChunks = this.worldChangedChunks.get(worldIn);
                if (changedChunks == null || (changedArea = (StructureBoundingBox)changedChunks.get(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ))) == null || !changedArea.func_78884_a(structureArea)) continue;
                return true;
            }
        }
        return false;
    }

    public void func_184376_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState, int flags) {
        if ((flags & 1) == 0 || oldState == newState) {
            return;
        }
        Long2ObjectMap changedChunks = this.worldChangedChunks.computeIfAbsent(worldIn, v -> new Long2ObjectOpenHashMap());
        ChunkPos chunkPos = new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        long longChunkPos = ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b);
        StructureBoundingBox changedArea = (StructureBoundingBox)changedChunks.get(longChunkPos);
        if (changedArea == null) {
            changedChunks.put(longChunkPos, (Object)new StructureBoundingBox((Vec3i)pos, (Vec3i)pos));
        } else {
            changedArea.func_78888_b(new StructureBoundingBox((Vec3i)pos, (Vec3i)pos));
        }
    }

    public void func_174959_b(@Nonnull BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(@Nullable EntityPlayer player, @Nonnull SoundEvent soundIn, @Nonnull SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(@Nonnull SoundEvent soundIn, @Nonnull BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean minimiseParticleLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(@Nonnull Entity entityIn) {
    }

    public void func_72709_b(@Nonnull Entity entityIn) {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(@Nonnull EntityPlayer player, int type, @Nonnull BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, @Nonnull BlockPos pos, int progress) {
    }
}

