/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.util.concurrent;

import github.kasuminova.mmce.common.util.concurrent.ActionExecutor;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class ExecuteGroup {
    private static final AtomicLong GROUP_COUNTER = new AtomicLong(0L);
    private final long groupId;
    private final Queue<ActionExecutor> executors = new ConcurrentLinkedQueue<ActionExecutor>();
    private volatile boolean submitted = false;

    public ExecuteGroup(long groupId) {
        this.groupId = groupId;
    }

    public static long newGroupId() {
        return GROUP_COUNTER.getAndIncrement();
    }

    public boolean isEmpty() {
        return this.executors.isEmpty();
    }

    public ActionExecutor offer(ActionExecutor executor) {
        this.executors.add(executor);
        return executor;
    }

    public ActionExecutor poll() {
        return this.executors.poll();
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public int hashCode() {
        return Long.hashCode(this.groupId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ExecuteGroup)) return false;
        ExecuteGroup executeGroup = (ExecuteGroup)obj;
        if (this.groupId != executeGroup.groupId) return false;
        return true;
    }
}

