/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.util.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class CustomThreadFactory
implements ThreadFactory {
    private final String threadName;
    private final ThreadGroup group;
    private final AtomicInteger threadCount = new AtomicInteger(1);

    public CustomThreadFactory(String threadName, ThreadGroup group) {
        this.threadName = threadName;
        this.group = group;
    }

    public CustomThreadFactory(String threadName) {
        this(threadName, Thread.currentThread().getThreadGroup());
    }

    @Override
    public Thread newThread(@Nonnull Runnable r) {
        return new Thread(this.group, r, String.format(this.threadName, this.threadCount.getAndIncrement()));
    }
}

