/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.util;

import github.kasuminova.mmce.common.util.concurrent.ActionExecutor;
import java.util.ArrayDeque;
import java.util.Deque;

public class TimeRecorder {
    private final Deque<Integer> usedTimeList = new ArrayDeque<Integer>(102);
    private final Deque<Integer> searchUsedTimeList = new ArrayDeque<Integer>(22);
    private int usedTimeCache = 0;
    private int searchUsedTimeCache = 0;

    public void updateUsedTime(ActionExecutor executor) {
        this.addUsedTime(executor == null ? 0 : executor.usedTime);
    }

    public void incrementUsedTime(int add) {
        this.usedTimeCache += add;
        Integer first = this.usedTimeList.getFirst();
        if (first != null) {
            this.usedTimeList.removeFirst();
            this.usedTimeList.addFirst(first + add);
        } else {
            this.usedTimeList.addFirst(add);
        }
    }

    public void addUsedTime(int time) {
        this.usedTimeCache += time;
        this.usedTimeList.addFirst(time);
        if (this.usedTimeList.size() > 100) {
            this.usedTimeCache -= this.usedTimeList.pollLast().intValue();
        }
    }

    public void addRecipeResearchUsedTime(int time) {
        this.searchUsedTimeCache += time;
        this.searchUsedTimeList.addFirst(time);
        if (this.searchUsedTimeList.size() > 20) {
            this.searchUsedTimeCache -= this.searchUsedTimeList.pollLast().intValue();
        }
    }

    public void incrementRecipeResearchUsedTime(int add) {
        this.searchUsedTimeCache += add;
        Integer first = this.searchUsedTimeList.getFirst();
        if (first != null) {
            this.searchUsedTimeList.removeFirst();
            this.searchUsedTimeList.addFirst(first + add);
        } else {
            this.searchUsedTimeList.addFirst(add);
        }
    }

    public int usedTimeAvg() {
        if (this.usedTimeList.isEmpty()) {
            return 0;
        }
        return this.usedTimeCache / this.usedTimeList.size();
    }

    public int recipeSearchUsedTimeAvg() {
        if (this.searchUsedTimeList.isEmpty()) {
            return 0;
        }
        return this.searchUsedTimeCache / this.searchUsedTimeList.size();
    }
}

