/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.util;

import github.kasuminova.mmce.client.util.ItemStackUtils;
import github.kasuminova.mmce.common.util.IExtendedGasHandler;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandlerModifiable;

@Optional.Interface(iface="github.kasuminova.mmce.common.util.IExtendedGasHandler", modid="mekanism")
public class InfItemFluidHandler
implements IItemHandlerModifiable,
IFluidHandler,
IExtendedGasHandler {
    protected final List<ItemStack> itemStackList = new ObjectArrayList();
    protected final List<FluidStack> fluidStackList = new ObjectArrayList();
    protected final List<?> gasStackList = new ObjectArrayList();
    protected volatile IItemHandlerModifiable subItemHandler = null;
    protected volatile IFluidHandler subFluidHandler = null;
    protected volatile IntConsumer onItemChanged = null;
    protected volatile IntConsumer onFluidChanged = null;
    protected volatile IntConsumer onGasChanged = null;

    public InfItemFluidHandler() {
    }

    public InfItemFluidHandler(IItemHandlerModifiable subItemHandler) {
        this.subItemHandler = subItemHandler;
    }

    public InfItemFluidHandler(IFluidHandler subFluidHandler) {
        this.subFluidHandler = subFluidHandler;
    }

    public InfItemFluidHandler(IItemHandlerModifiable subItemHandler, IFluidHandler subFluidHandler) {
        this.subItemHandler = subItemHandler;
        this.subFluidHandler = subFluidHandler;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.subFluidHandler != null) {
            return (IFluidTankProperties[])Stream.concat(this.fluidStackList.stream().map(fluidStack -> new FluidTankProperties(fluidStack, Integer.MAX_VALUE)), Arrays.stream(this.subFluidHandler.getTankProperties())).toArray(IFluidTankProperties[]::new);
        }
        return (IFluidTankProperties[])this.fluidStackList.stream().map(fluidStack -> new FluidTankProperties(fluidStack, Integer.MAX_VALUE)).toArray(IFluidTankProperties[]::new);
    }

    public synchronized int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            return resource.amount;
        }
        int toFill = resource.amount;
        for (int i = 0; i < this.fluidStackList.size(); ++i) {
            FluidStack stackInSlot = this.fluidStackList.get(i);
            if (stackInSlot == null || !stackInSlot.isFluidEqual(resource)) continue;
            int maxCanFill = Math.min(toFill, Integer.MAX_VALUE - stackInSlot.amount);
            stackInSlot.amount += maxCanFill;
            if (this.onFluidChanged != null) {
                this.onFluidChanged.accept(i);
            }
            if ((toFill -= maxCanFill) <= 0) break;
        }
        if (toFill > 0) {
            this.fluidStackList.add(new FluidStack(resource, toFill));
            if (this.onFluidChanged != null) {
                this.onFluidChanged.accept(this.fluidStackList.size() - 1);
            }
        }
        return resource.amount;
    }

    @Nullable
    public synchronized FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drained;
        if (resource == null) {
            return null;
        }
        if (this.subFluidHandler != null && (drained = this.subFluidHandler.drain(resource, doDrain)) != null) {
            return drained;
        }
        for (int i = 0; i < this.fluidStackList.size(); ++i) {
            FluidStack stackInSlot = this.fluidStackList.get(i);
            if (stackInSlot == null || !stackInSlot.isFluidEqual(resource)) continue;
            int maxCanDrain = Math.min(stackInSlot.amount, resource.amount);
            if (doDrain) {
                stackInSlot.amount -= maxCanDrain;
                if (stackInSlot.amount <= 0) {
                    this.fluidStackList.set(i, null);
                    if (this.onFluidChanged != null) {
                        this.onFluidChanged.accept(i);
                    }
                }
            }
            return new FluidStack(resource, maxCanDrain);
        }
        return null;
    }

    @Nullable
    public synchronized FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained;
        if (this.subFluidHandler != null && (drained = this.subFluidHandler.drain(maxDrain, doDrain)) != null) {
            return drained;
        }
        for (int i = 0; i < this.fluidStackList.size(); ++i) {
            FluidStack stackInSlot = this.fluidStackList.get(i);
            if (stackInSlot == null) continue;
            int maxCanDrain = Math.min(stackInSlot.amount, maxDrain);
            if (doDrain) {
                stackInSlot.amount -= maxCanDrain;
                if (stackInSlot.amount <= 0) {
                    this.fluidStackList.set(i, null);
                    if (this.onFluidChanged != null) {
                        this.onFluidChanged.accept(i);
                    }
                }
            }
            return new FluidStack(stackInSlot, maxCanDrain);
        }
        return null;
    }

    public synchronized void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        int trueSlot = slot;
        if (this.subItemHandler != null) {
            if (slot < this.subItemHandler.getSlots()) {
                this.subItemHandler.setStackInSlot(slot, stack);
                return;
            }
            trueSlot -= this.subItemHandler.getSlots();
        }
        if (trueSlot >= this.itemStackList.size()) {
            this.itemStackList.add(stack);
        } else {
            this.itemStackList.set(trueSlot, stack);
        }
        if (this.onItemChanged != null) {
            this.onItemChanged.accept(trueSlot);
        }
    }

    public int getSlots() {
        return this.itemStackList.size() + (this.subItemHandler != null ? this.subItemHandler.getSlots() : 0);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int trueSlot = slot;
        if (this.subItemHandler != null) {
            if (slot < this.subItemHandler.getSlots()) {
                return this.subItemHandler.getStackInSlot(slot);
            }
            trueSlot -= this.subItemHandler.getSlots();
        }
        if (trueSlot >= this.itemStackList.size()) {
            return ItemStack.field_190927_a;
        }
        return this.itemStackList.get(trueSlot);
    }

    @Nonnull
    public synchronized ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot >= this.itemStackList.size()) {
            return stack;
        }
        ItemStack stackInSlot = this.itemStackList.get(slot);
        if (stackInSlot.func_190926_b()) {
            if (!simulate) {
                this.itemStackList.set(slot, stack.func_77946_l());
                if (this.onItemChanged != null) {
                    this.onItemChanged.accept(slot);
                }
            }
            return ItemStack.field_190927_a;
        }
        if (stackInSlot.func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)stackInSlot, (ItemStack)stack)) {
            int maxToInsert = stack.func_190916_E();
            int toInsert = Math.min(maxToInsert, Integer.MAX_VALUE - stackInSlot.func_190916_E());
            if (!simulate) {
                stackInSlot.func_190917_f(toInsert);
                if (this.onItemChanged != null) {
                    this.onItemChanged.accept(slot);
                }
            }
            if (toInsert >= maxToInsert) {
                return ItemStack.field_190927_a;
            }
            return ItemUtils.copyStackWithSize(stack, maxToInsert - toInsert);
        }
        return ItemStack.field_190927_a;
    }

    public synchronized void appendItem(@Nonnull ItemStack stack) {
        int toAppend = stack.func_190916_E();
        for (int i = 0; i < this.itemStackList.size(); ++i) {
            ItemStack stackInSlot = this.itemStackList.get(i);
            if (stackInSlot.func_190926_b()) {
                this.itemStackList.set(i, stack.func_77946_l());
                if (this.onItemChanged != null) {
                    this.onItemChanged.accept(i);
                }
                return;
            }
            if (!stackInSlot.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)stackInSlot, (ItemStack)stack)) continue;
            int maxToAppend = Math.min(stack.func_190916_E(), Integer.MAX_VALUE - stackInSlot.func_190916_E());
            stackInSlot.func_190917_f(maxToAppend);
            if (this.onItemChanged != null) {
                this.onItemChanged.accept(i);
            }
            if ((toAppend -= maxToAppend) > 0) continue;
            return;
        }
        if (toAppend > 0) {
            this.itemStackList.add(stack.func_77946_l());
            if (this.onItemChanged != null) {
                this.onItemChanged.accept(this.itemStackList.size() - 1);
            }
        }
    }

    @Nonnull
    public synchronized ItemStack extractItem(int slot, int amount, boolean simulate) {
        int trueSlot = slot;
        if (this.subItemHandler != null) {
            if (slot < this.subItemHandler.getSlots()) {
                return this.subItemHandler.extractItem(slot, amount, simulate);
            }
            trueSlot -= this.subItemHandler.getSlots();
        }
        if (trueSlot >= this.itemStackList.size()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.itemStackList.get(trueSlot);
        if (stackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (amount >= stackInSlot.func_190916_E()) {
            if (!simulate) {
                this.itemStackList.set(trueSlot, ItemStack.field_190927_a);
                if (this.onItemChanged != null) {
                    this.onItemChanged.accept(trueSlot);
                }
            }
            return stackInSlot;
        }
        if (!simulate) {
            stackInSlot.func_190918_g(amount);
            if (this.onItemChanged != null) {
                this.onItemChanged.accept(trueSlot);
            }
        }
        return ItemUtils.copyStackWithSize(stackInSlot, amount);
    }

    public int getSlotLimit(int slot) {
        if (this.subItemHandler != null && slot < this.subItemHandler.getSlots()) {
            return this.subItemHandler.getSlotLimit(slot);
        }
        return Integer.MAX_VALUE;
    }

    public boolean isEmpty() {
        return this.itemStackList.stream().allMatch(ItemStack::func_190926_b) && this.fluidStackList.stream().allMatch(Objects::isNull) && this.gasStackList.stream().allMatch(Objects::isNull);
    }

    public List<ItemStack> getItemStackList() {
        return this.itemStackList;
    }

    public List<FluidStack> getFluidStackList() {
        return this.fluidStackList;
    }

    public List<?> getGasStackList() {
        return this.gasStackList;
    }

    public void setOnItemChanged(IntConsumer onItemChanged) {
        this.onItemChanged = onItemChanged;
    }

    public void setOnFluidChanged(IntConsumer onFluidChanged) {
        this.onFluidChanged = onFluidChanged;
    }

    public void setOnGasChanged(IntConsumer onGasChanged) {
        this.onGasChanged = onGasChanged;
    }

    public IItemHandlerModifiable getSubItemHandler() {
        return this.subItemHandler;
    }

    public void setSubItemHandler(IItemHandlerModifiable subItemHandler) {
        this.subItemHandler = subItemHandler;
    }

    public IFluidHandler getSubFluidHandler() {
        return this.subFluidHandler;
    }

    public void setSubFluidHandler(IFluidHandler subFluidHandler) {
        this.subFluidHandler = subFluidHandler;
    }

    public void writeToNBT(NBTTagCompound tag, String subTagName) {
        NBTTagCompound subTag = new NBTTagCompound();
        NBTTagList fluidList = new NBTTagList();
        this.fluidStackList.stream().filter(Objects::nonNull).map(fluidStack -> fluidStack.writeToNBT(new NBTTagCompound())).forEach(arg_0 -> ((NBTTagList)fluidList).func_74742_a(arg_0));
        subTag.func_74782_a("Fluids", (NBTBase)fluidList);
        NBTTagList itemList = new NBTTagList();
        this.itemStackList.stream().filter(itemStack -> !itemStack.func_190926_b()).map(ItemStackUtils::writeNBTOversize).forEach(arg_0 -> ((NBTTagList)itemList).func_74742_a(arg_0));
        subTag.func_74782_a("Items", (NBTBase)itemList);
        if (Mods.MEKANISM.isPresent() && Mods.MEKENG.isPresent()) {
            this.writeNBTMekGas(subTag);
        }
        tag.func_74782_a(subTagName, (NBTBase)subTag);
    }

    public void readFromNBT(NBTTagCompound tag, String subTagName) {
        NBTTagCompound subTag = tag.func_74775_l(subTagName);
        this.fluidStackList.clear();
        NBTTagList fluidList = subTag.func_150295_c("Fluids", 10);
        IntStream.range(0, fluidList.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)fluidList).func_150305_b(arg_0)).map(FluidStack::loadFluidStackFromNBT).filter(Objects::nonNull).forEach(this.fluidStackList::add);
        this.itemStackList.clear();
        NBTTagList itemList = subTag.func_150295_c("Items", 10);
        IntStream.range(0, itemList.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)itemList).func_150305_b(arg_0)).map(ItemStackUtils::readNBTOversize).filter(itemStack -> !itemStack.func_190926_b()).forEach(this.itemStackList::add);
        if (Mods.MEKANISM.isPresent() && Mods.MEKENG.isPresent()) {
            this.readFromNBTMekGas(subTag);
        }
    }

    @Optional.Method(modid="mekanism")
    public void writeNBTMekGas(NBTTagCompound subTag) {
        List<?> gasStackList = this.gasStackList;
        NBTTagList gasList = new NBTTagList();
        gasStackList.stream().filter(Objects::nonNull).map(gasStack -> gasStack.write(new NBTTagCompound())).forEach(arg_0 -> ((NBTTagList)gasList).func_74742_a(arg_0));
        subTag.func_74782_a("Gases", (NBTBase)gasList);
    }

    @Optional.Method(modid="mekanism")
    public void readFromNBTMekGas(NBTTagCompound subTag) {
        List<?> gasStackList = this.gasStackList;
        gasStackList.clear();
        NBTTagList gasList = subTag.func_150295_c("Gases", 10);
        IntStream.range(0, gasList.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)gasList).func_150305_b(arg_0)).map(GasStack::readFromNBT).filter(Objects::nonNull).forEach(gasStackList::add);
    }

    @Override
    @Optional.Method(modid="mekanism")
    public GasStack drawGas(GasStack toDraw, boolean doTransfer) {
        List<?> gasStackList = this.gasStackList;
        int toDrawAmount = toDraw.amount;
        for (int i = 0; i < gasStackList.size(); ++i) {
            GasStack stackInSlot = (GasStack)gasStackList.get(i);
            if (stackInSlot == null || !stackInSlot.isGasEqual(toDraw)) continue;
            int maxCanDraw = Math.min(toDrawAmount, Integer.MAX_VALUE - stackInSlot.amount);
            if (doTransfer) {
                if (maxCanDraw >= stackInSlot.amount) {
                    gasStackList.set(i, null);
                } else {
                    stackInSlot.amount -= maxCanDraw;
                }
                if (this.onGasChanged != null) {
                    this.onGasChanged.accept(i);
                }
            }
            if ((toDrawAmount -= maxCanDraw) <= 0) break;
        }
        if (toDrawAmount == toDraw.amount) {
            return null;
        }
        return new GasStack(toDraw.getGas(), toDraw.amount - toDrawAmount);
    }

    @Optional.Method(modid="mekanism")
    public int receiveGas(@Nullable EnumFacing ignored, GasStack toReceive, boolean doTransfer) {
        if (!doTransfer) {
            return toReceive.amount;
        }
        List<?> gasStackList = this.gasStackList;
        int toReceiveAmount = toReceive.amount;
        for (int i = 0; i < gasStackList.size(); ++i) {
            GasStack stackInSlot = (GasStack)gasStackList.get(i);
            if (stackInSlot == null || !stackInSlot.isGasEqual(toReceive)) continue;
            int maxCanFill = Math.min(toReceiveAmount, Integer.MAX_VALUE - stackInSlot.amount);
            stackInSlot.amount += maxCanFill;
            if (this.onGasChanged != null) {
                this.onGasChanged.accept(i);
            }
            if ((toReceiveAmount -= maxCanFill) <= 0) break;
        }
        if (toReceiveAmount > 0) {
            gasStackList.add(new GasStack(toReceive.getGas(), toReceiveAmount));
            if (this.onGasChanged != null) {
                this.onGasChanged.accept(gasStackList.size() - 1);
            }
        }
        return toReceive.amount;
    }

    @Optional.Method(modid="mekanism")
    public GasStack drawGas(@Nullable EnumFacing ignored, int drawAmount, boolean doTransfer) {
        List<?> gasStackList = this.gasStackList;
        for (int i = 0; i < gasStackList.size(); ++i) {
            GasStack stackInSlot = (GasStack)gasStackList.get(i);
            if (stackInSlot == null) continue;
            int maxCanDraw = Math.min(drawAmount, Integer.MAX_VALUE - stackInSlot.amount);
            if (doTransfer) {
                if (maxCanDraw >= stackInSlot.amount) {
                    gasStackList.set(i, null);
                } else {
                    stackInSlot.amount -= maxCanDraw;
                }
                if (this.onGasChanged != null) {
                    this.onGasChanged.accept(i);
                }
            }
            return new GasStack(stackInSlot.getGas(), maxCanDraw);
        }
        return null;
    }

    @Optional.Method(modid="mekanism")
    public boolean canReceiveGas(@Nullable EnumFacing ignored, Gas gas) {
        return true;
    }

    @Optional.Method(modid="mekanism")
    public boolean canDrawGas(@Nullable EnumFacing ignored, Gas gas) {
        return true;
    }

    @Nonnull
    @Optional.Method(modid="mekanism")
    public GasTankInfo[] getTankInfo() {
        List<?> gasStackList = this.gasStackList;
        return (GasTankInfo[])gasStackList.stream().map(x$0 -> new InfGasTankInfo((GasStack)x$0)).toArray(GasTankInfo[]::new);
    }

    private static final class InfGasTankInfo
    implements GasTankInfo {
        private final GasStack gasStack;

        private InfGasTankInfo(GasStack gasStack) {
            this.gasStack = gasStack;
        }

        @Nullable
        public GasStack getGas() {
            return this.gasStack;
        }

        public int getStored() {
            return this.gasStack.amount;
        }

        public int getMaxGas() {
            return Integer.MAX_VALUE;
        }

        public String toString() {
            return "InfGasTankInfo[" + "gasStack=" + this.gasStack + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.gasStack != null ? this.gasStack.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(((InfGasTankInfo)arg0).gasStack, this.gasStack);
            {
            }
        }

        public GasStack gasStack() {
            return this.gasStack;
        }
    }
}

