/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.util;

import java.util.Base64;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class HashedItemStack {
    private final ItemStack stack;
    private final int stackHashCode;
    private final boolean hasTag;

    public HashedItemStack(ItemStack stack, int stackHashCode, boolean hasTag) {
        this.stack = stack;
        this.stackHashCode = stackHashCode;
        this.hasTag = hasTag;
    }

    public static HashedItemStack of(@Nonnull ItemStack stack) {
        return HashedItemStack.ofUnsafe(stack.func_77946_l());
    }

    public static HashedItemStack ofUnsafe(@Nonnull ItemStack stack) {
        boolean hasTag;
        NBTTagCompound tag = stack.func_77978_p();
        boolean bl = hasTag = tag != null && !tag.func_82582_d();
        int hash = hasTag ? Objects.hash(stack.func_77973_b(), stack.func_77984_f() ? stack.func_77952_i() : (stack.func_77981_g() ? stack.func_77960_j() : 0), tag) : Objects.hash(stack.func_77973_b(), stack.func_77984_f() ? stack.func_77952_i() : (stack.func_77981_g() ? stack.func_77960_j() : 0));
        return new HashedItemStack(stack, hash, hasTag);
    }

    public static HashedItemStack ofMeta(@Nonnull ItemStack stack) {
        return HashedItemStack.ofMetaUnsafe(stack.func_77946_l());
    }

    public static HashedItemStack ofMetaUnsafe(@Nonnull ItemStack stack) {
        return new HashedItemStack(stack, Objects.hash(stack.func_77973_b(), stack.func_77960_j()), false);
    }

    public static String stackToString(@Nonnull ItemStack stack) {
        String stackTagStr = null;
        String registryName = Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString();
        if (stack.func_77978_p() != null) {
            stackTagStr = stack.func_77978_p().toString();
        }
        return HashedItemStack.strToBase64(registryName) + "_" + stack.func_77952_i() + (stackTagStr == null ? "" : "_" + HashedItemStack.strToBase64(stackTagStr));
    }

    public static String strToBase64(String str) {
        return Base64.getEncoder().encodeToString(str.getBytes());
    }

    public boolean equals(Object o) {
        if (o instanceof HashedItemStack) {
            HashedItemStack hashedItemStack = (HashedItemStack)o;
            if (this.hasTag && !hashedItemStack.hasTag) {
                return false;
            }
            return HashedItemStack.stackEqualsNonNBT(this.stack, hashedItemStack.stack) && (!this.hasTag || ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)hashedItemStack.stack));
        }
        return false;
    }

    public static boolean stackEqualsNonNBT(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (stack.func_190926_b() && other.func_190926_b()) {
            return true;
        }
        if (stack.func_190926_b() || other.func_190926_b()) {
            return false;
        }
        Item sItem = stack.func_77973_b();
        Item oItem = other.func_77973_b();
        if (sItem.func_77614_k() || oItem.func_77614_k()) {
            return sItem.equals(other.func_77973_b()) && (stack.func_77952_i() == other.func_77952_i() || stack.func_77952_i() == Short.MAX_VALUE || other.func_77952_i() == Short.MAX_VALUE);
        }
        return sItem.equals(other.func_77973_b());
    }

    public HashedItemStack copy() {
        return new HashedItemStack(this.stack.func_77946_l(), this.stackHashCode, this.hasTag);
    }

    public int hashCode() {
        return this.stackHashCode;
    }

    public String toString() {
        return "HashedItemStack[" + "stack=" + this.stack + "," + "stackHashCode=" + this.stackHashCode + "," + "hasTag=" + this.hasTag + "]";
    }

    public ItemStack stack() {
        return this.stack;
    }

    public int stackHashCode() {
        return this.stackHashCode;
    }

    public boolean hasTag() {
        return this.hasTag;
    }
}

