/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.util;

import github.kasuminova.mmce.common.helper.IDynamicPatternInfo;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.TaggedPositionBlockArray;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.BlockArrayCache;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class DynamicPattern {
    private final String name;
    private final Set<EnumFacing> faces = EnumSet.noneOf(EnumFacing.class);
    private int minSize;
    private int maxSize;
    private BlockPos structureSizeOffsetStart = new BlockPos(0, 0, 0);
    private BlockPos structureSizeOffset = new BlockPos(0, 0, 0);
    private TaggedPositionBlockArray pattern;
    private TaggedPositionBlockArray patternEnd = null;

    public DynamicPattern(String name, TaggedPositionBlockArray pattern, TaggedPositionBlockArray patternEnd, int minSize, int maxSize) {
        this.name = name;
        this.pattern = pattern;
        this.patternEnd = patternEnd;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public DynamicPattern(String name) {
        this.name = name;
        this.pattern = new TaggedPositionBlockArray();
        this.minSize = 0;
        this.maxSize = 1;
    }

    private static BlockPos rotatePosTo(EnumFacing target, BlockPos pos) {
        if (target == EnumFacing.NORTH) {
            return pos;
        }
        BlockPos rotated = pos;
        for (EnumFacing facing = EnumFacing.NORTH; facing != target; facing = facing.func_176735_f()) {
            rotated = MiscUtils.rotateYCCW(rotated);
        }
        return rotated;
    }

    public MatchResult matches(TileMultiblockMachineController ctrl, boolean oldState, EnumFacing ctrlFace) {
        BlockPos ctrlPos = ctrl.func_174877_v();
        Set<EnumFacing> faces = this.getTrueFacing(ctrlFace);
        EnumMap<EnumFacing, Integer> matchResults = new EnumMap<EnumFacing, Integer>(EnumFacing.class);
        BlockPos facingOffset = ctrlPos.func_177971_a((Vec3i)this.getStructureSizeOffsetStart(ctrlFace));
        for (EnumFacing face : faces) {
            int size;
            TaggedPositionBlockArray pattern = BlockArrayCache.getBlockArrayCache(this.pattern, ctrlFace);
            TaggedPositionBlockArray patternEnd = null;
            if (this.patternEnd != null) {
                patternEnd = BlockArrayCache.getBlockArrayCache(this.patternEnd, ctrlFace);
            }
            if ((size = this.matchesSize(ctrl, oldState, ctrlFace, facingOffset, pattern, patternEnd)) < this.minSize) continue;
            matchResults.put(face, size);
        }
        if (matchResults.isEmpty()) {
            return new MatchResult(0, null);
        }
        return matchResults.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(entry -> new MatchResult((Integer)entry.getValue(), (EnumFacing)entry.getKey())).orElseGet(() -> new MatchResult(0, null));
    }

    private int matchesSize(TileMultiblockMachineController ctrl, boolean oldState, EnumFacing face, BlockPos facingOffset, TaggedPositionBlockArray pattern, @Nullable TaggedPositionBlockArray patternEnd) {
        int size;
        block6: {
            BlockPos offset;
            block5: {
                if (pattern == null) {
                    return 0;
                }
                offset = facingOffset;
                boolean first = true;
                size = 0;
                do {
                    if (!first) {
                        offset = offset.func_177971_a((Vec3i)this.getStructureSizeOffset(face));
                    } else {
                        first = false;
                    }
                    if (!pattern.matches(ctrl.func_145831_w(), offset, oldState, null)) break block5;
                } while (++size <= this.maxSize);
                return 0;
            }
            if (patternEnd == null || patternEnd.matches(ctrl.func_145831_w(), offset, oldState, null)) break block6;
            offset = offset.func_177973_b((Vec3i)this.getStructureSizeOffset(face));
            if (!patternEnd.matches(ctrl.func_145831_w(), offset, oldState, null)) {
                return 0;
            }
            --size;
        }
        return size;
    }

    public void addPatternToBlockArray(BlockArray toAdd, int maxSize, EnumFacing patternOffset, EnumFacing facing) {
        BlockPos finalOffset;
        BlockPos offset = this.getStructureSizeOffsetStart(facing);
        TaggedPositionBlockArray pattern = BlockArrayCache.getBlockArrayCache(this.pattern, facing);
        boolean first = true;
        for (int i = 0; i < maxSize; ++i) {
            if (!first) {
                offset = offset.func_177971_a((Vec3i)this.getStructureSizeOffset(facing));
            } else {
                first = false;
            }
            finalOffset = offset;
            pattern.getPattern().forEach((pos, info) -> toAdd.addBlock(pos.func_177971_a((Vec3i)finalOffset), (BlockArray.BlockInformation)info));
            if (!(toAdd instanceof TaggedPositionBlockArray)) continue;
            int patternIndex = i;
            pattern.getTaggedPositions().forEach((pos, tag) -> ((TaggedPositionBlockArray)toAdd).setTag(pos.func_177971_a((Vec3i)finalOffset), new ComponentSelectorTag(String.format("%s_%s_%d", tag.getTag(), this.name, patternIndex))));
        }
        if (this.patternEnd != null) {
            TaggedPositionBlockArray patternEnd = BlockArrayCache.getBlockArrayCache(this.patternEnd, facing);
            finalOffset = offset.func_177971_a((Vec3i)this.getStructureSizeOffset(facing));
            patternEnd.getPattern().forEach((pos, info) -> toAdd.addBlock(pos.func_177971_a((Vec3i)finalOffset), (BlockArray.BlockInformation)info));
            if (toAdd instanceof TaggedPositionBlockArray) {
                patternEnd.getTaggedPositions().forEach((pos, tag) -> ((TaggedPositionBlockArray)toAdd).setTag(pos.func_177971_a((Vec3i)finalOffset), new ComponentSelectorTag(String.format("%s_%s_end", tag.getTag(), this.name))));
            }
        }
    }

    private Set<EnumFacing> getTrueFacing(EnumFacing facingOffset) {
        if (facingOffset == EnumFacing.NORTH) {
            return this.faces;
        }
        return this.faces.stream().map(face -> {
            if (face == EnumFacing.UP || face == EnumFacing.DOWN) {
                return face;
            }
            EnumFacing facing = facingOffset;
            EnumFacing rotated = face;
            while (facing != EnumFacing.NORTH) {
                facing = facing.func_176735_f();
                rotated = rotated.func_176735_f();
            }
            return rotated;
        }).collect(Collectors.toSet());
    }

    public String getName() {
        return this.name;
    }

    public BlockPos getStructureSizeOffsetStart() {
        return this.structureSizeOffsetStart;
    }

    public DynamicPattern setStructureSizeOffsetStart(BlockPos structureSizeOffsetStart) {
        this.structureSizeOffsetStart = structureSizeOffsetStart;
        return this;
    }

    public BlockPos getStructureSizeOffsetStart(EnumFacing facingOffset) {
        return DynamicPattern.rotatePosTo(facingOffset, this.structureSizeOffsetStart);
    }

    public BlockPos getStructureSizeOffset() {
        return this.structureSizeOffset;
    }

    public DynamicPattern setStructureSizeOffset(BlockPos structureSizeOffset) {
        this.structureSizeOffset = structureSizeOffset;
        return this;
    }

    public BlockPos getStructureSizeOffset(EnumFacing facingOffset) {
        return DynamicPattern.rotatePosTo(facingOffset, this.structureSizeOffset);
    }

    public Set<EnumFacing> getFaces() {
        return this.faces;
    }

    public DynamicPattern addFaces(Set<EnumFacing> faces) {
        this.faces.addAll(faces);
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public DynamicPattern setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public DynamicPattern setMinSize(int minSize) {
        this.minSize = minSize;
        return this;
    }

    public TaggedPositionBlockArray getPattern() {
        return this.pattern;
    }

    public DynamicPattern setPattern(TaggedPositionBlockArray pattern) {
        this.pattern = pattern;
        return this;
    }

    public TaggedPositionBlockArray getPattern(EnumFacing patternOffset, EnumFacing facingOffset) {
        return BlockArrayCache.getBlockArrayCache(this.pattern, facingOffset);
    }

    public TaggedPositionBlockArray getPatternEnd() {
        return this.patternEnd;
    }

    public DynamicPattern setPatternEnd(TaggedPositionBlockArray patternEnd) {
        this.patternEnd = patternEnd;
        return this;
    }

    public TaggedPositionBlockArray getPatternEnd(EnumFacing patternOffset, EnumFacing facingOffset) {
        if (this.patternEnd == null) {
            return null;
        }
        return BlockArrayCache.getBlockArrayCache(this.patternEnd, patternOffset);
    }

    public static final class MatchResult {
        private final int size;
        private final EnumFacing matchFacing;

        public MatchResult(int size, EnumFacing matchFacing) {
            this.size = size;
            this.matchFacing = matchFacing;
        }

        public int size() {
            return this.size;
        }

        public boolean isMatched() {
            return this.matchFacing != null;
        }

        public String toString() {
            return "MatchResult[" + "size=" + this.size + "," + "matchFacing=" + this.matchFacing + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + this.size;
            result = 31 * result + (this.matchFacing != null ? this.matchFacing.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (((MatchResult)arg0).size != this.size) {
                return false;
            }
            return Objects.equals(((MatchResult)arg0).matchFacing, this.matchFacing);
            {
            }
        }

        public EnumFacing matchFacing() {
            return this.matchFacing;
        }
    }

    public static final class Status
    implements IDynamicPatternInfo {
        private final DynamicPattern pattern;
        private final EnumFacing matchFacing;
        private final int size;

        public Status(DynamicPattern pattern, EnumFacing matchFacing, int size) {
            this.pattern = pattern;
            this.matchFacing = matchFacing;
            this.size = size;
        }

        public static Status readFromNBT(NBTTagCompound tag, DynamicMachine machine) {
            if (!(tag.func_74764_b("size") && tag.func_74764_b("facing") && tag.func_74764_b("pattern"))) {
                return null;
            }
            DynamicPattern pattern = machine.getDynamicPatternByName(tag.func_74779_i("pattern"));
            if (pattern == null) {
                return null;
            }
            return new Status(pattern, EnumFacing.values()[tag.func_74771_c("facing")], tag.func_74765_d("size"));
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74778_a("pattern", this.pattern.name);
            tag.func_74777_a("size", (short)this.size);
            tag.func_74774_a("facing", (byte)this.matchFacing.func_176745_a());
            return tag;
        }

        @Override
        public DynamicPattern getPattern() {
            return this.pattern;
        }

        @Override
        public EnumFacing getMatchFacing() {
            return this.matchFacing;
        }

        @Override
        public String getFacing() {
            return this.matchFacing.name();
        }

        @Override
        public String getPatternName() {
            return this.pattern.name;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public int getMinSize() {
            return this.pattern.minSize;
        }

        @Override
        public int getMaxSize() {
            return this.pattern.maxSize;
        }

        public String toString() {
            return "Status[" + "pattern=" + this.pattern + "," + "matchFacing=" + this.matchFacing + "," + "size=" + this.size + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.pattern != null ? this.pattern.hashCode() : 0);
            result = 31 * result + (this.matchFacing != null ? this.matchFacing.hashCode() : 0);
            result = 31 * result + this.size;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((Status)arg0).pattern, this.pattern)) {
                return false;
            }
            if (!Objects.equals(((Status)arg0).matchFacing, this.matchFacing)) {
                return false;
            }
            return ((Status)arg0).size == this.size;
            {
            }
        }

        public DynamicPattern pattern() {
            return this.pattern;
        }

        public EnumFacing matchFacing() {
            return this.matchFacing;
        }

        public int size() {
            return this.size;
        }
    }
}

