/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.util;

import appeng.api.storage.data.IAEFluidStack;
import appeng.core.AELog;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import appeng.util.Platform;
import github.kasuminova.mmce.common.util.concurrent.ReadWriteLockProvider;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class AEFluidInventoryUpgradeable
implements IAEFluidTank,
ReadWriteLockProvider {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final AtomicReference<IAEFluidStack>[] fluids;
    private final IAEFluidInventory handler;
    private int capacity;
    private IFluidTankProperties[] props = null;
    private boolean oneFluidOneSlot = false;

    public AEFluidInventoryUpgradeable(IAEFluidInventory handler, int slots, int capacity) {
        this.fluids = new AtomicReference[slots];
        for (int i = 0; i < slots; ++i) {
            this.fluids[i] = new AtomicReference();
        }
        this.handler = handler;
        this.capacity = capacity;
    }

    public AEFluidInventoryUpgradeable(IAEFluidInventory handler, int slots) {
        this(handler, slots, Integer.MAX_VALUE);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.onContentChanged(slot);
        }
    }

    public boolean isOneFluidOneSlot() {
        return this.oneFluidOneSlot;
    }

    public void setOneFluidOneSlot(boolean oneFluidOneSlot) {
        this.oneFluidOneSlot = oneFluidOneSlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFluidInSlot(int slot, IAEFluidStack fluid) {
        try {
            this.rwLock.writeLock().lock();
            if (slot >= 0 && slot < this.getSlots()) {
                if (Objects.equals(this.getFluid(slot), fluid)) {
                    if (fluid != null && fluid.getStackSize() != this.getFluid(slot).getStackSize()) {
                        this.getFluid(slot).setStackSize(fluid.getStackSize());
                        this.onContentChanged(slot);
                    }
                } else {
                    if (fluid == null) {
                        this.setFluid(slot, null);
                    } else {
                        IAEFluidStack newFluid = fluid.copy();
                        newFluid.setStackSize(fluid.getStackSize());
                        this.setFluid(slot, newFluid);
                    }
                    this.onContentChanged(slot);
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private IAEFluidStack getFluid(int slot) {
        return this.fluids[slot].get();
    }

    private void setFluid(int slot, IAEFluidStack fluid) {
        this.fluids[slot].set(fluid);
    }

    private void onContentChanged(int slot) {
        if (this.handler != null && Platform.isServer()) {
            this.handler.onFluidInventoryChanged((IAEFluidTank)this, slot);
        }
    }

    public IAEFluidStack getFluidInSlot(int slot) {
        try {
            this.rwLock.readLock().lock();
            if (slot >= 0 && slot < this.getSlots()) {
                IAEFluidStack iAEFluidStack = this.getFluid(slot);
                return iAEFluidStack;
            }
            IAEFluidStack iAEFluidStack = null;
            return iAEFluidStack;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public int getSlots() {
        return this.fluids.length;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.props == null) {
            this.props = new IFluidTankProperties[this.getSlots()];
            for (int i = 0; i < this.getSlots(); ++i) {
                this.props[i] = new FluidTankPropertiesWrapper(i);
            }
        }
        return this.props;
    }

    public int fill(int slot, FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        IAEFluidStack fluid = this.getFluid(slot);
        if (fluid != null && !fluid.getFluidStack().isFluidEqual(resource)) {
            return 0;
        }
        int amountToStore = this.capacity;
        if (fluid != null) {
            amountToStore -= (int)fluid.getStackSize();
        }
        amountToStore = Math.min(amountToStore, resource.amount);
        if (doFill) {
            if (fluid == null) {
                this.setFluidInSlot(slot, (IAEFluidStack)AEFluidStack.fromFluidStack((FluidStack)resource).setStackSize((long)amountToStore));
            } else {
                fluid.setStackSize(fluid.getStackSize() + (long)amountToStore);
                this.onContentChanged(slot);
            }
        }
        return amountToStore;
    }

    public FluidStack drain(int slot, FluidStack resource, boolean doDrain) {
        IAEFluidStack fluid = this.getFluid(slot);
        if (fluid == null || !fluid.getFluidStack().isFluidEqual(resource)) {
            return null;
        }
        return this.drain(slot, resource.amount, doDrain);
    }

    public FluidStack drain(int slot, int maxDrain, boolean doDrain) {
        IAEFluidStack fluid = this.getFluid(slot);
        if (fluid == null || maxDrain <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (fluid.getStackSize() < (long)drained) {
            drained = (int)fluid.getStackSize();
        }
        FluidStack stack = new FluidStack(fluid.getFluid(), drained);
        if (doDrain) {
            fluid.setStackSize(fluid.getStackSize() - (long)drained);
            if (fluid.getStackSize() <= 0L) {
                this.setFluid(slot, null);
            }
            this.onContentChanged(slot);
        }
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(FluidStack fluid, boolean doFill) {
        FluidStack insert;
        block6: {
            int i;
            if (fluid == null || fluid.amount <= 0) {
                return 0;
            }
            insert = fluid.copy();
            (doFill ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            if (!this.oneFluidOneSlot) break block6;
            int found = -1;
            for (i = 0; i < this.fluids.length; ++i) {
                IAEFluidStack fluidInSlot = this.getFluid(i);
                if (fluidInSlot == null || fluidInSlot.getFluid() != insert.getFluid()) continue;
                found = i;
                break;
            }
            if (found == -1) break block6;
            i = this.fill(found, insert, doFill);
            (doFill ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return i;
        }
        try {
            int totalFillAmount = 0;
            for (int slot = 0; slot < this.getSlots(); ++slot) {
                int fillAmount = this.fill(slot, insert, doFill);
                totalFillAmount += fillAmount;
                insert.amount -= fillAmount;
                if (insert.amount <= 0) break;
            }
            int n = totalFillAmount;
            (doFill ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return n;
        }
        catch (Throwable throwable) {
            (doFill ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluidStack drain(FluidStack fluid, boolean doDrain) {
        if (fluid == null || fluid.amount <= 0) {
            return null;
        }
        FluidStack resource = fluid.copy();
        try {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            FluidStack totalDrained = null;
            for (int slot = 0; slot < this.getSlots(); ++slot) {
                FluidStack drain = this.drain(slot, resource, doDrain);
                if (drain == null) continue;
                if (totalDrained == null) {
                    totalDrained = drain;
                } else {
                    totalDrained.amount += drain.amount;
                }
                resource.amount -= drain.amount;
                if (resource.amount <= 0) break;
            }
            FluidStack fluidStack = totalDrained;
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return fluidStack;
        }
        catch (Throwable throwable) {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain == 0) {
            return null;
        }
        FluidStack totalDrained = null;
        int toDrain = maxDrain;
        try {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).lock();
            for (int slot = 0; slot < this.getSlots(); ++slot) {
                if (totalDrained == null) {
                    totalDrained = this.drain(slot, toDrain, doDrain);
                    if (totalDrained != null) {
                        toDrain -= totalDrained.amount;
                    }
                } else {
                    FluidStack copy = totalDrained.copy();
                    copy.amount = toDrain;
                    FluidStack drain = this.drain(slot, copy, doDrain);
                    if (drain != null) {
                        totalDrained.amount += drain.amount;
                        toDrain -= drain.amount;
                    }
                }
                if (toDrain <= 0) break;
            }
            FluidStack fluidStack = totalDrained;
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            return fluidStack;
        }
        catch (Throwable throwable) {
            (doDrain ? this.rwLock.writeLock() : this.rwLock.readLock()).unlock();
            throw throwable;
        }
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = new NBTTagCompound();
        this.writeToNBT(c);
        data.func_74782_a(name, (NBTBase)c);
    }

    private void writeToNBT(NBTTagCompound target) {
        for (int x = 0; x < this.fluids.length; ++x) {
            try {
                NBTTagCompound c = new NBTTagCompound();
                if (this.getFluid(x) != null) {
                    this.getFluid(x).writeToNBT(c);
                }
                target.func_74782_a("#" + x, (NBTBase)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = data.func_74775_l(name);
        if (!c.func_82582_d()) {
            this.readFromNBT(c);
        }
    }

    private void readFromNBT(NBTTagCompound target) {
        for (int x = 0; x < this.fluids.length; ++x) {
            try {
                NBTTagCompound c = target.func_74775_l("#" + x);
                if (c.func_82582_d()) continue;
                this.setFluid(x, AEFluidStack.fromNBT((NBTTagCompound)c));
                continue;
            }
            catch (Exception e) {
                AELog.debug((Throwable)e);
            }
        }
    }

    @Override
    @Nonnull
    public ReadWriteLock getRWLock() {
        return this.rwLock;
    }

    private class FluidTankPropertiesWrapper
    implements IFluidTankProperties {
        private final int slot;

        private FluidTankPropertiesWrapper(int slot) {
            this.slot = slot;
        }

        public FluidStack getContents() {
            IAEFluidStack fluid = AEFluidInventoryUpgradeable.this.getFluid(this.slot);
            return fluid == null ? null : fluid.getFluidStack();
        }

        public int getCapacity() {
            IAEFluidStack fluid = AEFluidInventoryUpgradeable.this.getFluid(this.slot);
            if (fluid == null) {
                return AEFluidInventoryUpgradeable.this.capacity;
            }
            return Math.max(AEFluidInventoryUpgradeable.this.capacity, (int)fluid.getStackSize());
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return fluidStack != null;
        }
    }
}

