/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.upgrade;

import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UpgradeType {
    private final Set<DynamicMachine> compatibleMachines = new HashSet<DynamicMachine>();
    private final Set<DynamicMachine> incompatibleMachines = new HashSet<DynamicMachine>();
    private final String name;
    private final String localizedName;
    private final float level;
    private final int maxStackSize;

    public UpgradeType(String name, String localizedName, float level, int maxStackSize) {
        this.name = name;
        this.localizedName = localizedName;
        this.level = level;
        this.maxStackSize = maxStackSize;
    }

    public Set<DynamicMachine> getCompatibleMachines() {
        return Collections.unmodifiableSet(this.compatibleMachines);
    }

    public void addCompatibleMachine(DynamicMachine machine) {
        if (this.incompatibleMachines.contains(machine)) {
            throw new IllegalArgumentException("Already set this machine in the list of compatible machines, cannot add this machine to the list of incompatible machines!");
        }
        this.compatibleMachines.add(machine);
    }

    public void addIncompatibleMachine(DynamicMachine machine) {
        if (this.compatibleMachines.contains(machine)) {
            throw new IllegalArgumentException("Already set this machine in the list of incompatible machines, cannot add this machine to the list of compatible machines!");
        }
        this.incompatibleMachines.add(machine);
    }

    public Set<DynamicMachine> getIncompatibleMachines() {
        return Collections.unmodifiableSet(this.incompatibleMachines);
    }

    public boolean isCompatible(DynamicMachine machine) {
        if (!this.compatibleMachines.isEmpty()) {
            return this.compatibleMachines.contains(machine);
        }
        if (!this.incompatibleMachines.isEmpty()) {
            return !this.incompatibleMachines.contains(machine);
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return I18n.func_188566_a((String)this.localizedName) ? I18n.func_135052_a((String)this.localizedName, (Object[])new Object[0]) : this.localizedName;
    }

    public float getLevel() {
        return this.level;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpgradeType)) {
            return false;
        }
        return this.name.equals(((UpgradeType)obj).name);
    }
}

