/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.upgrade;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import github.kasuminova.mmce.common.upgrade.DynamicMachineUpgrade;
import github.kasuminova.mmce.common.upgrade.UpgradeType;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.IFunction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="mods.modularmachinery.SimpleDynamicMachineUpgrade")
public class SimpleDynamicMachineUpgrade
extends DynamicMachineUpgrade {
    private IFunction<SimpleDynamicMachineUpgrade, String[]> descriptionHandler = null;
    private IFunction<SimpleDynamicMachineUpgrade, String[]> busGuiDescriptionHandler = null;
    private NBTTagCompound itemData = new NBTTagCompound();
    private NBTTagCompound customData = new NBTTagCompound();

    public SimpleDynamicMachineUpgrade(UpgradeType type) {
        super(type);
    }

    @ZenGetter(value="itemData")
    public IData getItemData() {
        return CraftTweakerMC.getIDataModifyable((NBTBase)this.itemData);
    }

    @ZenSetter(value="itemData")
    public void setItemData(IData itemData) {
        this.itemData = CraftTweakerMC.getNBTCompound((IData)itemData);
    }

    @ZenGetter(value="customData")
    public IData getCustomData() {
        return CraftTweakerMC.getIDataModifyable((NBTBase)this.customData);
    }

    @ZenSetter(value="customData")
    public void setCustomData(IData customData) {
        this.customData = CraftTweakerMC.getNBTCompound((IData)customData);
    }

    @ZenGetter(value="parentStack")
    public IItemStack getParentStackCT() {
        return CraftTweakerMC.getIItemStack((ItemStack)this.parentStack);
    }

    @ZenMethod
    public void decrementItemDurability(int durability) {
        if (this.valid && this.parentBus != null && this.busInventoryIndex != -1 && !this.parentStack.func_190926_b() && this.parentStack.func_77984_f()) {
            int maxDamage = this.parentStack.func_77958_k();
            int itemDamage = this.parentStack.func_77952_i();
            if (itemDamage + durability >= maxDamage) {
                this.parentBus.getInventory().setStackInSlot(this.busInventoryIndex, ItemStack.field_190927_a);
            } else {
                ItemStack copied = this.parentStack.func_77946_l();
                copied.func_77964_b(itemDamage + durability);
                this.parentBus.getInventory().setStackInSlot(this.busInventoryIndex, copied);
            }
        }
    }

    public void setDescriptionHandler(IFunction<SimpleDynamicMachineUpgrade, String[]> handler) {
        this.descriptionHandler = handler;
    }

    public void setBusGUIDescriptionHandler(IFunction<SimpleDynamicMachineUpgrade, String[]> handler) {
        this.busGuiDescriptionHandler = handler;
    }

    @Override
    public void readItemNBT(NBTTagCompound tag) {
        this.itemData = tag;
    }

    @Override
    public NBTTagCompound writeItemNBT() {
        return this.itemData;
    }

    @Override
    public void readNBT(NBTTagCompound tag) {
        super.readNBT(tag);
        this.customData = tag;
    }

    @Override
    public NBTTagCompound writeNBT() {
        return this.customData;
    }

    @Override
    public List<String> getDescriptions() {
        return this.descriptionHandler == null ? Collections.emptyList() : Arrays.asList(this.descriptionHandler.apply(this));
    }

    @Override
    public List<String> getBusGUIDescriptions() {
        return this.busGuiDescriptionHandler == null ? Collections.emptyList() : Arrays.asList(this.busGuiDescriptionHandler.apply(this));
    }

    @Override
    public SimpleDynamicMachineUpgrade copy(ItemStack owner) {
        SimpleDynamicMachineUpgrade upgrade = new SimpleDynamicMachineUpgrade(this.getType());
        upgrade.descriptionHandler = this.descriptionHandler;
        upgrade.busGuiDescriptionHandler = this.busGuiDescriptionHandler;
        upgrade.eventProcessor.putAll(this.eventProcessor);
        upgrade.parentStack = owner;
        return upgrade;
    }

    public boolean upgradeEquals(Object obj) {
        if (!(obj instanceof SimpleDynamicMachineUpgrade)) {
            return false;
        }
        return this.type.equals(((SimpleDynamicMachineUpgrade)obj).type);
    }

    @Override
    public boolean equals(Object obj) {
        return false;
    }
}

