/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.upgrade;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.upgrade.UpgradeType;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.helper.UpgradeEventHandlerCT;
import hellfirepvp.modularmachinery.common.tiles.TileUpgradeBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;

@ZenRegister
@ZenClass(value="mods.modularmachinery.MachineUpgrade")
public abstract class MachineUpgrade {
    protected final UpgradeType type;
    protected final Map<Class<?>, List<UpgradeEventHandlerCT>> eventProcessor = new HashMap();
    protected TileUpgradeBus parentBus = null;
    protected int stackSize = 1;

    public MachineUpgrade(UpgradeType type) {
        this.type = type;
    }

    public void readNBT(NBTTagCompound tag) {
    }

    public NBTTagCompound writeNBT() {
        return new NBTTagCompound();
    }

    public abstract MachineUpgrade copy(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    public abstract List<String> getDescriptions();

    public abstract List<String> getBusGUIDescriptions();

    public void addEventHandler(Class<?> eventClass, UpgradeEventHandlerCT handler) {
        this.eventProcessor.computeIfAbsent(eventClass, v -> new ArrayList()).add(handler);
    }

    public List<UpgradeEventHandlerCT> getEventHandlers(Class<?> eventClass) {
        return this.eventProcessor.getOrDefault(eventClass, Collections.emptyList());
    }

    public TileUpgradeBus getParentBus() {
        return this.parentBus;
    }

    public MachineUpgrade setParentBus(TileUpgradeBus parentBus) {
        this.parentBus = parentBus;
        return this;
    }

    public int incrementStackSize(int increment) {
        return this.stackSize += increment;
    }

    public int decrementStackSize(int decrement) {
        return this.stackSize -= decrement;
    }

    @ZenGetter(value="stackSize")
    public int getStackSize() {
        return this.stackSize;
    }

    public UpgradeType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MachineUpgrade)) {
            return false;
        }
        MachineUpgrade another = (MachineUpgrade)obj;
        return this.type.equals(another.type);
    }
}

