/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.tile;

import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import appeng.me.GridAccessException;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FakeGases;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import github.kasuminova.mmce.client.gui.GuiMEPatternProvider;
import github.kasuminova.mmce.common.container.ContainerMEPatternProvider;
import github.kasuminova.mmce.common.event.machine.MachineEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeFinishEvent;
import github.kasuminova.mmce.common.network.PktMEPatternProviderHandlerItems;
import github.kasuminova.mmce.common.tile.base.MEMachineComponent;
import github.kasuminova.mmce.common.util.AEFluidInventoryUpgradeable;
import github.kasuminova.mmce.common.util.InfItemFluidHandler;
import github.kasuminova.mmce.common.util.PatternItemFilter;
import github.kasuminova.mmce.common.util.Sides;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTileNotifiable;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MEPatternProvider
extends MEMachineComponent
implements ICraftingProvider,
IAEAppEngInventory,
IAEFluidInventory,
MachineComponentTileNotifiable {
    public static final int PATTERNS = 36;
    public static final int SUB_ITEM_HANDLER_SLOTS = 2;
    protected final AppEngInternalInventory subItemHandler = new AppEngInternalInventory((IAEAppEngInventory)this, 2);
    protected final AEFluidInventoryUpgradeable subFluidHandler = new AEFluidInventoryUpgradeable(this, 1, Integer.MAX_VALUE);
    protected final InfItemFluidHandler handler = new InfItemFluidHandler((IItemHandlerModifiable)this.subItemHandler, (IFluidHandler)this.subFluidHandler);
    protected final AppEngInternalInventory patterns = new AppEngInternalInventory((IAEAppEngInventory)this, 36, 1, (IAEItemFilter)PatternItemFilter.INSTANCE);
    protected final List<ICraftingPatternDetails> details = new ObjectArrayList(36);
    protected WorkModeSetting workMode = WorkModeSetting.DEFAULT;
    protected volatile boolean machineCompleted = true;
    protected boolean shouldReturnItems = false;
    protected boolean handlerDirty = false;
    protected int currentPatternIdx = -1;
    protected ICraftingPatternDetails currentPattern = null;

    public MEPatternProvider() {
        IntStream.range(0, 36).mapToObj(i -> null).forEach(this.details::add);
        this.handler.setOnItemChanged(slot -> {
            this.handlerDirty = true;
            this.markChunkDirty();
        });
        this.handler.setOnFluidChanged(slot -> {
            this.handlerDirty = true;
            this.markChunkDirty();
        });
        if (Mods.MEKANISM.isPresent() && Mods.MEKENG.isPresent()) {
            this.handler.setOnGasChanged(slot -> {
                this.handlerDirty = true;
                this.markChunkDirty();
            });
        }
    }

    @Override
    public ItemStack getVisualItemStack() {
        return new ItemStack(ItemsMM.mePatternProvider, 1);
    }

    @Override
    @Nullable
    public MachineComponent<InfItemFluidHandler> provideComponent() {
        return new MachineComponent<InfItemFluidHandler>(IOType.INPUT){

            @Override
            public ComponentType getComponentType() {
                return ComponentTypesMM.COMPONENT_ITEM_FLUID_GAS;
            }

            @Override
            public InfItemFluidHandler getContainerProvider() {
                return MEPatternProvider.this.handler;
            }
        };
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged change) {
        this.notifyNeighbors();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange change) {
        this.notifyNeighbors();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (!this.proxy.isActive() || !this.proxy.isPowered()) {
            return;
        }
        this.details.stream().filter(Objects::nonNull).forEach(detail -> craftingTracker.addCraftingOption((ICraftingMedium)this, detail));
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (!this.acceptsPattern(patternDetails)) {
            return false;
        }
        int slots = table.func_70302_i_();
        for (int slot = 0; slot < slots; ++slot) {
            GasStack gasStack;
            FluidStack fluidStack;
            ItemStack stackInSlot = table.func_70301_a(slot);
            if (stackInSlot.func_190926_b()) continue;
            if (Mods.AE2FCR.isPresent() && FakeFluids.isFluidFakeItem((ItemStack)stackInSlot) && (fluidStack = (FluidStack)FakeItemRegister.getStack((ItemStack)stackInSlot)) != null) {
                this.handler.fill(fluidStack, true);
                continue;
            }
            if (Mods.MEKENG.isPresent() && FakeGases.isGasFakeItem((ItemStack)stackInSlot) && (gasStack = (GasStack)FakeItemRegister.getStack((ItemStack)stackInSlot)) != null) {
                this.handler.receiveGas(null, gasStack, true);
                continue;
            }
            this.handler.appendItem(stackInSlot);
        }
        this.handleNewPattern(patternDetails);
        this.machineCompleted = this.workMode != WorkModeSetting.CRAFTING_LOCK_MODE;
        return true;
    }

    private boolean acceptsPattern(ICraftingPatternDetails patternDetails) {
        if (patternDetails.isCraftable() || !this.proxy.isActive() || !this.proxy.isPowered()) {
            return false;
        }
        return this.workMode != WorkModeSetting.ENHANCED_BLOCKING_MODE || this.handler.isEmpty() || this.currentPattern == null || this.currentPattern.equals(patternDetails);
    }

    private void handleNewPattern(ICraftingPatternDetails patternDetails) {
        if (this.workMode == WorkModeSetting.ENHANCED_BLOCKING_MODE) {
            if (!patternDetails.equals(this.currentPattern)) {
                this.setCurrentPattern(patternDetails);
            }
        } else {
            this.resetCurrentPattern();
        }
    }

    @Override
    public void notifyNeighbors() {
        if (this.getProxy().isActive()) {
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        Platform.notifyBlocksOfNeighbors((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    public boolean isBusy() {
        return this.workMode == WorkModeSetting.CRAFTING_LOCK_MODE && !this.machineCompleted || this.workMode == WorkModeSetting.BLOCKING_MODE && !this.handler.isEmpty();
    }

    protected void refreshPatterns() {
        for (int i = 0; i < 36; ++i) {
            this.refreshPattern(i);
        }
        if (this.currentPatternIdx != -1 && this.currentPatternIdx < this.details.size()) {
            this.setCurrentPattern(this.details.get(this.currentPatternIdx));
        }
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected void refreshPattern(int slot) {
        this.details.set(slot, null);
        ItemStack pattern = this.patterns.getStackInSlot(slot);
        Item item = pattern.func_77973_b();
        if (pattern.func_190926_b() || !(item instanceof ICraftingPatternItem)) {
            return;
        }
        ICraftingPatternItem patternItem = (ICraftingPatternItem)item;
        ICraftingPatternDetails detail = patternItem.getPatternForItem(pattern, this.func_145831_w());
        if (detail != null && !detail.isCraftable()) {
            this.details.set(slot, detail);
        }
        if (this.workMode == WorkModeSetting.ENHANCED_BLOCKING_MODE && slot == this.currentPatternIdx && !this.currentPattern.equals(detail)) {
            this.resetCurrentPattern();
        }
    }

    public void returnItemsScheduled() {
        if (!this.shouldReturnItems) {
            this.shouldReturnItems = true;
            ModularMachinery.EXECUTE_MANAGER.addSyncTask(this::returnItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnItems() {
        if (!(this.shouldReturnItems && this.proxy.isActive() && this.proxy.isPowered())) {
            return;
        }
        this.shouldReturnItems = false;
        this.machineCompleted = true;
        try {
            InfItemFluidHandler infItemFluidHandler = this.handler;
            synchronized (infItemFluidHandler) {
                List<ItemStack> itemStackList = this.handler.getItemStackList();
                List<FluidStack> fluidStackList = this.handler.getFluidStackList();
                IItemStorageChannel itemChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
                IMEMonitor itemInv = this.proxy.getStorage().getInventory((IStorageChannel)itemChannel);
                for (int i = 0; i < itemStackList.size(); ++i) {
                    ItemStack stack = itemStackList.get(i);
                    if (stack.func_190926_b()) continue;
                    IAEItemStack notInserted = this.insertStackToAE(itemInv, (IAEItemStack)itemChannel.createStack((Object)stack));
                    if (notInserted != null) {
                        itemStackList.set(i, notInserted.createItemStack());
                        continue;
                    }
                    itemStackList.set(i, ItemStack.field_190927_a);
                }
                IFluidStorageChannel fluidChannel = (IFluidStorageChannel)AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
                IMEMonitor fluidInv = this.proxy.getStorage().getInventory((IStorageChannel)fluidChannel);
                for (int i = 0; i < fluidStackList.size(); ++i) {
                    FluidStack stack = fluidStackList.get(i);
                    if (stack == null) continue;
                    IAEFluidStack notInserted = this.insertStackToAE(fluidInv, (IAEFluidStack)fluidChannel.createStack((Object)stack));
                    if (notInserted != null) {
                        fluidStackList.set(i, notInserted.getFluidStack());
                        continue;
                    }
                    fluidStackList.set(i, null);
                }
                if (Mods.MEKANISM.isPresent() && Mods.MEKENG.isPresent()) {
                    this.returnGases();
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.handlerDirty = true;
        this.markChunkDirty();
    }

    @Optional.Method(modid="mekeng")
    private void returnGases() throws GridAccessException {
        List<?> gasStackList = this.handler.getGasStackList();
        IGasStorageChannel gasChannel = (IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
        IMEMonitor gasInv = this.proxy.getStorage().getInventory((IStorageChannel)gasChannel);
        for (int i = 0; i < gasStackList.size(); ++i) {
            GasStack stack = (GasStack)gasStackList.get(i);
            if (stack == null) continue;
            IAEGasStack notInserted = this.insertStackToAE(gasInv, (IAEGasStack)gasChannel.createStack((Object)stack));
            if (notInserted != null) {
                gasStackList.set(i, notInserted.getGasStack());
                continue;
            }
            gasStackList.set(i, null);
        }
    }

    private <T extends IAEStack<T>> T insertStackToAE(IMEMonitor<T> inv, T stack) throws GridAccessException {
        if (stack == null) {
            return null;
        }
        return (T)Platform.poweredInsert((IEnergySource)this.proxy.getEnergy(), inv, (IAEStack)stack.copy(), (IActionSource)this.source);
    }

    private void resetCurrentPattern() {
        this.currentPatternIdx = -1;
        this.currentPattern = null;
    }

    private void setCurrentPattern(ICraftingPatternDetails pattern) {
        if (pattern == null) {
            this.resetCurrentPattern();
            return;
        }
        this.currentPatternIdx = this.details.indexOf(pattern);
        this.currentPattern = pattern;
    }

    public AppEngInternalInventory getSubItemHandler() {
        return this.subItemHandler;
    }

    public AEFluidInventoryUpgradeable getSubFluidHandler() {
        return this.subFluidHandler;
    }

    public InfItemFluidHandler getInfHandler() {
        return this.handler;
    }

    public AppEngInternalInventory getPatterns() {
        return this.patterns;
    }

    public WorkModeSetting getWorkMode() {
        return this.workMode;
    }

    public void setWorkMode(WorkModeSetting workMode) {
        this.workMode = workMode;
        if (workMode != WorkModeSetting.CRAFTING_LOCK_MODE) {
            this.machineCompleted = true;
        }
        if (workMode != WorkModeSetting.ENHANCED_BLOCKING_MODE) {
            this.resetCurrentPattern();
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        Capability cap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        if (capability == cap) {
            return (T)cap.cast((Object)this.patterns);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.readProviderNBT(compound);
        if (compound.func_74764_b("machineCompleted")) {
            this.machineCompleted = compound.func_74767_n("machineCompleted");
        }
        if (Sides.isRunningOnClient()) {
            this.processClientGUIUpdate();
        }
    }

    public void readProviderNBT(NBTTagCompound compound) {
        this.subItemHandler.readFromNBT(compound, "subItemHandler");
        this.subFluidHandler.readFromNBT(compound, "subFluidHandler");
        this.handler.readFromNBT(compound, "handler");
        this.patterns.readFromNBT(compound, "patterns");
        this.workMode = WorkModeSetting.values()[compound.func_74771_c("workMode")];
        if (compound.func_74764_b("currentPatternIdx") && this.workMode == WorkModeSetting.ENHANCED_BLOCKING_MODE) {
            this.currentPatternIdx = compound.func_74771_c("currentPatternIdx");
        } else {
            this.resetCurrentPattern();
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        this.writeProviderNBT(compound);
        compound.func_74757_a("machineCompleted", this.machineCompleted);
    }

    public NBTTagCompound writeProviderNBT(NBTTagCompound compound) {
        this.handler.writeToNBT(compound, "handler");
        this.patterns.writeToNBT(compound, "patterns");
        this.subItemHandler.writeToNBT(compound, "subItemHandler");
        this.subFluidHandler.writeToNBT(compound, "subFluidHandler");
        if (this.workMode != WorkModeSetting.DEFAULT) {
            compound.func_74774_a("workMode", (byte)this.workMode.ordinal());
        }
        if (!this.handler.isEmpty() && this.currentPatternIdx != -1) {
            compound.func_74774_a("currentPatternIdx", (byte)this.currentPatternIdx);
        }
        return compound;
    }

    public boolean isAllDefault() {
        if (IntStream.range(0, this.subItemHandler.getSlots()).mapToObj(arg_0 -> ((AppEngInternalInventory)this.subItemHandler).getStackInSlot(arg_0)).anyMatch(stackInSlot -> !stackInSlot.func_190926_b())) {
            return false;
        }
        if (this.subFluidHandler.getFluidInSlot(0) != null) {
            return false;
        }
        if (IntStream.range(0, this.patterns.getSlots()).mapToObj(arg_0 -> ((AppEngInternalInventory)this.patterns).getStackInSlot(arg_0)).anyMatch(stackInSlot -> !stackInSlot.func_190926_b())) {
            return false;
        }
        return this.workMode == WorkModeSetting.DEFAULT && this.handler.isEmpty();
    }

    public void sendHandlerItemsToClient() {
        if (this.field_145850_b.field_72995_K || !this.handlerDirty) {
            return;
        }
        ArrayList players = new ArrayList();
        this.field_145850_b.field_73010_i.stream().filter(EntityPlayerMP.class::isInstance).map(EntityPlayerMP.class::cast).forEach(playerMP -> {
            ContainerMEPatternProvider cPatternProvider;
            Container patt19322$temp = playerMP.field_71070_bA;
            if (patt19322$temp instanceof ContainerMEPatternProvider && (cPatternProvider = (ContainerMEPatternProvider)patt19322$temp).getOwner() == this) {
                players.add(playerMP);
            }
        });
        if (!players.isEmpty()) {
            PktMEPatternProviderHandlerItems message = new PktMEPatternProviderHandlerItems(this);
            players.forEach(player -> ModularMachinery.NET_CHANNEL.sendTo((IMessage)message, player));
        }
        this.handlerDirty = false;
    }

    @SideOnly(value=Side.CLIENT)
    protected void processClientGUIUpdate() {
        GuiMEPatternProvider providerGUI;
        GuiScreen currentScreen;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && (currentScreen = Minecraft.func_71410_x().field_71462_r) instanceof GuiMEPatternProvider && (providerGUI = (GuiMEPatternProvider)currentScreen).getOwner() == this) {
            providerGUI.updateGUIState();
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            ModularMachinery.EXECUTE_MANAGER.addSyncTask(this::refreshPatterns);
        }
    }

    public void saveChanges() {
        this.markNoUpdateSync();
    }

    @Override
    public void markChunkDirty() {
        super.markChunkDirty();
        if (this.handlerDirty && !this.field_145850_b.field_72995_K) {
            ModularMachinery.EXECUTE_MANAGER.addSyncTask(this::sendHandlerItemsToClient);
        }
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.refreshPattern(slot);
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        this.markChunkDirty();
    }

    @Override
    public void onMachineEvent(MachineEvent event) {
        if ((event instanceof RecipeFinishEvent || event instanceof FactoryRecipeFinishEvent) && !this.machineCompleted) {
            this.machineCompleted = true;
            ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> event.getController().setSearchRecipeImmediately(true));
        }
    }

    public static enum WorkModeSetting {
        DEFAULT,
        BLOCKING_MODE,
        CRAFTING_LOCK_MODE,
        ENHANCED_BLOCKING_MODE;

    }
}

