/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.tile;

import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.util.Platform;
import github.kasuminova.mmce.common.tile.base.MEItemBus;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class MEItemOutputBus
extends MEItemBus {
    @Override
    public IOInventory buildInventory() {
        int size = 36;
        int[] slotIDs = new int[size];
        for (int slotID = 0; slotID < slotIDs.length; ++slotID) {
            slotIDs[slotID] = slotID;
        }
        IOInventory inv = new IOInventory(this, new int[0], slotIDs);
        inv.setStackLimit(Integer.MAX_VALUE, slotIDs);
        inv.setListener(slot -> {
            MEItemOutputBus mEItemOutputBus = this;
            synchronized (mEItemOutputBus) {
                this.changedSlots[slot.intValue()] = true;
            }
        });
        return inv;
    }

    @Override
    public ItemStack getVisualItemStack() {
        return new ItemStack(ItemsMM.meItemOutputBus);
    }

    @Override
    @Nullable
    public MachineComponent.ItemBus provideComponent() {
        return new MachineComponent.ItemBus(IOType.OUTPUT){

            @Override
            public IOInventory getContainerProvider() {
                return MEItemOutputBus.this.inventory;
            }
        };
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(5, 60, !this.hasItem(), true);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.proxy.isActive()) {
            return TickRateModulation.IDLE;
        }
        int[] needUpdateSlots = this.getNeedUpdateSlots();
        if (needUpdateSlots.length == 0) {
            return TickRateModulation.SLOWER;
        }
        this.inTick = true;
        boolean successAtLeastOnce = false;
        ReadWriteLock rwLock = this.inventory.getRWLock();
        try {
            rwLock.writeLock().lock();
            IMEMonitor inv = this.proxy.getStorage().getInventory((IStorageChannel)this.channel);
            for (int slot : needUpdateSlots) {
                ItemStack extracted;
                IAEItemStack aeStack;
                this.changedSlots[slot] = false;
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.func_190926_b() || (aeStack = (IAEItemStack)this.channel.createStack((Object)(extracted = this.inventory.extractItem(slot, stack.func_190916_E(), false)))) == null) continue;
                IAEItemStack left = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.proxy.getEnergy(), (IMEInventory)inv, (IAEStack)aeStack, (IActionSource)this.source);
                if (left != null) {
                    this.inventory.setStackInSlot(slot, left.createItemStack());
                    if (aeStack.getStackSize() == left.getStackSize()) continue;
                    successAtLeastOnce = true;
                    continue;
                }
                successAtLeastOnce = true;
            }
            this.inTick = false;
            rwLock.writeLock().unlock();
            return successAtLeastOnce ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        catch (GridAccessException e) {
            this.inTick = false;
            this.changedSlots = new boolean[this.changedSlots.length];
            rwLock.writeLock().unlock();
            return TickRateModulation.IDLE;
        }
    }

    @Override
    public void markNoUpdate() {
        if (this.proxy.isActive() && this.hasChangedSlots()) {
            try {
                this.proxy.getTick().alertDevice(this.proxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        super.markNoUpdate();
    }
}

