/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.tile;

import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import appeng.me.GridAccessException;
import appeng.util.Platform;
import github.kasuminova.mmce.common.tile.base.MEFluidBus;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MEFluidInputBus
extends MEFluidBus {
    private final AEFluidInventory config = new AEFluidInventory((IAEFluidInventory)this, 9);

    @Override
    public ItemStack getVisualItemStack() {
        return new ItemStack(ItemsMM.meFluidInputBus);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.config.readFromNBT(compound, "config");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        this.config.writeToNBT(compound, "config");
    }

    public IAEFluidTank getConfig() {
        return this.config;
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(10, 120, !this.needsUpdate(), true);
    }

    private boolean needsUpdate() {
        int capacity = this.tanks.getCapacity();
        for (int slot = 0; slot < this.config.getSlots(); ++slot) {
            IAEFluidStack cfgStack = this.config.getFluidInSlot(slot);
            IAEFluidStack invStack = this.tanks.getFluidInSlot(slot);
            if (cfgStack == null) {
                if (invStack == null) continue;
                return true;
            }
            if (invStack == null) {
                return true;
            }
            if (cfgStack.equals(invStack) && invStack.getStackSize() == (long)capacity) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.proxy.isActive()) {
            return TickRateModulation.IDLE;
        }
        int[] needUpdateSlots = this.getNeedUpdateSlots();
        if (needUpdateSlots.length == 0) {
            return TickRateModulation.SLOWER;
        }
        ReadWriteLock rwLock = this.tanks.getRWLock();
        try {
            rwLock.writeLock().lock();
            boolean successAtLeastOnce = false;
            this.inTick = true;
            IMEMonitor inv = this.proxy.getStorage().getInventory((IStorageChannel)this.channel);
            int capacity = this.tanks.getCapacity();
            for (int slot : needUpdateSlots) {
                IAEFluidStack stack;
                this.changedSlots[slot] = false;
                IAEFluidStack cfgStack = this.config.getFluidInSlot(slot);
                IAEFluidStack invStack = this.tanks.getFluidInSlot(slot);
                if (cfgStack == null) {
                    if (invStack == null) continue;
                    this.tanks.setFluidInSlot(slot, this.insertStackToAE((IMEMonitor<IAEFluidStack>)inv, invStack));
                    continue;
                }
                if (!cfgStack.equals(invStack)) {
                    IAEFluidStack stack2;
                    if (invStack != null && (stack2 = this.insertStackToAE((IMEMonitor<IAEFluidStack>)inv, invStack)) != null) {
                        this.tanks.setFluidInSlot(slot, stack2);
                        continue;
                    }
                    stack2 = this.extractStackFromAE((IMEMonitor<IAEFluidStack>)inv, (IAEFluidStack)cfgStack.copy().setStackSize((long)capacity));
                    this.tanks.setFluidInSlot(slot, stack2);
                    if (stack2 == null) continue;
                    successAtLeastOnce = true;
                    continue;
                }
                if ((long)capacity == invStack.getStackSize()) continue;
                if ((long)capacity > invStack.getStackSize()) {
                    int countToReceive = (int)((long)capacity - invStack.getStackSize());
                    stack = this.extractStackFromAE((IMEMonitor<IAEFluidStack>)inv, (IAEFluidStack)invStack.copy().setStackSize((long)countToReceive));
                    if (stack == null) continue;
                    this.tanks.setFluidInSlot(slot, (IAEFluidStack)invStack.copy().setStackSize(invStack.getStackSize() + stack.getStackSize()));
                    successAtLeastOnce = true;
                    continue;
                }
                int countToExtract = (int)(invStack.getStackSize() - (long)capacity);
                stack = this.insertStackToAE((IMEMonitor<IAEFluidStack>)inv, (IAEFluidStack)invStack.copy().setStackSize((long)countToExtract));
                if (stack == null) {
                    this.tanks.setFluidInSlot(slot, (IAEFluidStack)invStack.copy().setStackSize(invStack.getStackSize() - (long)countToExtract));
                } else {
                    this.tanks.setFluidInSlot(slot, (IAEFluidStack)invStack.copy().setStackSize(invStack.getStackSize() - (long)countToExtract + stack.getStackSize()));
                }
                successAtLeastOnce = true;
            }
            this.inTick = false;
            rwLock.writeLock().unlock();
            return successAtLeastOnce ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        catch (GridAccessException e) {
            this.inTick = false;
            this.changedSlots = new boolean[9];
            rwLock.writeLock().unlock();
            return TickRateModulation.IDLE;
        }
    }

    private IAEFluidStack extractStackFromAE(IMEMonitor<IAEFluidStack> inv, IAEFluidStack stack) throws GridAccessException {
        return (IAEFluidStack)Platform.poweredExtraction((IEnergySource)this.proxy.getEnergy(), inv, (IAEStack)stack.copy(), (IActionSource)this.source);
    }

    private IAEFluidStack insertStackToAE(IMEMonitor<IAEFluidStack> inv, IAEFluidStack stack) throws GridAccessException {
        return (IAEFluidStack)Platform.poweredInsert((IEnergySource)this.proxy.getEnergy(), inv, (IAEStack)stack.copy(), (IActionSource)this.source);
    }

    @Override
    @Nullable
    public MachineComponent<IFluidHandler> provideComponent() {
        return new MachineComponent.FluidHatch(IOType.INPUT){

            @Override
            public IFluidHandler getContainerProvider() {
                return MEFluidInputBus.this.tanks;
            }
        };
    }

    @Override
    public void markNoUpdate() {
        if (this.proxy.isActive() && this.needsUpdate()) {
            try {
                this.proxy.getTick().alertDevice(this.proxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        super.markNoUpdate();
    }
}

