/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.network;

import github.kasuminova.mmce.client.gui.GuiMEPatternProvider;
import github.kasuminova.mmce.common.tile.MEPatternProvider;
import github.kasuminova.mmce.common.util.InfItemFluidHandler;
import hellfirepvp.modularmachinery.common.base.Mods;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import mekanism.api.gas.GasStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktMEPatternProviderHandlerItems
implements IMessage,
IMessageHandler<PktMEPatternProviderHandlerItems, IMessage> {
    private final List<ItemStack> itemStackList = new ArrayList<ItemStack>();
    private final List<FluidStack> fluidStackList = new ArrayList<FluidStack>();
    private final List<?> gasStackList = new ArrayList();

    public PktMEPatternProviderHandlerItems() {
    }

    public PktMEPatternProviderHandlerItems(MEPatternProvider patternProvider) {
        InfItemFluidHandler infHandler = patternProvider.getInfHandler();
        infHandler.getItemStackList().stream().filter(stack -> !stack.func_190926_b()).forEach(this.itemStackList::add);
        infHandler.getFluidStackList().stream().filter(Objects::nonNull).forEach(this.fluidStackList::add);
        if (Mods.MEKANISM.isPresent() && Mods.MEKENG.isPresent()) {
            this.addGasToList(infHandler);
        }
    }

    @Optional.Method(modid="mekanism")
    private void addGasToList(InfItemFluidHandler infHandler) {
        List<?> gasStackList = this.gasStackList;
        infHandler.getGasStackList().stream().filter(Objects::nonNull).map(GasStack.class::cast).forEach(gasStackList::add);
    }

    public void fromBytes(ByteBuf buf) {
        int itemStackListSize = buf.readInt();
        IntStream.range(0, itemStackListSize).mapToObj(i -> ByteBufUtils.readItemStack((ByteBuf)buf)).filter(read -> !read.func_190926_b()).forEach(this.itemStackList::add);
        int fluidStackListSize = buf.readInt();
        IntStream.range(0, fluidStackListSize).mapToObj(i -> FluidStack.loadFluidStackFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf))).filter(Objects::nonNull).forEach(this.fluidStackList::add);
        if (Mods.MEKANISM.isPresent() && Mods.MEKENG.isPresent()) {
            this.fromBytesMekGas(buf);
        }
    }

    @Optional.Method(modid="mekanism")
    private void fromBytesMekGas(ByteBuf buf) {
        List<?> gasStackList = this.gasStackList;
        int gasStackListSize = buf.readInt();
        IntStream.range(0, gasStackListSize).mapToObj(i -> GasStack.readFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf))).filter(Objects::nonNull).forEach(gasStackList::add);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.itemStackList.size());
        this.itemStackList.forEach(stack -> ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack));
        buf.writeInt(this.fluidStackList.size());
        this.fluidStackList.forEach(stack -> ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.writeToNBT(new NBTTagCompound())));
        if (Mods.MEKANISM.isPresent() && Mods.MEKENG.isPresent()) {
            this.toBytesMekGas(buf);
        }
    }

    @Optional.Method(modid="mekanism")
    private void toBytesMekGas(ByteBuf buf) {
        List<?> gasStackList = this.gasStackList;
        buf.writeInt(gasStackList.size());
        gasStackList.forEach(stack -> ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.write(new NBTTagCompound())));
    }

    public IMessage onMessage(PktMEPatternProviderHandlerItems message, MessageContext ctx) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            PktMEPatternProviderHandlerItems.processPacket(message);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected static void processPacket(PktMEPatternProviderHandlerItems message) {
        List<ItemStack> itemStackList = message.itemStackList;
        List<FluidStack> fluidStackList = message.fluidStackList;
        List<?> gasStackList = message.gasStackList;
        GuiScreen cur = Minecraft.func_71410_x().field_71462_r;
        if (!(cur instanceof GuiMEPatternProvider)) {
            return;
        }
        GuiMEPatternProvider patternProvider = (GuiMEPatternProvider)cur;
        Minecraft.func_71410_x().func_152344_a(() -> patternProvider.setStackList(itemStackList, fluidStackList, gasStackList));
    }
}

