/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.machine.pattern;

import github.kasuminova.mmce.common.machine.pattern.SpecialItemBlockProxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class SpecialItemBlockProxyRegistry {
    public static final SpecialItemBlockProxyRegistry INSTANCE = new SpecialItemBlockProxyRegistry();
    private final Map<String, SpecialItemBlockProxy> proxyRegistry = new HashMap<String, SpecialItemBlockProxy>();

    private SpecialItemBlockProxyRegistry() {
    }

    public Map<String, SpecialItemBlockProxy> getRegistry() {
        return Collections.unmodifiableMap(this.proxyRegistry);
    }

    public SpecialItemBlockProxy register(String name, SpecialItemBlockProxy proxy) {
        if (this.proxyRegistry.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate SpecialTileEntityProxy proxy key: " + name);
        }
        this.proxyRegistry.put(name, proxy);
        return proxy;
    }

    public void unregister(String name) {
        this.proxyRegistry.remove(name);
    }

    @Nullable
    public SpecialItemBlockProxy getValidProxy(ItemStack te) {
        for (SpecialItemBlockProxy proxy : this.proxyRegistry.values()) {
            if (!proxy.isValid(te)) continue;
            return proxy;
        }
        return null;
    }
}

