/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.machine.component;

import github.kasuminova.mmce.common.machine.component.MachineComponentProxy;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;

public class MachineComponentProxyRegistry {
    public static final MachineComponentProxyRegistry INSTANCE = new MachineComponentProxyRegistry();
    private final Map<String, MachineComponentProxy<?>> proxyRegistry = new HashMap();

    private MachineComponentProxyRegistry() {
    }

    public Map<String, MachineComponentProxy<?>> getRegistry() {
        return Collections.unmodifiableMap(this.proxyRegistry);
    }

    public <T extends MachineComponent<?>> MachineComponentProxy<T> register(String name, MachineComponentProxy<T> proxy) {
        if (this.proxyRegistry.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate MachineComponentProxy proxy key: " + name);
        }
        this.proxyRegistry.put(name, proxy);
        return proxy;
    }

    public void unregister(String name) {
        this.proxyRegistry.remove(name);
    }

    @Nullable
    public MachineComponent<?> proxy(TileEntity te) {
        for (MachineComponentProxy<?> proxy : this.proxyRegistry.values()) {
            if (!proxy.isSupported(te)) continue;
            return proxy.proxyComponent(te);
        }
        return null;
    }
}

