/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.itemtype;

import github.kasuminova.mmce.common.helper.AdvancedItemChecker;
import github.kasuminova.mmce.common.helper.AdvancedItemModifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class IngredientStack {
    public final IngredientType ingredientType;
    public String oreDictName = "";
    public ItemStack itemStack;
    public int count;
    public int minCount;
    public int maxCount;
    public NBTTagCompound tag = null;
    public AdvancedItemChecker itemChecker = null;
    public List<AdvancedItemModifier> itemModifierList = new ArrayList<AdvancedItemModifier>();

    public IngredientStack(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.minCount = this.count = itemStack.func_190916_E();
        this.maxCount = this.count;
        this.ingredientType = IngredientType.ITEMSTACK;
    }

    public IngredientStack(String oreDictName, int count) {
        this.itemStack = null;
        this.oreDictName = oreDictName;
        this.count = count;
        this.minCount = count;
        this.maxCount = count;
        this.ingredientType = IngredientType.ORE_DICT;
    }

    public IngredientStack copy() {
        IngredientStack ingredientStack;
        switch (this.ingredientType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ITEMSTACK: {
                IngredientStack ingredient = new IngredientStack(this.itemStack.func_77946_l());
                ingredient.minCount = this.minCount;
                ingredient.maxCount = this.maxCount;
                ingredient.tag = this.tag;
                ingredient.itemChecker = this.itemChecker;
                ingredient.itemModifierList.addAll(this.itemModifierList);
                ingredientStack = ingredient;
                break;
            }
            case ORE_DICT: {
                IngredientStack ingredient = new IngredientStack(this.oreDictName, this.count);
                ingredient.minCount = this.minCount;
                ingredient.maxCount = this.maxCount;
                ingredient.tag = this.tag;
                ingredient.itemChecker = this.itemChecker;
                ingredient.itemModifierList.addAll(this.itemModifierList);
                ingredientStack = ingredient;
                break;
            }
        }
        return ingredientStack;
    }

    public static enum IngredientType {
        ITEMSTACK,
        ORE_DICT;

    }
}

