/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.integration.gregtech.handlerproxy;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class GTFluidTankProxy
implements IFluidHandler {
    private final IFluidTank fluidTank;

    public GTFluidTankProxy(IFluidTank fluidTank) {
        this.fluidTank = fluidTank;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new GTFluidTankProp(this.fluidTank)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.fluidTank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack content = this.fluidTank.getFluid();
        if (content == null || !content.isFluidEqual(resource)) {
            return null;
        }
        return this.fluidTank.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.fluidTank.drain(maxDrain, doDrain);
    }

    private static final class GTFluidTankProp
    implements IFluidTankProperties {
        private final IFluidTank fluidTank;

        private GTFluidTankProp(IFluidTank fluidTank) {
            this.fluidTank = fluidTank;
        }

        @Nullable
        public FluidStack getContents() {
            return this.fluidTank.getFluid();
        }

        public int getCapacity() {
            return this.fluidTank.getCapacity();
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return true;
        }

        public String toString() {
            return "GTFluidTankProp[" + "fluidTank=" + this.fluidTank + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.fluidTank != null ? this.fluidTank.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(((GTFluidTankProp)arg0).fluidTank, this.fluidTank);
            {
            }
        }

        public IFluidTank fluidTank() {
            return this.fluidTank;
        }
    }
}

